/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.util;

import clashsoft.cslib.util.CSString;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class CSSource
extends CSString {
    public static boolean isQuoted(String string, int pos) {
        return CSSource.isQuoted(CSSource.analyseSource(string, pos));
    }

    public static boolean isQuoted(int[] data) {
        return (data[4] & 1) != 0;
    }

    public static boolean isCharQuoted(String string, int pos) {
        return CSSource.isCharQuoted(CSSource.analyseSource(string, pos));
    }

    public static boolean isCharQuoted(int[] data) {
        return (data[4] & 2) != 0;
    }

    public static boolean isLiteral(String string, int pos) {
        return CSSource.isLiteral(CSSource.analyseSource(string, pos));
    }

    public static boolean isLiteral(int[] data) {
        return (data[4] & 4) != 0;
    }

    public static int getParenthesisDepth(String string, int pos) {
        return CSSource.getParenthesisDepth(CSSource.analyseSource(string, pos));
    }

    public static int getParenthesisDepth(int[] data) {
        return data[0];
    }

    public static int getSquareBracketDepth(String string, int pos) {
        return CSSource.getSquareBracketDepth(CSSource.analyseSource(string, pos));
    }

    public static int getSquareBracketDepth(int[] data) {
        return data[1];
    }

    public static int getCurlyBracketDepth(String string, int pos) {
        return CSSource.getCurlyBracketDepth(CSSource.analyseSource(string, pos));
    }

    public static int getCurlyBracketDepth(int[] data) {
        return data[2];
    }

    public static int getAngleBracketDepth(String string, int pos) {
        return CSSource.getAngleBracketDepth(CSSource.analyseSource(string, pos));
    }

    public static int getAngleBracketDepth(int[] data) {
        return data[3];
    }

    public static int[] analyseSource(String string, int pos) {
        int depth1 = 0;
        int depth2 = 0;
        int depth3 = 0;
        int depth4 = 0;
        int other = 0;
        boolean quote = false;
        boolean charQuote = false;
        boolean literal = false;
        for (int i = 0; i < pos && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!literal) {
                if (c == '\"') {
                    quote = !quote;
                    continue;
                }
                if (c == '\'') {
                    charQuote = !charQuote;
                    continue;
                }
                if (c == '\\') {
                    literal = true;
                    continue;
                }
                if (quote || charQuote) continue;
                switch (c) {
                    case '(': {
                        ++depth1;
                    }
                    case ')': {
                        --depth1;
                    }
                    case '[': {
                        ++depth2;
                    }
                    case ']': {
                        --depth2;
                    }
                    case '{': {
                        ++depth3;
                    }
                    case '}': {
                        --depth3;
                    }
                    case '<': {
                        ++depth4;
                    }
                    case '>': {
                        --depth4;
                    }
                }
                continue;
            }
            literal = false;
        }
        other = (literal ? 4 : 0) | (charQuote ? 2 : 0) | (quote ? 1 : 0);
        return new int[]{depth1, depth2, depth3, depth4, other};
    }

    public static List<String> codeSplit(String text, char split) {
        int len = text.length();
        ArrayList<String> result = new ArrayList<String>();
        int depth1 = 0;
        int depth2 = 0;
        int depth3 = 0;
        int depth4 = 0;
        boolean quote = false;
        int index = 0;
        char current = '\u0000';
        int last = 0;
        int i = 0;
        while (i < len) {
            int i0 = i + 1;
            current = text.charAt(i);
            if (last != 92) {
                if (current == '\"') {
                    quote = !quote;
                } else if (!quote) {
                    if (current == '(') {
                        ++depth1;
                    } else if (current == ')') {
                        --depth1;
                    } else if (current == '[') {
                        ++depth2;
                    } else if (current == ']') {
                        --depth2;
                    } else if (current == '{') {
                        ++depth3;
                    } else if (current == '}') {
                        --depth3;
                    } else if (current == '<') {
                        ++depth4;
                    } else if (current == '>') {
                        --depth4;
                    }
                }
                if (!quote && depth1 == 0 && depth2 == 0 && depth3 == 0 && depth4 == 0) {
                    if (current == split) {
                        result.add(text.substring(index, i));
                        index = i0;
                    } else if (i0 == len) {
                        result.add(text.substring(index, i0));
                    }
                }
            }
            last = current;
            i = i0;
        }
        return result;
    }

    public static String stripComments(String string) {
        int len = string.length();
        StringBuilder result = new StringBuilder(len);
        boolean quote = false;
        boolean charQuote = false;
        boolean literal = false;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (!literal) {
                if (c == '\"') {
                    quote = !quote;
                } else if (c == '\'') {
                    charQuote = !charQuote;
                } else if (c == '\\') {
                    literal = true;
                } else if (!quote && !charQuote && c == '/' && i + 1 < string.length()) {
                    char c1 = string.charAt(i + 1);
                    if (c1 == '/') {
                        i = string.indexOf("\n", i) - 1;
                        continue;
                    }
                    if (c1 == '*') {
                        i = string.indexOf("*/", i + 1) + 1;
                        continue;
                    }
                }
            } else {
                literal = false;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String replaceLiterals(String string) {
        int len = string.length();
        StringBuilder result = new StringBuilder(len);
        boolean literal = false;
        for (int i = 0; i < len; ++i) {
            int c = string.charAt(i);
            if (!literal) {
                if (c == 92) {
                    literal = true;
                    continue;
                }
            } else {
                literal = false;
                if (c == 110) {
                    c = 10;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 98) {
                    c = 8;
                } else if (c == 117 && i + 5 < len) {
                    String u = string.substring(i + 1, i + 5);
                    c = (char)Integer.parseInt(u, 16);
                    i += 4;
                }
            }
            result.append((char)c);
        }
        return result.toString();
    }

    public static List<Class<?>> getClassesForPackage(Package pack) {
        String packageName = pack.getName();
        ArrayList classes = new ArrayList();
        File directory = null;
        String relPath = packageName.replace('.', '/');
        URL resource = ClassLoader.getSystemClassLoader().getResource(relPath);
        if (resource == null) {
            throw new RuntimeException("No resource for " + relPath);
        }
        String fullPath = resource.getFile();
        try {
            directory = new File(resource.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(packageName + " (" + resource + ") does not appear to be a valid URL / URI.  Strange, since we got it from the system...", e);
        }
        catch (IllegalArgumentException e) {
            directory = null;
        }
        if (directory != null && directory.exists()) {
            String[] files = directory.list();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".class")) continue;
                String className = packageName + '.' + files[i].substring(0, files[i].length() - 6);
                try {
                    classes.add(Class.forName(className));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("ClassNotFoundException loading " + className);
                }
            }
        } else {
            try {
                String jarPath = fullPath.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
                JarFile jarFile = new JarFile(jarPath);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(relPath) || entryName.length() <= relPath.length() + "/".length()) continue;
                    String className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
                    try {
                        classes.add(Class.forName(className));
                    }
                    catch (ClassNotFoundException e) {
                        jarFile.close();
                        throw new RuntimeException("ClassNotFoundException loading " + className);
                    }
                }
                jarFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(packageName + " (" + directory + ") does not appear to be a valid package", e);
            }
        }
        return classes;
    }
}

