/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.reflect;

import clashsoft.cslib.reflect.Immutable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class ImmutableObjectFactory {
    public static Map<Class, Map<Object[], Object>> objects = new HashMap<Class, Map<Object[], Object>>();

    public static <T> T createObject(Class<T> clazz, Object ... args) {
        Class[] classes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            classes[i] = args[i] != null ? args[i].getClass() : Object.class;
        }
        return ImmutableObjectFactory.createObject(clazz, classes, args);
    }

    public static <T> T createObject(Class<T> clazz, Class[] argsTypes, Object ... args) {
        Map<Object[], Object> map = objects.get(clazz);
        if (map != null) {
            Object obj = map.get(args);
            if (obj != null) {
                return ImmutableObjectFactory.cast(clazz, obj);
            }
        } else {
            try {
                Constructor<T> c = clazz.getConstructor(argsTypes);
                T obj = c.newInstance(args);
                ImmutableObjectFactory.addToMap(clazz, args, obj);
                return ImmutableObjectFactory.cast(clazz, obj);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T cast(Class<T> clazz, Object object) {
        return (T)object;
    }

    public static final void checkImmutable(Class clazz) {
        if (!ImmutableObjectFactory.isImmutable(clazz)) {
            throw new IllegalArgumentException(clazz + " is not immutable! Sign with @Immutable annotation");
        }
    }

    public static boolean isImmutable(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.isAssignableFrom(Number.class) || clazz.isAssignableFrom(String.class)) {
            return true;
        }
        if (clazz.isAnnotationPresent(Immutable.class)) {
            return true;
        }
        return clazz.getSimpleName().toLowerCase().startsWith("immutable");
    }

    public static void addToMap(Class clazz, Object[] args, Object object) {
        Map<Object[], Object> map = objects.get(clazz);
        if (map == null) {
            map = new HashMap<Object[], Object>();
        }
        map.put(args, object);
        objects.put(clazz, map);
    }
}

