/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.update;

import clashsoft.cslib.minecraft.CSLib;
import clashsoft.cslib.minecraft.update.CheckUpdateThread;
import clashsoft.cslib.minecraft.update.ModUpdate;
import clashsoft.cslib.minecraft.util.CSWeb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class CSUpdate {
    public static Map<String, ModUpdate> updates = new HashMap<String, ModUpdate>();
    public static Map<String, String[]> updateFiles = new HashMap<String, String[]>();
    public static final String CURRENT_VERSION = "1.7.2";
    public static final String CLASHSOFT_ADFLY = "http://adf.ly/2175784/";
    public static final String CLASHSOFT_UPDATE_NOTES = "https://dl.dropboxusercontent.com/s/pxm1ki6wbtxlvuv/update.txt";

    public static String version(int rev) {
        return "1.7.2-" + rev;
    }

    public static String version(int major, int minor, int rev) {
        return String.format("%s_%d.%d.%d", CURRENT_VERSION, major, minor, rev);
    }

    public static String version(String version) {
        return String.format("%s_%s", CURRENT_VERSION, version);
    }

    public static ModUpdate readUpdateLine(String line, String modName, String acronym, String version) {
        boolean flag = modName == null;
        int i0 = line.indexOf(58);
        int i1 = line.indexOf(61);
        int i2 = line.lastIndexOf(64);
        if (i0 == -1) {
            return null;
        }
        String key = line.substring(0, i0);
        if (flag || key.equals(modName) || key.equals(acronym)) {
            String newVersion = line.substring(i0 + 1, i1);
            String updateNotes = null;
            String updateUrl = null;
            if (i1 != -1) {
                updateNotes = line.substring(i1 + 1, i2 == -1 ? line.length() : i2);
            }
            if (i2 != -1) {
                updateUrl = line.substring(i2 + 1);
            }
            return new ModUpdate(flag ? key : modName, version, newVersion, updateNotes, updateUrl);
        }
        return null;
    }

    public static List<ModUpdate> getUpdates(boolean invalidUpdates) {
        Collection<ModUpdate> collection = updates.values();
        ArrayList<ModUpdate> list = new ArrayList<ModUpdate>(collection.size());
        if (invalidUpdates) {
            list.addAll(collection);
        } else {
            for (ModUpdate update : collection) {
                if (!update.isValid()) continue;
                list.add(update);
            }
        }
        return list;
    }

    public static ModUpdate addUpdate(ModUpdate update) {
        if (update != null) {
            updates.put(update.getModName(), update);
        }
        return update;
    }

    public static ModUpdate getUpdate(String modName) {
        return updates.get(modName);
    }

    public static ModUpdate getUpdate(String modName, String acronym) {
        ModUpdate update = CSUpdate.getUpdate(modName);
        if (update == null) {
            update = CSUpdate.getUpdate(acronym);
        }
        return update;
    }

    public static String[] getUpdateFile(String url) {
        String[] updateFile = updateFiles.get(url);
        if (updateFile == null) {
            updateFile = CSWeb.readWebsite(url);
            updateFiles.put(url, updateFile);
        }
        return updateFile;
    }

    public static void updateCheck(String url) {
        new CheckUpdateThread(url).start();
    }

    public static void updateCheck(String[] updateFile) {
        new CheckUpdateThread(updateFile).start();
    }

    public static void updateCheck(String modName, String acronym, String version, String url) {
        new CheckUpdateThread(modName, acronym, version, url).start();
    }

    public static void updateCheck(String modName, String acronym, String version, String[] updateFile) {
        new CheckUpdateThread(modName, acronym, version, updateFile).start();
    }

    public static void notifyAll(EntityPlayer player) {
        List<ModUpdate> updates = CSUpdate.getUpdates(false);
        if (!updates.isEmpty()) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("update.found", new Object[0]));
            for (ModUpdate update : updates) {
                CSUpdate.notify(player, update);
            }
        }
    }

    public static void notify(EntityPlayer player, ModUpdate update) {
        if (update != null && update.isValid()) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("update.notification", new Object[]{update.getModName(), update.getNewVersion(), update.getVersion()}));
            if (update.getUpdateNotes().length > 0) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("update.notes", new Object[0]));
                for (String line : update.getUpdateNotes()) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(line));
                }
            }
            if (CSLib.autoUpdate) {
                update.install(player);
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("update.automatic.disabled", new Object[]{update.getModName()}));
            }
        }
    }

    public static void update(EntityPlayer player, String modName) {
        ModUpdate update = CSUpdate.getUpdate(modName);
        if (update != null) {
            update.install(player);
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("update.none", new Object[]{modName}));
        }
    }

    public static void updateAll(EntityPlayer player) {
        if (!updates.isEmpty()) {
            for (ModUpdate update : updates.values()) {
                update.install(player);
            }
        }
    }

    public static int compareVersion(String version1, String version2) {
        int i;
        if (version1 == null) {
            return version2 == null ? 0 : -1;
        }
        if (version2 == null) {
            return 1;
        }
        if (version1.equals(version2)) {
            return 0;
        }
        String[] split1 = version1.split("\\p{Punct}");
        String[] split2 = version2.split("\\p{Punct}");
        int len = Math.max(split1.length, split2.length);
        int[] ints1 = new int[len];
        int[] ints2 = new int[len];
        for (i = 0; i < split1.length; ++i) {
            ints1[i] = CSUpdate.versionNumber(split1[i]);
        }
        for (i = 0; i < split2.length; ++i) {
            ints2[i] = CSUpdate.versionNumber(split2[i]);
        }
        for (i = len - 1; i >= 0; --i) {
            int compare = Integer.compare(ints1[i], ints2[i]);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    protected static int versionNumber(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            if ("dev".equalsIgnoreCase(s)) {
                return -4;
            }
            if ("pre".equalsIgnoreCase(s)) {
                return -3;
            }
            if ("alpha".equalsIgnoreCase(s)) {
                return -2;
            }
            if ("beta".equalsIgnoreCase(s)) {
                return -1;
            }
            return 0;
        }
    }
}

