/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.item.datatools;

import clashsoft.cslib.minecraft.item.datatools.DataToolSet;
import clashsoft.cslib.minecraft.item.datatools.ItemDataHoe;
import clashsoft.cslib.minecraft.item.datatools.ItemDataSword;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemDataTool
extends ItemTool {
    public float toolDamage;
    private Set<Block> blocksEffectiveAgainst;
    private String toolType;
    public Map<String, IIcon> icons = new HashMap<String, IIcon>();
    public DataToolSet toolSet;

    public ItemDataTool(float toolDamage, Item.ToolMaterial material, Set<Block> blocksEffectiveAgainst, String type) {
        super(toolDamage, material, blocksEffectiveAgainst);
        this.blocksEffectiveAgainst = blocksEffectiveAgainst;
        this.toolType = type;
        this.toolDamage = toolDamage;
        this.setNoRepair();
    }

    public static Item.ToolMaterial getToolMaterial(ItemStack stack) {
        if (stack != null) {
            ItemDataTool item = (ItemDataTool)stack.func_77973_b();
            return item.toolSet.getToolMaterial(stack);
        }
        return null;
    }

    public static ItemStack setToolMaterial(ItemStack stack, Item.ToolMaterial toolMaterial) {
        if (stack != null) {
            ItemDataTool item = (ItemDataTool)stack.func_77973_b();
            return item.toolSet.setToolMaterial(stack, toolMaterial);
        }
        return stack;
    }

    public void registerMaterial(Item.ToolMaterial material, String name) {
        this.toolSet.registerToolMaterial(material, name);
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return this.func_77650_f(stack);
    }

    public IIcon func_77650_f(ItemStack stack) {
        return this.icons.get(this.toolSet.getToolMaterial(stack));
    }

    public int getMaxDamage(ItemStack stack) {
        Item.ToolMaterial tm = this.toolSet.getToolMaterial(stack);
        if (tm != null) {
            return tm.func_77997_a();
        }
        return this.field_77862_b.func_77997_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        for (String key : this.toolSet.nameToMaterial.keySet()) {
            IIcon icon = iconRegister.func_94245_a(this.toolType + key);
            this.icons.put(key, icon);
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.icons.get(this.toolSet.getMaterialName(stack));
    }

    public String func_77653_i(ItemStack stack) {
        return StatCollector.func_74838_a((String)(this.toolSet.getMaterialName(stack) + " " + this.toolType));
    }

    public float getDigSpeed(ItemStack stack, Block block, int metadata) {
        if (this.blocksEffectiveAgainst.contains(block)) {
            Item.ToolMaterial tm = this.toolSet.getToolMaterial(stack);
            if (tm == null) {
                tm = this.field_77862_b;
            }
            return tm.func_77998_b();
        }
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase living, EntityLivingBase living2) {
        if (!(this instanceof ItemDataSword) && !(this instanceof ItemDataHoe)) {
            stack.func_77972_a(2, living);
        }
        return true;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            stack.func_77972_a(1, living);
        }
        return true;
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.toolDamage, 0));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return this.field_77862_b.func_77995_e();
    }

    public String func_77861_e() {
        return this.field_77862_b.toString();
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairItem) {
        Item.ToolMaterial tm = this.toolSet.getToolMaterial(stack);
        if (tm == null) {
            tm = this.field_77862_b;
        }
        return tm.customCraftingMaterial == repairItem.func_77973_b() ? true : super.func_82789_a(stack, repairItem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (Item.ToolMaterial tm : this.toolSet.materials) {
            ItemStack stack = new ItemStack((Item)this);
            list.add(this.toolSet.setToolMaterial(stack, tm));
        }
    }
}

