/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.item;

import clashsoft.cslib.minecraft.item.meta.IMetaItem;
import clashsoft.cslib.minecraft.lang.I18n;
import clashsoft.cslib.util.CSArrays;
import clashsoft.cslib.util.CSString;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class CustomItem
extends Item {
    public static final String FORCEHIDE = "%&";
    public String[] names;
    public String[] iconNames;
    public CreativeTabs[] tabs;
    public IIcon[] icons;
    public boolean[] enabled;
    public List<IMetaItem> subItems;
    public List<IMetaItem> shownSubItems;

    public CustomItem(List<IMetaItem> subItems, List<IMetaItem> showSubItems) {
        this.subItems = subItems;
        this.shownSubItems = showSubItems;
    }

    public CustomItem(String[] names, String[] iconNames, CreativeTabs[] tabs) {
        this.names = names;
        this.iconNames = iconNames;
        this.tabs = tabs;
        this.enabled = new boolean[this.names.length];
        Arrays.fill(this.enabled, true);
        this.func_77627_a(names.length > 1);
    }

    public CustomItem(String[] names, String[] iconNames) {
        this(names, iconNames, null);
    }

    public CustomItem(String[] names, String domain, CreativeTabs[] tabs) {
        this(names, CSString.concatAll(names, domain + ":", ""), tabs);
    }

    public CustomItem(String[] names, String domain) {
        this(names, domain, null);
    }

    public CustomItem(String names, String iconName, CreativeTabs tab) {
        this(CSArrays.create(names), CSArrays.create(iconName), CSArrays.create(tab));
    }

    public CustomItem(String name, String iconName) {
        this(CSArrays.create(name), CSArrays.create(iconName));
    }

    public CreativeTabs[] getCreativeTabs() {
        if (this.tabs == null) {
            this.tabs = new CreativeTabs[]{this.func_77640_w()};
        }
        return this.tabs;
    }

    public CreativeTabs getCreativeTab(int metadata) {
        if (this.tabs == null) {
            return this.func_77640_w();
        }
        return this.tabs[metadata % this.tabs.length];
    }

    public CustomItem addSubItem(IMetaItem metaItem) {
        if (metaItem != null) {
            this.subItems.add(metaItem);
            if (metaItem.isEnabled()) {
                this.shownSubItems.add(metaItem);
            }
        }
        return this;
    }

    public boolean hasItemMetadataList() {
        return this.subItems != null && this.shownSubItems != null;
    }

    public CustomItem setMetadataEnabled(boolean enabled, int ... metadata) {
        if (metadata != null) {
            for (int i : metadata) {
                this.enabled[i] = enabled;
            }
        }
        return this;
    }

    public String func_77667_c(ItemStack stack) {
        if (this.hasItemMetadataList()) {
            return this.subItems.get(stack.func_77960_j()).getName();
        }
        return this.func_77658_a() + "." + this.names[stack.func_77960_j()];
    }

    public IIcon func_77617_a(int damage) {
        return this.icons[damage];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        if (this.hasItemMetadataList()) {
            this.icons = new IIcon[this.subItems.size()];
            for (int i = 0; i < this.subItems.size(); ++i) {
                String iconName = this.subItems.get(i).getIconName();
                this.icons[i] = iconRegister.func_94245_a(iconName);
            }
        } else {
            this.icons = new IIcon[this.iconNames.length];
            for (int i = 0; i < this.iconNames.length; ++i) {
                String iconName = this.iconNames[i];
                this.icons[i] = iconRegister.func_94245_a(iconName);
            }
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        String key;
        String desc;
        if (this.hasItemMetadataList()) {
            Collection<String> s = this.subItems.get(stack.func_77960_j()).getDescription();
            list.addAll(s);
        }
        if ((desc = I18n.getString(key = this.func_77667_c(stack) + ".desc")) != key && !desc.isEmpty()) {
            list.addAll(CSString.lineList(desc));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subItems) {
        if (this.hasItemMetadataList()) {
            for (IMetaItem subitem : this.shownSubItems) {
                subItems.add(subitem.asStack());
            }
        } else {
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.enabled[i] || tab != this.getCreativeTab(i)) continue;
                subItems.add(new ItemStack((Item)this, 1, i));
            }
        }
    }
}

