/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.item;

import clashsoft.cslib.minecraft.crafting.CSCrafting;
import clashsoft.cslib.minecraft.item.CSStacks;
import clashsoft.cslib.minecraft.item.datatools.DataToolSet;
import clashsoft.cslib.reflect.CSReflection;
import clashsoft.cslib.util.CSLog;
import clashsoft.cslib.util.CSString;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatCrafting;
import net.minecraft.stats.StatList;
import net.minecraftforge.common.util.EnumHelper;

public class CSItems {
    public static boolean replaceItem(Item item, Item newItem) {
        long now = System.currentTimeMillis();
        try {
            for (Field field : Items.class.getDeclaredFields()) {
                Item item1;
                if (!Item.class.isAssignableFrom(field.getType()) || (item1 = (Item)field.get(null)) != item) continue;
                FMLControlledNamespacedRegistry registry = GameData.getItemRegistry();
                String registryName = registry.func_148750_c((Object)item1);
                int id = Item.func_150891_b((Item)item1);
                CSReflection.setModifier(field, 16, false);
                field.set(null, newItem);
                CSReflection.invoke(FMLControlledNamespacedRegistry.class, registry, new Object[]{id, registryName, newItem}, "addObjectRaw");
                CSReflection.setValue(StatCrafting.class, (StatCrafting)StatList.field_75928_D[id], newItem, 0);
                CSReflection.setValue(StatCrafting.class, (StatCrafting)StatList.field_75929_E[id], newItem, 0);
                StatCrafting stat = (StatCrafting)StatList.field_75930_F[id];
                if (stat != null) {
                    CSReflection.setValue(StatCrafting.class, stat, newItem, 0);
                }
                now = System.currentTimeMillis() - now;
                CSLog.info("Replace Item : %s (%s) with %s, took %d ms", field.getName(), item1.getClass().getSimpleName(), newItem.getClass().getSimpleName(), now);
                return true;
            }
        }
        catch (Exception e) {
            CSLog.error(e);
        }
        return false;
    }

    public static void addAllItems(Class mod) {
        Item[] items;
        for (Item item : items = CSReflection.getStaticObjects(mod, Item.class, true)) {
            CSItems.addItem(item);
        }
    }

    public static void addItem(Item item) {
        String name = item.func_77658_a();
        if (name.startsWith("item.")) {
            name = name.substring(5);
        }
        CSItems.addItem(item, name);
    }

    public static void addItem(Item item, String name) {
        String activeModID = Loader.instance().activeModContainer().getModId();
        CSItems.addItem(item, name, activeModID.toLowerCase());
    }

    public static void addItem(Item item, String name, String modid) {
        name = CSString.identifier(name);
        item.func_77655_b(name);
        GameRegistry.registerItem((Item)item, (String)name, (String)modid);
    }

    public static void addItemWithRecipe(Item item, String name, int craftingAmount, Object ... recipe) {
        CSItems.addItem(item, name);
        CSCrafting.addRecipe(new ItemStack(item, craftingAmount), recipe);
    }

    public static void addItemWithShapelessRecipe(Item item, String name, int craftingAmount, Object ... recipe) {
        CSItems.addItem(item, name);
        CSCrafting.addShapelessRecipe(new ItemStack(item, craftingAmount), recipe);
    }

    public static void addArmor(Item item, String name, ItemStack material, int type) {
        CSItems.addItem(item, name);
        CSCrafting.addArmorRecipe(new ItemStack(item), material, type);
    }

    public static void addTool(Item item, String name, ItemStack material, int type) {
        CSItems.addTool(item, name, material, CSStacks.stick, type);
    }

    public static void addTool(Item item, String name, ItemStack material, ItemStack stick, int type) {
        CSItems.addItem(item, name);
        CSCrafting.addToolRecipe(new ItemStack(item), material, stick, type);
    }

    public static Item.ToolMaterial addToolMaterial(String name, int harvestLevel, int maxUses, float efficiency, float damage, int enchantability, int color, ItemStack recipe, DataToolSet dataToolSet) {
        Item.ToolMaterial toolMaterial = EnumHelper.addToolMaterial((String)name, (int)harvestLevel, (int)maxUses, (float)efficiency, (float)damage, (int)enchantability);
        if (dataToolSet != null) {
            dataToolSet.registerToolMaterial(toolMaterial, name);
        }
        return toolMaterial;
    }

    public static <T extends Item> T createItem(Class<T> type, String name, Object ... args) {
        Class[] classes = new Class[args.length + 1];
        for (int i = 0; i < args.length; ++i) {
            classes[i] = args[i] != null ? args[i].getClass() : Object.class;
        }
        return CSItems.createItem(type, name, classes, args);
    }

    public static <T extends Item> T createItem(Class<T> type, String name, Class[] argsTypes, Object ... args) {
        Item item = null;
        try {
            Constructor<T> c = type.getConstructor(argsTypes);
            if (c != null) {
                item = (Item)c.newInstance(args);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        return (T)item;
    }
}

