/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.crafting;

import clashsoft.cslib.minecraft.crafting.ShapedAdvancedRecipe;
import clashsoft.cslib.minecraft.item.CSStacks;
import clashsoft.cslib.minecraft.item.meta.IMetaItemRecipe;
import clashsoft.cslib.util.CSLog;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.OreDictionary;

public class CSCrafting {
    public static void registerRecipe(IRecipe recipe) {
        CraftingManager.func_77594_a().func_77592_b().add(recipe);
    }

    public static ShapedRecipes addRecipe(ItemStack output, Object ... recipe) {
        return CSCrafting.addAdvancedRecipe(output, recipe);
    }

    public static ShapedRecipes addAdvancedRecipe(ItemStack output, Object ... recipe) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipe[i] instanceof String[]) {
            String[] astring;
            for (String s1 : astring = (String[])recipe[i++]) {
                ++k;
                j = s1.length();
                s = s + s1;
            }
        } else {
            while (recipe[i] instanceof String) {
                String s2 = (String)recipe[i++];
                ++k;
                j = s2.length();
                s = s + s2;
            }
        }
        HashMap<Character, ItemStack> hashmap = new HashMap<Character, ItemStack>();
        while (i < recipe.length) {
            Character character = (Character)recipe[i];
            ItemStack itemstack1 = null;
            if (recipe[i + 1] instanceof Item) {
                itemstack1 = new ItemStack((Item)recipe[i + 1]);
            } else if (recipe[i + 1] instanceof Block) {
                itemstack1 = new ItemStack((Block)recipe[i + 1], 1, Short.MAX_VALUE);
            } else if (recipe[i + 1] instanceof ItemStack) {
                itemstack1 = (ItemStack)recipe[i + 1];
            }
            hashmap.put(character, itemstack1);
            i += 2;
        }
        ItemStack[] stacks = new ItemStack[j * k];
        for (int i1 = 0; i1 < j * k; ++i1) {
            char c0 = s.charAt(i1);
            stacks[i1] = hashmap.containsKey(Character.valueOf(c0)) ? ((ItemStack)hashmap.get(Character.valueOf(c0))).func_77946_l() : null;
        }
        ShapedAdvancedRecipe shapedrecipes = new ShapedAdvancedRecipe(j, k, stacks, output);
        CSCrafting.registerRecipe((IRecipe)shapedrecipes);
        return shapedrecipes;
    }

    public static void addShapelessRecipe(ItemStack output, Object ... recipe) {
        GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])recipe);
    }

    public static void addFurnaceRecipe(ItemStack input, ItemStack output, float experience) {
        FurnaceRecipes.func_77602_a().func_151394_a(input, output, experience);
    }

    public static void addStorageBlock(ItemStack input, ItemStack output, int size) {
        if (size == 1) {
            CSCrafting.addShapelessRecipe(output, input);
        } else if (size == 2) {
            CSCrafting.addRecipe(output, "XX", "XX", Character.valueOf('X'), input);
        } else if (size == 3) {
            CSCrafting.addRecipe(output, "XXX", "XXX", "XXX", Character.valueOf('X'), input);
        } else {
            throw new IllegalArgumentException("The size of a storage block recipe should be either 1, 2 or 3");
        }
    }

    public static void addStick(ItemStack output, ItemStack input) {
        CSCrafting.addRecipe(output, "s", "s", Character.valueOf('s'), input);
    }

    public static void addPlanks(ItemStack output, ItemStack input) {
        CSCrafting.addShapelessRecipe(output, input);
    }

    public static void addArmorRecipe(ItemStack output, ItemStack input, int type) {
        if (type == 0) {
            CSCrafting.addRecipe(output, "XXX", "X X", Character.valueOf('X'), input);
        } else if (type == 1) {
            CSCrafting.addRecipe(output, "X X", "XXX", "XXX", Character.valueOf('X'), input);
        } else if (type == 2) {
            CSCrafting.addRecipe(output, "XXX", "X X", "X X", Character.valueOf('X'), input);
        } else if (type == 3) {
            CSCrafting.addRecipe(output, "X X", "X X", Character.valueOf('X'), input);
        } else if (type == 4) {
            CSCrafting.addRecipe(output, "X X", Character.valueOf('X'), input);
        }
    }

    public static void addToolRecipe(ItemStack output, ItemStack material, int type) {
        CSCrafting.addToolRecipe(output, material, CSStacks.stick, type);
    }

    public static void addToolRecipe(ItemStack output, ItemStack material, ItemStack stick, int type) {
        if (type == 0) {
            CSCrafting.addRecipe(output, "X", "X", "|", Character.valueOf('X'), material, Character.valueOf('|'), stick);
        } else if (type == 1) {
            CSCrafting.addRecipe(output, "X", "|", "|", Character.valueOf('X'), material, Character.valueOf('|'), stick);
        } else if (type == 2) {
            CSCrafting.addRecipe(output, "XXX", " | ", " | ", Character.valueOf('X'), material, Character.valueOf('|'), stick);
        } else if (type == 3) {
            CSCrafting.addRecipe(output, "XX ", "X| ", " | ", Character.valueOf('X'), material, Character.valueOf('|'), stick);
        } else if (type == 4) {
            CSCrafting.addRecipe(output, "XX", " |", " |", Character.valueOf('X'), material, Character.valueOf('|'), stick);
        }
    }

    public static void removeRecipe(Object ... recipe) {
        CSCrafting.addRecipe(CSStacks.air, recipe);
    }

    public static ItemStack registerOre(String name, ItemStack ore) {
        OreDictionary.registerOre((String)name, (ItemStack)ore);
        return ore;
    }

    public static ItemStack[][] analyseCrafting(IMetaItemRecipe recipe) {
        try {
            if (recipe.getCraftingType() == 2) {
                return new ItemStack[][]{{null, (ItemStack)recipe.getData()[0], null}, {null, CSStacks.fire, null}, {null, CSStacks.coal, null}};
            }
            if (recipe.getCraftingType() == 1) {
                ItemStack[][] ret = new ItemStack[3][3];
                for (int i = 0; i < recipe.getData().length; ++i) {
                    int x = i / 3 % 3;
                    int y = i % 3;
                    ret[x][y] = (ItemStack)recipe.getData()[i];
                }
                return ret;
            }
            if (recipe.getCraftingType() == 0) {
                return CSCrafting.analyseCraftingShaped(recipe.getData());
            }
        }
        catch (Exception ex) {
            CSLog.error(ex);
        }
        return new ItemStack[][]{{null, null, null}, {null, null, null}, {null, null, null}};
    }

    public static ItemStack[][] analyseCraftingShaped(Object ... recipe) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipe[i] instanceof String[]) {
            String[] astring = (String[])recipe[i++];
            k = astring.length;
            for (String s1 : astring) {
                j = s1.length();
                s = s + s1;
            }
        } else {
            while (recipe[i] instanceof String) {
                String s2 = (String)recipe[i++];
                ++k;
                j = s2.length();
                s = s + s2;
            }
        }
        HashMap<Character, ItemStack> hashmap = new HashMap<Character, ItemStack>();
        while (i < recipe.length) {
            Character character = (Character)recipe[i];
            ItemStack itemstack1 = null;
            if (recipe[i + 1] instanceof Item) {
                itemstack1 = new ItemStack((Item)recipe[i + 1]);
            } else if (recipe[i + 1] instanceof Block) {
                itemstack1 = new ItemStack((Block)recipe[i + 1], 1, Short.MAX_VALUE);
            } else if (recipe[i + 1] instanceof ItemStack) {
                itemstack1 = (ItemStack)recipe[i + 1];
            }
            hashmap.put(character, itemstack1);
            i += 2;
        }
        ItemStack[][] ret = new ItemStack[3][3];
        for (int j1 = 0; j1 < j; ++j1) {
            for (int k1 = 0; k1 < k; ++k1) {
                int i1 = k1 * j + j1;
                char c0 = s.charAt(i1 % s.length());
                ret[k1 % 3][j1 % 3] = hashmap.containsKey(Character.valueOf(c0)) ? ((ItemStack)hashmap.get(Character.valueOf(c0))).func_77946_l() : null;
            }
        }
        return ret;
    }
}

