/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.block;

import clashsoft.cslib.minecraft.block.CustomBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockCustomGrass
extends CustomBlock {
    public String[] topIconNames;
    public String[] sideIconNames;
    public String[] bottomIconNames;
    public Block[] dirtBlocks;
    public int[] dirtBlockMetadatas;
    public IIcon[] topIcons;
    public IIcon[] sideIcons;
    public IIcon[] bottomIcons;

    public BlockCustomGrass(String name, String topIcon, String sideIcon, String bottomIcon) {
        this(new String[]{name}, new String[]{topIcon}, new String[]{sideIcon}, new String[]{bottomIcon});
    }

    public BlockCustomGrass(String[] names, String[] topIcons, String[] sideIcons, String[] bottomIcons) {
        super(Material.field_151577_b, names, sideIcons, null);
        this.func_149672_a(Block.field_149779_h);
        this.func_149675_a(true);
        this.setHardness(0.6f);
        this.names = names;
        this.topIconNames = topIcons;
        this.sideIconNames = sideIcons;
        this.bottomIconNames = bottomIcons;
        this.dirtBlocks = new Block[names.length];
        this.dirtBlockMetadatas = new int[names.length];
    }

    public BlockCustomGrass setDirtBlocks(Block[] blocks, int[] metadata) {
        this.dirtBlocks = blocks;
        this.dirtBlockMetadatas = metadata;
        return this;
    }

    public BlockCustomGrass setDirtBlock(int metadata, Block block, int dirtBlockMetadata) {
        this.dirtBlocks[metadata] = block;
        this.dirtBlockMetadatas[metadata] = dirtBlockMetadata;
        return this;
    }

    @Override
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIcons = new IIcon[this.topIconNames.length];
        this.sideIcons = new IIcon[this.sideIconNames.length];
        this.bottomIcons = new IIcon[this.bottomIconNames.length];
        for (int i = 0; i < this.topIconNames.length; ++i) {
            this.topIcons[i] = iconRegister.func_94245_a(this.topIconNames[i]);
            this.sideIcons[i] = iconRegister.func_94245_a(this.sideIconNames[i]);
            this.bottomIcons[i] = iconRegister.func_94245_a(this.bottomIconNames[i]);
        }
        this.bottomIconNames = null;
        this.sideIconNames = null;
        this.topIconNames = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return side == 1 ? this.topIcons[metadata] : (side == 0 ? this.bottomIcons[metadata] : this.sideIcons[metadata]);
    }

    @Override
    public Item func_149650_a(int metadata, Random random, int fortune) {
        Block dirt = this.dirtBlocks[metadata];
        int meta = this.dirtBlockMetadatas[metadata];
        return dirt.func_149650_a(meta, random, fortune);
    }

    @Override
    public int func_149692_a(int metadata) {
        return this.dirtBlockMetadatas[metadata];
    }

    @Override
    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K) {
            int metadata = world.func_72805_g(x, y, z);
            Block dirt = this.dirtBlocks[metadata];
            int dirtMetadata = this.dirtBlockMetadatas[metadata];
            if (world.func_72957_l(x, y + 1, z) < 4 && world.getBlockLightOpacity(x, y + 1, z) > 2) {
                world.func_147465_d(x, y, z, dirt, dirtMetadata, 3);
            } else if (world.func_72957_l(x, y + 1, z) >= 9) {
                for (int l = 0; l < 4; ++l) {
                    int x1 = x + random.nextInt(3) - 1;
                    int y1 = y + random.nextInt(5) - 3;
                    int z1 = z + random.nextInt(3) - 1;
                    Block block = world.func_147439_a(x1, y1, z1);
                    int blockMetadata = world.func_72805_g(x1, y1, z1);
                    int lightValue = world.func_72957_l(x1, y1 + 1, z1);
                    int lightOpacity = world.getBlockLightOpacity(x1, y1 + 1, z1);
                    if (block != dirt || blockMetadata != dirtMetadata || lightValue < 4 || lightOpacity > 2) continue;
                    world.func_147465_d(x1, y1, z1, (Block)this, metadata, 3);
                }
            }
        }
    }
}

