/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.maps.primitive;

import java.util.Objects;

public class LongHashMap<V> {
    protected Entry[] hashArray;
    protected int size;
    protected int capacity;
    protected final float loadFactor;
    protected volatile int modCount;

    public LongHashMap() {
        this(16, 0.75f);
    }

    public LongHashMap(int size, float loadFactor) {
        this.capacity = (int)((float)size * loadFactor);
        this.loadFactor = loadFactor;
        this.hashArray = new Entry[size];
    }

    private static int getHashedKey(long key) {
        return LongHashMap.hash((int)(key ^ key >>> 32));
    }

    private static int hash(int hash) {
        hash ^= hash >>> 20 ^ hash >>> 12;
        return hash ^ hash >>> 7 ^ hash >>> 4;
    }

    private static int getHashIndex(int hash, int size) {
        return hash & size - 1;
    }

    public int size() {
        return this.size;
    }

    public V get(long key) {
        int i = LongHashMap.getHashedKey(key);
        Entry entry = this.hashArray[LongHashMap.getHashIndex(i, this.hashArray.length)];
        while (entry != null) {
            if (entry.key == key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean contains(long key) {
        return this.getEntry(key) != null;
    }

    protected final Entry<V> getEntry(long key) {
        int i = LongHashMap.getHashedKey(key);
        Entry localEntry = this.hashArray[LongHashMap.getHashIndex(i, this.hashArray.length)];
        while (localEntry != null) {
            if (localEntry.key == key) {
                return localEntry;
            }
            localEntry = localEntry.next;
        }
        return null;
    }

    public V put(long key, V paramObject) {
        int i = LongHashMap.getHashedKey(key);
        int j = LongHashMap.getHashIndex(i, this.hashArray.length);
        Entry localEntry = this.hashArray[j];
        while (localEntry != null) {
            if (localEntry.key == key) {
                Object v = localEntry.value;
                localEntry.value = paramObject;
                return v;
            }
            localEntry = localEntry.next;
        }
        ++this.size;
        ++this.modCount;
        this.createKey(i, key, paramObject, j);
        return null;
    }

    private void resizeTable(int newSize) {
        Entry[] src = this.hashArray;
        int i = src.length;
        if (i == 0x40000000) {
            this.capacity = Integer.MAX_VALUE;
            return;
        }
        Entry[] dest = new Entry[newSize];
        this.copyHashTableTo(dest);
        this.hashArray = dest;
        this.capacity = (int)((float)newSize * this.loadFactor);
    }

    private void copyHashTableTo(Entry[] dest) {
        Entry[] src = this.hashArray;
        int i = dest.length;
        for (int j = 0; j < src.length; ++j) {
            Entry localEntry;
            Entry entry = src[j];
            if (entry == null) continue;
            src[j] = null;
            do {
                localEntry = entry.next;
                int k = LongHashMap.getHashIndex(entry.hash, i);
                entry.next = dest[k];
                dest[k] = entry;
            } while ((entry = localEntry) != null);
        }
    }

    public V remove(long key) {
        Entry<V> localEntry = this.removeKey(key);
        return localEntry == null ? null : (V)localEntry.value;
    }

    protected final Entry<V> removeKey(long key) {
        Entry entry1;
        int hash = LongHashMap.getHashedKey(key);
        int index = LongHashMap.getHashIndex(hash, this.hashArray.length);
        Entry entry2 = entry1 = this.hashArray[index];
        while (entry2 != null) {
            Entry next = entry2.next;
            if (entry2.key == key) {
                ++this.modCount;
                --this.size;
                if (entry1 == entry2) {
                    this.hashArray[index] = next;
                } else {
                    entry1.next = next;
                }
                return entry2;
            }
            entry1 = entry2;
            entry2 = next;
        }
        return entry2;
    }

    private void createKey(int hash, long key, V object, int index) {
        Entry localEntry = this.hashArray[index];
        this.hashArray[index] = new Entry<V>(hash, key, object, localEntry);
        if (this.size++ >= this.capacity) {
            this.resizeTable(2 * this.hashArray.length);
        }
    }

    static class Entry<V> {
        final long key;
        final int hash;
        V value;
        Entry next;

        protected Entry(int hash, long key, V value, Entry next) {
            this.value = value;
            this.next = next;
            this.key = key;
            this.hash = hash;
        }

        public final long getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean equals(Object other) {
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            return this.getKey() == entry.getKey() && Objects.equals(this.getValue(), entry.getValue());
        }

        public final int hashCode() {
            return this.hash;
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

