/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.brewingapi.tileentity;

import clashsoft.brewingapi.item.ItemPotion2;
import clashsoft.brewingapi.potion.IIngredientHandler;
import clashsoft.brewingapi.potion.type.IPotionType;
import clashsoft.brewingapi.potion.type.PotionType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityBrewingStand;

public class TileEntityBrewingStand2
extends TileEntityBrewingStand
implements ISidedInventory {
    public EntityPlayer thePlayer = null;
    private ItemStack[] brewingItemStacks = new ItemStack[4];
    private int brewTime;
    private int filledSlots;

    public void spawnXP() {
        if (this.thePlayer != null && !this.thePlayer.field_70170_p.field_72995_K) {
            int j;
            int i;
            float f = 0.0f;
            for (i = 0; i < 3; ++i) {
                ItemStack stack = this.brewingItemStacks[i];
                if (stack == null) continue;
                f += PotionType.getExperience(stack);
            }
            for (i = Math.round(f); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.thePlayer.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.thePlayer.field_70170_p, this.thePlayer.field_70165_t, this.thePlayer.field_70163_u + 0.5, this.thePlayer.field_70161_v + 0.5, j));
            }
        }
    }

    public int func_145939_j() {
        int i = 0;
        for (int j = 0; j < 3; ++j) {
            if (this.brewingItemStacks[j] == null) continue;
            i |= 1 << j;
        }
        return i;
    }

    private boolean canBrew() {
        ItemStack ingredient = this.brewingItemStacks[3];
        if (ingredient != null && ingredient.field_77994_a > 0) {
            Item item = ingredient.func_77973_b();
            for (int i = 0; i < 3; ++i) {
                ItemStack potionStack = this.brewingItemStacks[i];
                if (potionStack == null) continue;
                ItemPotion2 potion = (ItemPotion2)potionStack.func_77973_b();
                boolean water = potion.isWater(potionStack);
                List<IPotionType> types = potion.getPotionTypes(potionStack);
                if (item == Items.field_151114_aO && !water) {
                    for (IPotionType type : types) {
                        if (!type.isImprovable()) continue;
                        return true;
                    }
                    continue;
                }
                if (item == Items.field_151137_ax && !water) {
                    for (IPotionType type : types) {
                        if (!type.isExtendable()) continue;
                        return true;
                    }
                    continue;
                }
                if (item == Items.field_151071_bq && !water) {
                    for (IPotionType type : types) {
                        if (!type.isInversible()) continue;
                        return true;
                    }
                    continue;
                }
                if (item == Items.field_151016_H) {
                    if (potion.isSplash(potionStack)) continue;
                    return true;
                }
                return PotionType.canApplyIngredient(ingredient, potionStack);
            }
        }
        return false;
    }

    private void brewPotions() {
        ItemStack ingredient = this.brewingItemStacks[3];
        Item item = ingredient.func_77973_b();
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.brewingItemStacks[i];
            if (stack == null) continue;
            ItemPotion2 potionItem = (ItemPotion2)stack.func_77973_b();
            int damage = stack.func_77960_j();
            boolean water = potionItem.isWater(stack);
            List<IPotionType> types = potionItem.getPotionTypes(stack);
            ArrayList<IPotionType> newTypes = new ArrayList<IPotionType>(types.size());
            boolean flag = false;
            if (item == Items.field_151016_H) {
                damage = potionItem.setSplash(stack, true);
            }
            if (item == Items.field_151114_aO && !water) {
                for (IPotionType type : types) {
                    newTypes.add(type.onImproved());
                }
            } else if (item == Items.field_151137_ax && !water) {
                for (IPotionType type : types) {
                    newTypes.add(type.onExtended());
                }
            } else if (item == Items.field_151071_bq && !water) {
                for (IPotionType type : types) {
                    newTypes.add(type.onInverted());
                }
            } else if (item == Items.field_151016_H && !water) {
                for (IPotionType type : types) {
                    newTypes.add(type.onGunpowderUsed());
                }
            } else {
                IIngredientHandler handler = PotionType.getIngredientHandler(ingredient);
                if (handler != null && handler.canApplyIngredient(ingredient, stack)) {
                    this.brewingItemStacks[i] = handler.applyIngredient(ingredient, stack);
                    continue;
                }
                IPotionType potionType = PotionType.getFromIngredient(ingredient);
                if (potionType != null && PotionType.hasBase(potionType, types)) {
                    newTypes.add(potionType);
                }
            }
            stack.func_77964_b(damage | 1);
            stack.field_77990_d = new NBTTagCompound();
            for (IPotionType potionType : newTypes) {
                potionType.apply(stack);
            }
            this.brewingItemStacks[i] = stack;
        }
        ItemStack container = item.getContainerItem(ingredient);
        if (container != null) {
            ingredient = container;
        } else {
            --ingredient.field_77994_a;
            if (ingredient.field_77994_a <= 0) {
                ingredient = null;
            }
        }
        this.brewingItemStacks[3] = ingredient;
    }

    public void setBrewTime(int brewTime) {
        this.brewTime = brewTime;
    }

    public int func_145935_i() {
        return this.brewTime;
    }

    public int getMaxBrewTime() {
        if (this.thePlayer != null && this.thePlayer.field_71075_bZ.field_75098_d) {
            return 60;
        }
        return 400;
    }

    public void func_145845_h() {
        if (this.brewTime > 0) {
            --this.brewTime;
            if (this.brewTime == 0) {
                this.brewPotions();
                this.spawnXP();
                this.func_70296_d();
            } else if (!this.canBrew()) {
                this.brewTime = 0;
                this.func_70296_d();
            }
        } else if (this.canBrew()) {
            this.brewTime = this.getMaxBrewTime();
        }
        int filledSlots = this.func_145939_j();
        if (filledSlots != this.filledSlots) {
            this.filledSlots = filledSlots;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, filledSlots, 2);
        }
        super.func_145845_h();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.brewingItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            byte slotID = tag.func_74771_c("Slot");
            this.brewingItemStacks[slotID] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.brewTime = nbt.func_74765_d("BrewTime");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("BrewTime", (short)this.brewTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.brewingItemStacks.length; ++i) {
            if (this.brewingItemStacks[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            this.brewingItemStacks[i].func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public int func_70302_i_() {
        return this.brewingItemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.brewingItemStacks[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.brewingItemStacks[slot];
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.brewingItemStacks[slot] = null;
                return stack;
            }
            ItemStack stack1 = stack.func_77979_a(amount);
            if (stack.field_77994_a <= 0) {
                this.brewingItemStacks[slot] = null;
            }
            return stack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return this.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.brewingItemStacks[slot] = stack;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        this.thePlayer = player;
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slotID, ItemStack stack) {
        if (slotID == 3) {
            return PotionType.isPotionIngredient(stack);
        }
        return stack.func_77973_b() instanceof ItemPotion2;
    }
}

