/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class CustomTreeGen
extends WorldGenTrees {
    public int field_76533_a = 4;
    public boolean field_76531_b = false;
    public Block logBlock = Blocks.field_150364_r;
    public Block leafBlock = Blocks.field_150362_t;
    public Block vineBlock = Blocks.field_150395_bd;
    public int logMetadata = 0;
    public int leafMetadata = 0;

    public CustomTreeGen(boolean blockUpdates, int minTreeHeight, Block log, Block leaf) {
        this(blockUpdates, minTreeHeight, log, leaf, 0, 0);
    }

    public CustomTreeGen(boolean blockUpdates, int minTreeHeight, Block log, Block leaf, int woodMetadata, int leavesMetadata) {
        this(blockUpdates, minTreeHeight, log, leaf, woodMetadata, leavesMetadata, false);
    }

    public CustomTreeGen(boolean blockUpdates, int minTreeHeight, Block log, Block leaf, int woodMetadata, int leavesMetadata, boolean vinesGrow) {
        super(blockUpdates);
        this.field_76533_a = minTreeHeight;
        this.logBlock = log;
        this.leafBlock = leaf;
        this.logMetadata = woodMetadata;
        this.leafMetadata = leavesMetadata;
        this.field_76531_b = vinesGrow;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int height = random.nextInt(3) + this.field_76533_a;
        int y2 = y + height + 1;
        boolean flag = true;
        if (y >= 1 && y + height < 256) {
            for (int y1 = y + 1; y1 <= y2; ++y1) {
                int off = 1;
                if (y1 == y) {
                    off = 0;
                }
                if (y1 >= y + height - 1) {
                    off = 2;
                }
                for (int x1 = x - off; flag && x1 <= x + off; ++x1) {
                    for (int z1 = z - off; flag && z1 <= z + off; ++z1) {
                        if (y1 >= 0 && y1 < 256) {
                            Block block = world.func_147439_a(x1, y1, z1);
                            if (this.isReplaceable(world, x1, y1, z1)) continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            Block block2 = world.func_147439_a(x, y - 1, z);
            boolean isSoil = block2.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && y < 256 - height - 1) {
                int j2;
                int i2;
                int l1;
                int k1;
                block2.onPlantGrow(world, x, y - 1, z, x, y, z);
                int b0 = 3;
                int b1 = 0;
                for (k1 = y - b0 + height; k1 <= y + height; ++k1) {
                    int i3 = k1 - (y + height);
                    l1 = b1 + 1 - i3 / 2;
                    for (i2 = x - l1; i2 <= x + l1; ++i2) {
                        j2 = i2 - x;
                        for (int k2 = z - l1; k2 <= z + l1; ++k2) {
                            Block block1;
                            int l2 = k2 - z;
                            if (Math.abs(j2) == l1 && Math.abs(l2) == l1 && (random.nextInt(2) == 0 || i3 == 0) || !(block1 = world.func_147439_a(i2, k1, k2)).isAir((IBlockAccess)world, i2, k1, k2) && !block1.isLeaves((IBlockAccess)world, i2, k1, k2)) continue;
                            this.func_150516_a(world, i2, k1, k2, this.leafBlock, this.leafMetadata);
                        }
                    }
                }
                for (k1 = 0; k1 < height; ++k1) {
                    Block block = world.func_147439_a(x, y + k1, z);
                    if (!block.isAir((IBlockAccess)world, x, y + k1, z) && !block.isLeaves((IBlockAccess)world, x, y + k1, z)) continue;
                    this.func_150516_a(world, x, y + k1, z, this.logBlock, this.logMetadata);
                    if (!this.field_76531_b || k1 <= 0) continue;
                    if (random.nextInt(3) > 0 && world.func_147437_c(x - 1, y + k1, z)) {
                        this.func_150516_a(world, x - 1, y + k1, z, Blocks.field_150395_bd, 8);
                    }
                    if (random.nextInt(3) > 0 && world.func_147437_c(x + 1, y + k1, z)) {
                        this.func_150516_a(world, x + 1, y + k1, z, Blocks.field_150395_bd, 2);
                    }
                    if (random.nextInt(3) > 0 && world.func_147437_c(x, y + k1, z - 1)) {
                        this.func_150516_a(world, x, y + k1, z - 1, Blocks.field_150395_bd, 1);
                    }
                    if (random.nextInt(3) <= 0 || !world.func_147437_c(x, y + k1, z + 1)) continue;
                    this.func_150516_a(world, x, y + k1, z + 1, Blocks.field_150395_bd, 4);
                }
                if (this.field_76531_b) {
                    for (k1 = y - 3 + height; k1 <= y + height; ++k1) {
                        int i3 = k1 - (y + height);
                        l1 = 2 - i3 / 2;
                        for (i2 = x - l1; i2 <= x + l1; ++i2) {
                            for (j2 = z - l1; j2 <= z + l1; ++j2) {
                                if (!world.func_147439_a(i2, k1, j2).isLeaves((IBlockAccess)world, i2, k1, j2)) continue;
                                if (random.nextInt(4) == 0 && world.func_147439_a(i2 - 1, k1, j2).isAir((IBlockAccess)world, i2 - 1, k1, j2)) {
                                    this.growVines(world, i2 - 1, k1, j2, 8);
                                }
                                if (random.nextInt(4) == 0 && world.func_147439_a(i2 + 1, k1, j2).isAir((IBlockAccess)world, i2 + 1, k1, j2)) {
                                    this.growVines(world, i2 + 1, k1, j2, 2);
                                }
                                if (random.nextInt(4) == 0 && world.func_147439_a(i2, k1, j2 - 1).isAir((IBlockAccess)world, i2, k1, j2 - 1)) {
                                    this.growVines(world, i2, k1, j2 - 1, 1);
                                }
                                if (random.nextInt(4) != 0 || !world.func_147439_a(i2, k1, j2 + 1).isAir((IBlockAccess)world, i2, k1, j2 + 1)) continue;
                                this.growVines(world, i2, k1, j2 + 1, 4);
                            }
                        }
                    }
                    if (random.nextInt(5) == 0 && height > 5) {
                        for (k1 = 0; k1 < 2; ++k1) {
                            for (int i3 = 0; i3 < 4; ++i3) {
                                if (random.nextInt(4 - k1) != 0) continue;
                                l1 = random.nextInt(3);
                                this.func_150516_a(world, x + Direction.field_71583_a[Direction.field_71580_e[i3]], y + height - 5 + k1, z + Direction.field_71581_b[Direction.field_71580_e[i3]], Blocks.field_150375_by, l1 << 2 | i3);
                            }
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void growVines(World world, int x, int y, int z, int metadata) {
        this.func_150516_a(world, x, y, z, this.vineBlock, metadata);
        int i1 = 4;
        while (!world.func_147439_a(x, --y, z).isAir((IBlockAccess)world, x, y, z) && i1 > 0) {
            this.func_150516_a(world, x, y, z, this.vineBlock, metadata);
            --i1;
        }
        return;
    }
}

