/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.world;

import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CSWorld {
    public static final int[][] sideMap = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
    public static final int[] oppositeSideMap = new int[]{1, 0, 3, 2, 5, 4};

    public static Block getBlock(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z);
    }

    public static int getBlockMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public static <T extends TileEntity> T getBlockTileEntity(IBlockAccess world, int x, int y, int z) {
        return (T)world.func_147438_o(x, y, z);
    }

    public static Block getBlockAtSide(IBlockAccess world, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                return CSWorld.getBlock(world, x, y - 1, z);
            }
            case 1: {
                return CSWorld.getBlock(world, x, y + 1, z);
            }
            case 2: {
                return CSWorld.getBlock(world, x, y, z - 1);
            }
            case 3: {
                return CSWorld.getBlock(world, x, y, z + 1);
            }
            case 4: {
                return CSWorld.getBlock(world, x - 1, y, z);
            }
            case 5: {
                return CSWorld.getBlock(world, x + 1, y, z);
            }
        }
        return CSWorld.getBlock(world, x, y, z);
    }

    public static int getBlockMetadataAtSide(IBlockAccess world, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                return CSWorld.getBlockMetadata(world, x, y - 1, z);
            }
            case 1: {
                return CSWorld.getBlockMetadata(world, x, y + 1, z);
            }
            case 2: {
                return CSWorld.getBlockMetadata(world, x, y, z - 1);
            }
            case 3: {
                return CSWorld.getBlockMetadata(world, x, y, z + 1);
            }
            case 4: {
                return CSWorld.getBlockMetadata(world, x - 1, y, z);
            }
            case 5: {
                return CSWorld.getBlockMetadata(world, x + 1, y, z);
            }
        }
        return CSWorld.getBlockMetadata(world, x, y, z);
    }

    public static <T extends TileEntity> T getBlockTileEntityAtSide(IBlockAccess world, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                return CSWorld.getBlockTileEntity(world, x, y - 1, z);
            }
            case 1: {
                return CSWorld.getBlockTileEntity(world, x, y + 1, z);
            }
            case 2: {
                return CSWorld.getBlockTileEntity(world, x, y, z - 1);
            }
            case 3: {
                return CSWorld.getBlockTileEntity(world, x, y, z + 1);
            }
            case 4: {
                return CSWorld.getBlockTileEntity(world, x - 1, y, z);
            }
            case 5: {
                return CSWorld.getBlockTileEntity(world, x + 1, y, z);
            }
        }
        return CSWorld.getBlockTileEntity(world, x, y, z);
    }

    public static void setBlock(World world, int x, int y, int z, Block block, int meta) {
        world.func_147465_d(x, y, z, block, meta, 2);
    }

    public static void setBlockTileEntity(World world, int x, int y, int z, TileEntity tileentity) {
        world.func_147455_a(x, y, z, tileentity);
    }

    public static void setBlockAtSide(World world, int x, int y, int z, int side, Block block, int meta) {
        CSWorld.setBlock(world, x + sideMap[side][0], y + sideMap[side][1], z + sideMap[side][2], block, meta);
    }

    public static void setBlockTileEntityAtSide(World world, int x, int y, int z, int side, TileEntity tileentity) {
        CSWorld.setBlockTileEntity(world, x + sideMap[side][0], y + sideMap[side][1], z + sideMap[side][2], tileentity);
    }

    public static void setCube(World world, int x1, int y1, int z1, int x2, int y2, int z2, Block block, int meta) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    CSWorld.setBlock(world, x, y, z, block, meta);
                }
            }
        }
    }

    public static void setFrame(World world, int x1, int y1, int z1, int x2, int y2, int z2, Block block, int meta) {
        CSWorld.setCube(world, x1, y1, z1, x2, y1, z1, block, meta);
        CSWorld.setCube(world, x1, y1, z1, x1, y1, z2, block, meta);
        CSWorld.setCube(world, x2, y1, z1, x2, y1, z2, block, meta);
        CSWorld.setCube(world, x1, y1, z2, x2, y1, z2, block, meta);
        CSWorld.setCube(world, x1, y1, z1, x1, y2, z1, block, meta);
        CSWorld.setCube(world, x2, y1, z1, x2, y2, z1, block, meta);
        CSWorld.setCube(world, x1, y1, z2, x1, y2, z2, block, meta);
        CSWorld.setCube(world, x2, y1, z2, x2, y2, z2, block, meta);
        CSWorld.setCube(world, x1, y2, z1, x2, y2, z1, block, meta);
        CSWorld.setCube(world, x1, y2, z1, x1, y2, z2, block, meta);
        CSWorld.setCube(world, x2, y2, z1, x2, y2, z2, block, meta);
        CSWorld.setCube(world, x1, y2, z2, x2, y2, z2, block, meta);
    }
}

