/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.potion;

import clashsoft.cslib.reflect.CSReflection;
import clashsoft.cslib.util.CSArrays;
import clashsoft.cslib.util.CSLog;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;

public class CustomPotion
extends Potion {
    private ResourceLocation iconFile;
    private boolean instant;
    private int customColor = -1;
    private boolean bad;

    public CustomPotion(String name, int color, boolean bad) {
        this(CustomPotion.getNextFreeID(), name, color, bad);
    }

    public CustomPotion(int id, String name, int color, boolean bad) {
        super(id, bad, color);
        this.func_76390_b(name);
        this.bad = bad;
    }

    public CustomPotion setIcon(ResourceLocation iconFile, int x, int y) {
        this.iconFile = iconFile;
        this.func_76399_b(x, y);
        return this;
    }

    public CustomPotion setCustomColor(int color) {
        if (color > 0) {
            this.customColor = color;
        }
        return this;
    }

    public CustomPotion setIsInstant(boolean instant) {
        this.instant = instant;
        return this;
    }

    public int func_76392_e() {
        if (this.iconFile != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.iconFile);
        }
        return super.func_76392_e();
    }

    public int getCustomColor() {
        return this.customColor;
    }

    public boolean func_76403_b() {
        return this.instant;
    }

    public boolean func_76398_f() {
        return this.bad;
    }

    public static int getNextFreeID() {
        int id = CSArrays.indexOf(field_76425_a, null);
        if (id == -1) {
            int len = field_76425_a.length;
            CustomPotion.expandPotionList(len * 2);
            return len;
        }
        return id;
    }

    public static void expandPotionList(int size) {
        if (Potion.field_76425_a.length < size) {
            try {
                Field f = CSReflection.getField(Potion.class, 0);
                CSReflection.setModifier(f, 16, false);
                Potion[] potionTypes = new Potion[size];
                System.arraycopy(Potion.field_76425_a, 0, potionTypes, 0, Potion.field_76425_a.length);
                f.set(null, potionTypes);
            }
            catch (Exception e) {
                CSLog.error(e);
            }
        }
    }
}

