/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.client.gui;

import clashsoft.cslib.minecraft.client.gui.GuiModUpdatesSlot;
import clashsoft.cslib.minecraft.lang.I18n;
import clashsoft.cslib.minecraft.update.CSUpdate;
import clashsoft.cslib.minecraft.update.ModUpdate;
import java.net.URI;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class GuiModUpdates
extends GuiScreen {
    public final GuiScreen parent;
    public GuiModUpdatesSlot slots;
    public GuiButton buttonShowInvalidUpdates;
    public GuiButton buttonInstall;
    public List<ModUpdate> updates;
    public ModUpdate update;
    public boolean showInvalidUpdates;
    private String title = I18n.getString("update.list.title");
    private String updates_showinvalid = I18n.getString("update.list.showinvalid");
    private String options_on = I18n.getString("options.on");
    private String options_off = I18n.getString("options.off");
    private String mod_name = I18n.getString("update.list.modname");
    private String current_version = I18n.getString("update.list.version");
    private String new_version = I18n.getString("update.list.newversion");
    private String install_status = I18n.getString("update.list.install.status");
    private String url = I18n.getString("update.list.url");
    private String update_notes = I18n.getString("update.list.notes");

    public GuiModUpdates(GuiScreen parent) {
        this.parent = parent;
        this.updateList();
    }

    public void func_73866_w_() {
        this.buttonShowInvalidUpdates = new GuiButton(10, 10, this.field_146295_m - 38, 140, 20, this.getShowInvalidUpdates());
        this.buttonInstall = new GuiButton(1, this.field_146294_l - 90, 35, 80, 20, I18n.getString("update.list.install"));
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2, this.field_146295_m - 38, 140, 20, I18n.getString("gui.done")));
        this.field_146292_n.add(this.buttonInstall);
        this.field_146292_n.add(this.buttonShowInvalidUpdates);
        this.field_146292_n.add(new GuiButton(2, 10, this.field_146295_m - 60, 140, 20, I18n.getString("update.list.installall")));
        this.slots = new GuiModUpdatesSlot(this);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTickTime) {
        if (this.slots != null) {
            this.slots.drawScreen(mouseX, mouseY, partialTickTime);
        }
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 14, 0xFFFFFF);
        ModUpdate update = this.update;
        if (update != null) {
            boolean valid = update.isValid();
            int color1 = valid ? 0xFF0000 : 65280;
            int color2 = valid ? 65280 : 0xFF0000;
            this.func_73731_b(this.field_146289_q, "\u00a7n" + update.getName(), 160, 38, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, this.mod_name, 160, 50, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, this.current_version, 160, 60, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, this.new_version, 160, 70, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, this.url, 160, 80, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, this.install_status, 160, 90, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, update.getModName(), 260, 50, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, update.getVersion(), 260, 60, color1);
            this.func_73731_b(this.field_146289_q, update.getNewVersion(), 260, 70, color2);
            this.func_73731_b(this.field_146289_q, update.getUpdateURL(), 260, 80, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, update.getStatus(), 260, 90, 0xFFFFFF);
            int i = 117;
            String[] updateNotes = update.getUpdateNotes();
            if (updateNotes != null && updateNotes.length > 0) {
                this.func_73731_b(this.field_146289_q, this.update_notes, 160, 105, 0xFFFFFF);
                for (String line : updateNotes) {
                    this.func_73731_b(this.field_146289_q, line, 160, i, this.getDiffColor(line));
                    i += 10;
                }
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTickTime);
    }

    protected void func_73864_a(int x, int y, int which) {
        super.func_73864_a(x, y, which);
        String url = this.update.getUpdateURL();
        int i = this.field_146289_q.func_78256_a(url);
        if (x >= 260 && x <= 260 + i && y >= 80 && y < 90) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiScreen)this, url, 0, false));
        }
    }

    public int getDiffColor(String line) {
        if (line.isEmpty()) {
            return 0xFFFFFF;
        }
        switch (line.charAt(0)) {
            case '+': {
                return 65280;
            }
            case '-': {
                return 0xFF0000;
            }
            case '*': {
                return 0xFFFF00;
            }
            case '!': {
                return Short.MAX_VALUE;
            }
        }
        return 0xFFFFFF;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (button.field_146127_k == 1) {
            if (this.update != null) {
                this.update.install((EntityPlayer)this.field_146297_k.field_71439_g);
            }
        } else if (button.field_146127_k == 2) {
            for (ModUpdate update : this.updates) {
                if (update == null) continue;
                update.install((EntityPlayer)this.field_146297_k.field_71439_g);
            }
        } else if (button.field_146127_k == 10) {
            this.showInvalidUpdates = !this.showInvalidUpdates;
            button.field_146126_j = this.getShowInvalidUpdates();
            this.updateList();
        }
    }

    public void func_73878_a(boolean flag, int id) {
        if (flag && id == 0) {
            URI uri = URI.create(this.update.getUpdateURL());
            try {
                Class<?> oclass = Class.forName("java.awt.Desktop");
                Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
                oclass.getMethod("browse", URI.class).invoke(object, uri);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    protected void selectUpdate(int update) {
        this.update = this.updates.get(update);
        this.buttonInstall.field_146124_l = this.update.isValid();
    }

    protected void updateList() {
        this.updates = CSUpdate.getUpdates(this.showInvalidUpdates);
        ModUpdate modUpdate = this.update = this.updates.isEmpty() ? null : this.updates.get(0);
        if (this.slots != null) {
            this.slots.selectedIndex = 0;
        }
    }

    private String getShowInvalidUpdates() {
        return this.updates_showinvalid + ": " + (this.showInvalidUpdates ? this.options_on : this.options_off);
    }
}

