/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.block;

import clashsoft.cslib.minecraft.block.CustomBlock;
import clashsoft.cslib.minecraft.block.ICustomBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.TerrainGen;

public abstract class BlockCustomSapling
extends BlockSapling
implements ICustomBlock {
    public String[] names;
    public String[] iconNames;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] icons;

    public BlockCustomSapling(String[] names, String[] iconNames) {
        this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.8f, 0.9f);
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149779_h);
        this.names = names;
        this.iconNames = iconNames;
    }

    public BlockCustomSapling(String[] names, String domain) {
        this(names, CustomBlock.applyDomain(names, domain));
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return CustomBlock.getUnlocalizedName((Block)this, stack, this.names);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list) {
        CustomBlock.addInformation(this, stack, list);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K) {
            super.func_149674_a(world, x, y, z, random);
            if (world.func_72957_l(x, y + 1, z) >= 9 && random.nextInt(7) == 0) {
                this.markOrGrowMarked(world, x, y, z, random);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.icons[metadata & 3];
    }

    public void markOrGrowMarked(World world, int x, int y, int z, Random random) {
        this.func_149879_c(world, x, y, z, random);
    }

    public void func_149879_c(World world, int x, int y, int z, Random random) {
        int l = world.func_72805_g(x, y, z);
        if ((l & 8) == 0) {
            world.func_72921_c(x, y, z, l | 8, 4);
        } else {
            this.func_149878_d(world, x, y, z, random);
        }
    }

    public void growTree(World world, int x, int y, int z, Random random) {
        this.func_149878_d(world, x, y, z, random);
    }

    public void func_149878_d(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        if (!TerrainGen.saplingGrowTree((World)world, (Random)random, (int)x, (int)y, (int)z)) {
            return;
        }
        int l = world.func_72805_g(x, y, z) & 3;
        WorldGenerator worldgen = this.getWorldGen(world, x, y, z, random);
        world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 0);
        if (worldgen != null && !worldgen.func_76484_a(world, random, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)this, l, 4);
        }
    }

    public abstract WorldGenerator getWorldGen(World var1, int var2, int var3, int var4, Random var5);

    public boolean canBlockStay(World world, int x, int y, int z, int metadata) {
        Block soil = world.func_147439_a(x, y - 1, z);
        if (soil == null) {
            return false;
        }
        boolean validLight = world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z);
        boolean validSoil = soil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
        return validLight && this.isValidGround(metadata, soil, world.func_72805_g(x, y - 1, z));
    }

    public boolean isValidGround(World world, int x, int y, int z) {
        return this.isValidGround(world.func_72805_g(x, y, z), world.func_147439_a(x, y - 1, z), world.func_72805_g(x, y - 1, z));
    }

    public abstract boolean isValidGround(int var1, Block var2, int var3);

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
        for (int i = 0; i < this.names.length; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        int len = this.iconNames.length;
        this.icons = new IIcon[len];
        for (int i = 0; i < len; ++i) {
            this.icons[i] = iconRegister.func_94245_a(this.iconNames[i]);
        }
    }
}

