/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public abstract class BlockCustomPortal
extends Block {
    public static final int[][] metadataMap = new int[][]{{3, 1}, {2, 0}};
    public int dimensionID;

    public BlockCustomPortal(String name, String iconName, int dimensionID) {
        super(Material.field_151567_E);
        this.func_149663_c(name);
        this.func_149658_d(iconName);
        this.func_149711_c(-1.0f);
        this.func_149715_a(1.0f);
        this.func_149675_a(true);
        this.dimensionID = dimensionID;
    }

    public abstract Block getFrameBlock();

    public int getFrameMetadata() {
        return 0;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        super.func_149674_a(world, x, y, z, random);
        if (!world.field_73011_w.func_76569_d() || !world.func_82736_K().func_82766_b("doMobSpawning")) {
            return;
        }
        if (random.nextInt(2000) >= world.field_73013_u.func_151525_a()) {
            int i;
            for (i = y; !World.func_147466_a((IBlockAccess)world, (int)x, (int)i, (int)z) && i > 0; --i) {
            }
            if (i <= 0 || world.func_147439_a(x, i + 1, z).func_149721_r()) {
                return;
            }
            Entity localEntity = ItemMonsterPlacer.func_77840_a((World)world, (int)57, (double)((double)x + 0.5), (double)((double)i + 1.1), (double)((double)z + 0.5));
            if (localEntity != null) {
                localEntity.field_71088_bW = localEntity.func_82147_ab();
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int i = BlockCustomPortal.limitToValidMetadata(world.func_72805_g(x, y, z));
        PortalSize size1 = new PortalSize(this, world, x, y, z, 0);
        PortalSize size2 = new PortalSize(this, world, x, y, z, 1);
        if (!(i != 1 || size1.isValid() && size1.portals >= size1.width * size1.height)) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        } else if (!(i != 2 || size2.isValid() && size2.portals >= size2.width * size2.height)) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        } else if (i == 0 && !size1.isValid() && !size2.isValid()) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
    }

    public boolean generatePortal(World world, int x, int y, int z) {
        PortalSize size1 = new PortalSize(this, world, x, y, z, 0);
        PortalSize size2 = new PortalSize(this, world, x, y, z, 1);
        if (size1.isValid() && size1.portals == 0) {
            size1.generatePortal();
            return true;
        }
        if (size2.isValid() && size2.portals == 0) {
            size2.generatePortal();
            return true;
        }
        return false;
    }

    public void transferEntity(Entity entity) {
        ServerConfigurationManager manager = MinecraftServer.func_71276_C().func_71203_ab();
        Teleporter teleporter = this.createTeleporter((WorldServer)entity.field_70170_p);
        int src = entity.field_71093_bK;
        int dest = this.getDestination(entity);
        if (entity instanceof EntityPlayer) {
            manager.transferPlayerToDimension((EntityPlayerMP)entity, this.dimensionID, teleporter);
        } else {
            manager.func_82448_a(entity, this.dimensionID, DimensionManager.getWorld((int)src), DimensionManager.getWorld((int)dest));
        }
    }

    public int getDestination(Entity entity) {
        return entity.field_71093_bK != 0 ? 0 : this.dimensionID;
    }

    public abstract Teleporter createTeleporter(WorldServer var1);

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int i = BlockCustomPortal.limitToValidMetadata(world.func_72805_g(x, y, z));
        if (i == 0) {
            i = world.func_147439_a(x - 1, y, z) == this || world.func_147439_a(x + 1, y, z) == this ? 1 : 2;
            if (world instanceof World && !((World)world).field_72995_K) {
                ((World)world).func_72921_c(x, y, z, i, 2);
            }
        }
        float f1 = 0.125f;
        float f2 = 0.125f;
        if (i == 1) {
            f1 = 0.5f;
        }
        if (i == 2) {
            f2 = 0.5f;
        }
        this.func_149676_a(0.5f - f1, 0.0f, 0.5f - f2, 0.5f + f1, 1.0f, 0.5f + f2);
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        boolean i3;
        int i = 0;
        if (world.func_147439_a(x, y, z) == this) {
            i = BlockCustomPortal.limitToValidMetadata(world.func_72805_g(x, y, z));
            if (i == 0) {
                return false;
            }
            if (i == 2 && side != 5 && side != 4) {
                return false;
            }
            if (i == 1 && side != 3 && side != 2) {
                return false;
            }
        }
        boolean j = world.func_147439_a(x - 1, y, z) == this && world.func_147439_a(x - 2, y, z) != this;
        boolean k = world.func_147439_a(x + 1, y, z) == this && world.func_147439_a(x + 2, y, z) != this;
        boolean l = world.func_147439_a(x, y, z - 1) == this && world.func_147439_a(x, y, z - 2) != this;
        boolean i1 = world.func_147439_a(x, y, z + 1) == this && world.func_147439_a(x, y, z + 2) != this;
        boolean i2 = j || k || i == 1;
        boolean bl = i3 = l || i1 || i == 2;
        if (i2 && side == 4) {
            return true;
        }
        if (i2 && side == 5) {
            return true;
        }
        if (i3 && side == 2) {
            return true;
        }
        return i3 && side == 3;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity.field_70154_o == null && entity.field_70153_n == null) {
            entity.func_70063_aa();
            if (entity.func_82147_ab() >= entity.func_82145_z()) {
                this.transferEntity(entity);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (random.nextInt(100) == 0) {
            world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "portal.portal", 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d1 = (float)x + random.nextFloat();
            double d2 = (float)y + random.nextFloat();
            double d3 = (float)z + random.nextFloat();
            double d4 = ((double)random.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)random.nextFloat() - 0.5) * 0.5;
            double d6 = ((double)random.nextFloat() - 0.5) * 0.5;
            int j = random.nextInt(2) * 2 - 1;
            if (world.func_147439_a(x - 1, y, z) == this || world.func_147439_a(x + 1, y, z) == this) {
                d3 = (double)z + 0.5 + 0.25 * (double)j;
                d6 = random.nextFloat() * 2.0f * (float)j;
            } else {
                d1 = (double)x + 0.5 + 0.25 * (double)j;
                d4 = random.nextFloat() * 2.0f * (float)j;
            }
            world.func_72869_a("portal", d1, d2, d3, d4, d5, d6);
        }
    }

    public static int limitToValidMetadata(int metadata) {
        return metadata & 3;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150899_d((int)0);
    }

    public int func_149745_a(Random paramRandom) {
        return 0;
    }

    public static class PortalSize {
        public BlockCustomPortal portalBlock;
        private final World world;
        private final int metadata;
        private final int direction2;
        private final int direction1;
        private int portals;
        private ChunkCoordinates chunkPos;
        private int width;
        private int height;

        public PortalSize(BlockCustomPortal portalBlock, World world, int x, int y, int z, int metadata) {
            this.portalBlock = portalBlock;
            this.world = world;
            this.metadata = metadata;
            this.direction1 = metadataMap[metadata][0];
            this.direction2 = metadataMap[metadata][1];
            int i = y;
            while (y > i - 21 && y > 0 && this.isBlockValid(x, y - 1, z)) {
                --y;
            }
            int j = this.calculateWidth(x, y, z, this.direction1) - 1;
            if (j >= 0) {
                this.chunkPos = new ChunkCoordinates(x + j * Direction.field_71583_a[this.direction1], y, z + j * Direction.field_71581_b[this.direction1]);
                this.width = this.calculateWidth(this.chunkPos.field_71574_a, this.chunkPos.field_71572_b, this.chunkPos.field_71573_c, this.direction2);
                if (this.width < 2 || this.width > 21) {
                    this.chunkPos = null;
                    this.width = 0;
                }
            }
            if (this.chunkPos != null) {
                this.height = this.calculateHeight();
            }
        }

        public boolean isFrameBlock(int x, int y, int z) {
            if (this.world.func_147439_a(x, y, z) == this.portalBlock.getFrameBlock()) {
                int i = this.portalBlock.getFrameMetadata();
                return i == -1 || this.world.func_72805_g(x, y, z) == i;
            }
            return false;
        }

        protected int calculateWidth(int x, int y, int z, int direction) {
            int i;
            int j = Direction.field_71583_a[direction];
            int k = Direction.field_71581_b[direction];
            int x1 = 0;
            int z1 = 0;
            for (i = 0; i < 22 && this.isBlockValid(x1 = x + j * i, y, z1 = z + k * i) && this.isFrameBlock(x1, y - 1, z1); ++i) {
            }
            if (this.isFrameBlock(x1, y, z1)) {
                return i;
            }
            return 0;
        }

        protected int calculateHeight() {
            int l;
            int k;
            int j;
            int i;
            this.height = 0;
            while (this.height < 21) {
                i = this.chunkPos.field_71572_b + this.height;
                for (j = 0; j < this.width; ++j) {
                    k = this.chunkPos.field_71574_a + j * Direction.field_71583_a[metadataMap[this.metadata][1]];
                    l = this.chunkPos.field_71573_c + j * Direction.field_71581_b[metadataMap[this.metadata][1]];
                    if (this.isFrameBlock(k, i, l)) {
                        ++this.portals;
                    } else if (!this.isBlockValid(k, i, l)) break;
                    if (j == 0 && !this.isFrameBlock(k + Direction.field_71583_a[metadataMap[this.metadata][0]], i, l + Direction.field_71581_b[metadataMap[this.metadata][0]]) || j == this.width - 1 && !this.isFrameBlock(k + Direction.field_71583_a[metadataMap[this.metadata][1]], i, l + Direction.field_71581_b[metadataMap[this.metadata][1]])) break;
                }
                ++this.height;
            }
            for (i = 0; i < this.width; ++i) {
                j = this.chunkPos.field_71574_a + i * Direction.field_71583_a[metadataMap[this.metadata][1]];
                k = this.chunkPos.field_71572_b + this.height;
                l = this.chunkPos.field_71573_c + i * Direction.field_71581_b[metadataMap[this.metadata][1]];
                if (this.world.func_147439_a(j, k, l) == this.portalBlock.getFrameBlock()) continue;
                this.height = 0;
                break;
            }
            if (this.height > 21 || this.height < 3) {
                this.chunkPos = null;
                this.width = 0;
                this.height = 0;
                return 0;
            }
            return this.height;
        }

        protected boolean isBlockValid(int x, int y, int z) {
            Block block = this.world.func_147439_a(x, y, z);
            return block.func_149688_o() == Material.field_151579_a || block == Blocks.field_150480_ab || this.isFrameBlock(x, y, z);
        }

        public boolean isValid() {
            return this.chunkPos != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void generatePortal() {
            for (int i = 0; i < this.width; ++i) {
                int j = this.chunkPos.field_71574_a + Direction.field_71583_a[this.direction2] * i;
                int k = this.chunkPos.field_71573_c + Direction.field_71581_b[this.direction2] * i;
                for (int l = 0; l < this.height; ++l) {
                    int i1 = this.chunkPos.field_71572_b + l;
                    this.world.func_147465_d(j, i1, k, (Block)this.portalBlock, this.metadata, 2);
                }
            }
        }
    }
}

