/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.addon;

import clashsoft.cslib.minecraft.addon.Addon;
import clashsoft.cslib.minecraft.addon.AddonLoad;
import clashsoft.cslib.minecraft.addon.AddonPostload;
import clashsoft.cslib.minecraft.addon.AddonPreload;
import clashsoft.cslib.util.CSLog;
import clashsoft.cslib.util.CSSource;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSAddons {
    protected static Map<String, List<Class<?>>> classes = new HashMap();
    protected static Multimap<String, String> preLoadedAddons = HashMultimap.create();
    protected static Multimap<String, String> loadedAddons = HashMultimap.create();
    protected static Multimap<String, String> postLoadedAddons = HashMultimap.create();

    public static void loadAddons(String modName, String modPackage) {
        CSAddons.loadAddons(modName, modPackage, AddonLoad.class, loadedAddons);
    }

    public static void preLoadAddons(String modName, String modPackage) {
        CSAddons.loadAddons(modName, modPackage, AddonPreload.class, preLoadedAddons);
    }

    public static void postLoadAddons(String modName, String modPackage) {
        CSAddons.loadAddons(modName, modPackage, AddonPostload.class, postLoadedAddons);
    }

    public static boolean isAddonLoaded(String modName, String addonName) {
        return CSAddons.isAddonLoaded(modName, addonName, loadedAddons);
    }

    public static boolean isAddonPreloaded(String modName, String addonName) {
        return CSAddons.isAddonLoaded(modName, addonName, preLoadedAddons);
    }

    public static boolean isAddonPostloaded(String modName, String addonName) {
        return CSAddons.isAddonLoaded(modName, addonName, postLoadedAddons);
    }

    protected static void loadAddons(String modName, String modPackage, Class loadAnnotation, Multimap<String, String> map) {
        List<Class<?>> classes = CSAddons.getClassesForPackage(modPackage);
        for (Class<?> c : classes) {
            Addon addon = c.getAnnotation(Addon.class);
            if (addon == null) continue;
            String addonModName = addon.modName();
            String addonName = addon.addonName();
            if (!modName.equals(addonModName) || CSAddons.isAddonLoaded(modName, addonName, map)) continue;
            map.put((Object)modName, (Object)addonName);
            for (Method method : c.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(loadAnnotation)) continue;
                try {
                    method.invoke(null, new Object[0]);
                }
                catch (Exception ex) {
                    CSLog.error(ex);
                }
            }
        }
    }

    public static List<Class<?>> getClassesForPackage(String packageName) {
        List<Class<?>> result = classes.get(packageName);
        if (result == null) {
            result = CSSource.getClassesForPackage(Package.getPackage(packageName));
            classes.put(packageName, result);
        }
        return result;
    }

    protected static boolean isAddonLoaded(String modName, String addonName, Multimap<String, String> map) {
        return map.get((Object)modName).contains(addonName);
    }
}

