/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.math;

import java.util.Random;

public class CSMath {
    private static float[] sinTable = new float[65536];
    private static int[] multiplyDeBruijnBitPosition;

    public static int abs(int i) {
        return i >= 0 ? i : -i;
    }

    public static long abs(long l) {
        return l >= 0L ? l : -l;
    }

    public static float abs(float f) {
        return f >= 0.0f ? f : -f;
    }

    public static double abs(double d) {
        return d >= 0.0 ? d : -d;
    }

    public static double abs_max(double d, double max) {
        if (d < 0.0) {
            d = -d;
        }
        if (max < 0.0) {
            max = -max;
        }
        return d > max ? d : max;
    }

    public static int floor_float(float f) {
        int i = (int)f;
        return f < (float)i ? i - 1 : i;
    }

    public static int floor_double(double d) {
        int i = (int)d;
        return d < (double)i ? i - 1 : i;
    }

    public static int ceiling_float(float f) {
        int i = (int)f;
        return f > (float)i ? i + 1 : i;
    }

    public static int ceiling_double_int(double d) {
        int i = (int)d;
        return d > (double)i ? i + 1 : i;
    }

    public static float sin(float f) {
        return sinTable[(int)(f * 10430.378f) & 0xFFFF];
    }

    public static float cos(float f) {
        return sinTable[(int)(f * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float sqrt_float(float f) {
        return (float)Math.sqrt(f);
    }

    public static float sqrt_double(double d) {
        return (float)Math.sqrt(d);
    }

    public static int truncateDoubleToInt(double d) {
        return (int)(d + 1024.0) - 1024;
    }

    public static int bucketInt(int i, int factor) {
        if (i < 0) {
            return -((-i - 1) / factor) - 1;
        }
        return i / factor;
    }

    public static int clamp_int(int i, int min, int max) {
        if (i < min) {
            return min;
        }
        if (i > max) {
            return max;
        }
        return i;
    }

    public static long clamp_long(long l, long min, long max) {
        if (l < min) {
            return min;
        }
        if (l > max) {
            return max;
        }
        return l;
    }

    public static float clamp_float(float f, float min, float max) {
        if (f < min) {
            return min;
        }
        if (f > max) {
            return max;
        }
        return f;
    }

    public static double clamp_double(double d, double min, double max) {
        if (d < min) {
            return min;
        }
        if (d > max) {
            return max;
        }
        return d;
    }

    public static double denormalizeClamp(double min, double max, double d) {
        if (d < 0.0) {
            return min;
        }
        if (d > 1.0) {
            return max;
        }
        return min + (max - min) * d;
    }

    public static int randomIntClamp(Random rand, int min, int max) {
        if (min >= max) {
            return min;
        }
        return rand.nextInt(max - min + 1) + min;
    }

    public static float randomFloatClamp(Random rand, float min, float max) {
        if (min >= max) {
            return min;
        }
        return rand.nextFloat() * (max - min) + min;
    }

    public static double randomDoubleClamp(Random rand, double min, double max) {
        if (min >= max) {
            return min;
        }
        return rand.nextDouble() * (max - min) + min;
    }

    public static double average(int[] ints) {
        int i = 0;
        for (int j : ints) {
            i += j;
        }
        return i / ints.length;
    }

    public static double average(long[] longs) {
        long l1 = 0L;
        for (long l2 : longs) {
            l1 += l2;
        }
        return l1 / (long)longs.length;
    }

    public static double average(float[] doubles) {
        float f1 = 0.0f;
        for (float f2 : doubles) {
            f1 += f2;
        }
        return f1 / (float)doubles.length;
    }

    public static double average(double[] doubles) {
        double d1 = 0.0;
        for (double d2 : doubles) {
            d1 += d2;
        }
        return d1 / (double)doubles.length;
    }

    public static float angle_float(float f) {
        if ((f %= 360.0f) >= 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static double angle_double(double d) {
        if ((d %= 360.0) >= 180.0) {
            d -= 360.0;
        }
        if (d < -180.0) {
            d += 360.0;
        }
        return d;
    }

    public static int parseInt(String str, int _default) {
        int i = _default;
        try {
            i = Integer.parseInt(str);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return i;
    }

    public static int parseInt(String str, int _default, int max) {
        int i = _default;
        try {
            i = Integer.parseInt(str);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (i < max) {
            i = max;
        }
        return i;
    }

    public static double parseDoubleWithDefault(String str, double _default) {
        double d = _default;
        try {
            d = Double.parseDouble(str);
        }
        catch (Throwable t) {
            // empty catch block
        }
        return d;
    }

    public static double parseDoubleWithDefaultAndMax(String str, double _default, double max) {
        double d = _default;
        try {
            d = Double.parseDouble(str);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (d < max) {
            d = max;
        }
        return d;
    }

    public static int powerOfTwo(int i) {
        int j = i - 1;
        j |= j >> 1;
        j |= j >> 2;
        j |= j >> 4;
        j |= j >> 8;
        j |= j >> 16;
        return j + 1;
    }

    public static boolean isPowerOfTwo(int i) {
        return (i & -i) != 0;
    }

    private static int calculateLogBaseTwoDeBruijn(int i) {
        i = CSMath.isPowerOfTwo(i) ? i : CSMath.powerOfTwo(i);
        return multiplyDeBruijnBitPosition[(int)((long)i * 125613361L >> 27) & 0x1F];
    }

    public static int calculateLogBaseTwo(int i) {
        return CSMath.calculateLogBaseTwoDeBruijn(i) - (CSMath.isPowerOfTwo(i) ? 0 : 1);
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            CSMath.sinTable[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
        multiplyDeBruijnBitPosition = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
    }
}

