/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.collections;

import clashsoft.cslib.util.CSArrays;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CSCollections {
    public static <T> List<T> create(T ... array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    public static <T> Set<T> createSet(T ... array) {
        HashSet<T> set = new HashSet<T>(array.length);
        for (T t : array) {
            set.add(t);
        }
        return set;
    }

    public static Class getComponentType(Collection collection) {
        Class<?> type = null;
        for (Object o : collection) {
            Class<?> c = o.getClass();
            if (type == null) {
                type = c;
                continue;
            }
            if (!c.isAssignableFrom(type)) continue;
            type = c;
        }
        return type;
    }

    public static <T> List<List<T>> split(List<T> list, int maxLength) {
        Class<?> clazz = list.getClass().getComponentType();
        int arrays = (int)Math.ceil((float)list.size() / (float)maxLength);
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        for (int i = 0; i < ret.size(); ++i) {
            ArrayList<T> reti = new ArrayList<T>();
            for (int j = 0; j < maxLength && j + i * maxLength < list.size(); ++j) {
                reti.add(list.get(j + i * maxLength));
            }
            ret.add(reti);
        }
        return ret;
    }

    public static <T> List<T> concat(List<T> list1, List<T> list2) {
        ArrayList<T> ret = new ArrayList<T>(list1.size() + list2.size());
        ret.addAll(list1);
        ret.addAll(list2);
        return ret;
    }

    public static <T> List<T> removeDuplicatesSet(List<T> collection) {
        if (collection != null && collection.size() > 0) {
            HashSet<T> set = new HashSet<T>(collection);
            return new ArrayList<T>(set);
        }
        return collection;
    }

    public static <T> List<T> removeDuplicates(List<T> collection) {
        if (collection != null && collection.size() > 0) {
            ArrayList<T> result = new ArrayList<T>();
            for (T t1 : collection) {
                Object t2;
                boolean duplicate = false;
                Iterator i$ = result.iterator();
                if (i$.hasNext() && Objects.equals(t1, t2 = i$.next())) {
                    duplicate = true;
                }
                if (duplicate) continue;
                result.add(t1);
            }
            return result;
        }
        return collection;
    }

    public static <T> List<T> fromArray(T ... array) {
        return CSArrays.asList(array);
    }

    public static <T> T[] toArray(Collection<T> collection) {
        return CSCollections.toArray(CSCollections.getComponentType(collection), collection);
    }

    public static <T> T[] toArray(Class type, Collection<T> collection) {
        Object[] array = (Object[])Array.newInstance(type, collection.size());
        collection.toArray(array);
        return array;
    }

    public static <T> int indexOf(List<T> list, T object) {
        return CSCollections.indexOf(list, 0, object);
    }

    public static <T> int indexOf(List<T> list, int start, T object) {
        for (int i = start; i < list.size(); ++i) {
            if (!Objects.equals(object, list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(List<T> list, T object) {
        return CSCollections.lastIndexOf(list, list.size() - 1, object);
    }

    public static <T> int lastIndexOf(List<T> list, int start, T object) {
        for (int i = start; i >= 0; --i) {
            if (!Objects.equals(object, list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOfAny(List<T> list, T ... objects) {
        for (T object : objects) {
            int index = CSCollections.indexOf(list, object);
            if (index == -1) continue;
            return index;
        }
        return -1;
    }

    public static <T> int lastIndexOfAny(List<T> list, T ... objects) {
        for (T object : objects) {
            int index = CSCollections.lastIndexOf(list, object);
            if (index == -1) continue;
            return index;
        }
        return -1;
    }

    public static <T> boolean contains(Collection<T> collection, T object) {
        for (T t : collection) {
            if (!Objects.equals(t, object)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAny(Collection<T> collection, T ... objects) {
        for (T object : objects) {
            if (!CSCollections.contains(collection, object)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(Collection<T> collection, T ... objects) {
        for (T object : objects) {
            if (CSCollections.contains(collection, object)) continue;
            return false;
        }
        return true;
    }
}

