/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.brewingapi.potion.type;

import clashsoft.brewingapi.BrewingAPI;
import clashsoft.brewingapi.item.ItemPotion2;
import clashsoft.brewingapi.potion.IIngredientHandler;
import clashsoft.brewingapi.potion.type.AbstractPotionType;
import clashsoft.brewingapi.potion.type.IPotionType;
import clashsoft.brewingapi.potion.type.PotionBase;
import clashsoft.brewingapi.potion.type.PotionTypeDelegate;
import clashsoft.cslib.minecraft.item.CSStacks;
import clashsoft.cslib.minecraft.potion.CustomPotion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class PotionType
extends AbstractPotionType {
    public static final float TWO_THIRDS = 0.6666667f;
    private PotionEffect effect;
    private int maxAmplifier;
    private int maxDuration;
    private IPotionType inverted;
    private ItemStack ingredient;
    private PotionBase base;

    protected PotionType() {
    }

    public PotionType(PotionEffect effect, int maxAmplifier, int maxDuration) {
        this(effect, maxAmplifier, maxDuration, null);
    }

    public PotionType(PotionEffect effect, int maxAmplifier, int maxDuration, IPotionType inverted) {
        this(effect, maxAmplifier, maxDuration, inverted, null, null);
    }

    public PotionType(PotionEffect effect, int maxAmplifier, int maxDuration, ItemStack ingredient, PotionBase base) {
        this(effect, maxAmplifier, maxDuration, null, ingredient, base);
    }

    public PotionType(PotionEffect effect, int maxAmplifier, int maxDuration, IPotionType inverted, ItemStack ingredient, PotionBase base) {
        this.effect = effect;
        this.maxAmplifier = maxAmplifier;
        this.maxDuration = maxDuration;
        this.inverted = inverted;
        this.ingredient = ingredient;
        this.base = base;
    }

    @Override
    public PotionType copy() {
        PotionType potionType = new PotionType(this.getEffect(), this.getMaxAmplifier(), this.getMaxDuration(), this.getInverted(), this.getIngredient(), this.getBase());
        return potionType;
    }

    @Override
    public boolean isBadEffect() {
        if (this.hasEffect()) {
            Potion potion = this.getPotion();
            switch (potion.field_76415_H) {
                case 2: 
                case 4: 
                case 7: 
                case 9: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    return true;
                }
            }
            if (potion instanceof CustomPotion) {
                return ((CustomPotion)potion).func_76398_f();
            }
        }
        return false;
    }

    @Override
    public PotionEffect getEffect() {
        return this.effect;
    }

    @Override
    public int getMaxAmplifier() {
        return this.maxAmplifier;
    }

    @Override
    public int getMaxDuration() {
        return this.maxDuration;
    }

    @Override
    public int getDefaultDuration() {
        return this.getDuration();
    }

    @Override
    public IPotionType getInverted() {
        return this.inverted;
    }

    @Override
    public ItemStack getIngredient() {
        return this.ingredient;
    }

    @Override
    public PotionBase getBase() {
        return this.base;
    }

    @Override
    public boolean isBase() {
        return false;
    }

    public PotionType setEffect(PotionEffect effect) {
        this.effect = effect;
        return this;
    }

    public PotionType setMaxAmplifier(int maxAmplifier) {
        this.maxAmplifier = maxAmplifier;
        return this;
    }

    public PotionType setMaxDuration(int maxDuration) {
        this.maxDuration = maxDuration;
        return this;
    }

    public IPotionType setInverted(IPotionType opposite) {
        this.inverted = opposite;
        return this;
    }

    public IPotionType setIngredient(ItemStack ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public IPotionType setBase(PotionBase base) {
        this.base = base;
        return this;
    }

    @Override
    public IPotionType onImproved() {
        PotionEffect effect = this.getEffect();
        if (effect != null) {
            effect = new PotionEffect(effect.func_76456_a(), (int)((float)effect.func_76459_b() * 0.6666667f), effect.func_76458_c() + 1);
            return new PotionTypeDelegate(effect, this);
        }
        return this;
    }

    @Override
    public IPotionType onExtended() {
        PotionEffect effect = this.getEffect();
        if (effect != null) {
            effect = new PotionEffect(effect.func_76456_a(), effect.func_76459_b() * 2, effect.func_76458_c());
            return new PotionTypeDelegate(effect, this);
        }
        return this;
    }

    @Override
    public IPotionType onDiluted() {
        PotionEffect effect = this.getEffect();
        if (effect != null) {
            effect = new PotionEffect(effect.func_76456_a(), (int)((float)effect.func_76459_b() * 0.6666667f), (int)((float)effect.func_76458_c() * 0.8f));
            return new PotionTypeDelegate(effect, this);
        }
        return this;
    }

    @Override
    public IPotionType onGunpowderUsed() {
        PotionEffect effect = this.getEffect();
        if (effect != null) {
            effect = new PotionEffect(effect.func_76456_a(), (int)((float)effect.func_76459_b() * 0.75f), effect.func_76458_c());
            return new PotionTypeDelegate(effect, this);
        }
        return this;
    }

    @Override
    public IPotionType onInverted() {
        PotionEffect effect = this.getEffect();
        IPotionType inverted = this.getInverted();
        if (inverted != null) {
            if (effect != null) {
                effect = new PotionEffect(inverted.getPotionID(), (int)((float)effect.func_76459_b() * 0.75f), effect.func_76458_c());
                return new PotionTypeDelegate(effect, inverted);
            }
            return new PotionTypeDelegate(inverted.getEffect(), inverted);
        }
        return this;
    }

    @Override
    public void apply_do(EntityLivingBase target, PotionEffect effect) {
        if (effect != null) {
            target.func_70690_d(effect);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound effect = new NBTTagCompound();
        this.effect.func_82719_a(effect);
        nbt.func_74782_a("Effect", (NBTBase)effect);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + (this.effect == null ? 0 : this.effect.hashCode());
        result = 31 * result + (this.ingredient == null ? 0 : this.ingredient.hashCode());
        result = 31 * result + (this.inverted == null ? 0 : this.inverted.hashCode());
        result = 31 * result + this.maxAmplifier;
        result = 31 * result + this.maxDuration;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PotionType other = (PotionType)obj;
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        if (this.effect == null ? other.effect != null : !this.effect.equals((Object)other.effect)) {
            return false;
        }
        if (this.ingredient == null ? other.ingredient != null : !this.ingredient.equals(other.ingredient)) {
            return false;
        }
        if (this.inverted == null ? other.inverted != null : !this.inverted.equals(other.inverted)) {
            return false;
        }
        if (this.maxAmplifier != other.maxAmplifier) {
            return false;
        }
        return this.maxDuration == other.maxDuration;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String uuid = this.getUUID();
        builder.append("PotionType");
        if (uuid != null && !uuid.isEmpty()) {
            builder.append(".").append(uuid);
        }
        builder.append(" [");
        if (this.effect != null) {
            builder.append("effect=").append(this.effect).append(", ");
        }
        if (this.inverted != null) {
            builder.append("inverted=").append(this.inverted).append(", ");
        }
        if (this.ingredient != null) {
            builder.append("ingredient=").append(this.ingredient).append(", ");
        }
        if (this.base != null) {
            builder.append("base=").append(this.base).append(", ");
        }
        builder.append("maxAmplifier=").append(this.maxAmplifier);
        builder.append(", maxDuration=").append(this.maxDuration);
        builder.append("]");
        return builder.toString();
    }

    public static IPotionType getRandom(Random rng) {
        return (IPotionType)combinableTypes.get(rng.nextInt(combinableTypes.size()));
    }

    public static IPotionType getFromEffect(PotionEffect effect) {
        IPotionType potionType = PotionType.getFromEffect_(effect);
        if (potionType != null) {
            return new PotionTypeDelegate(effect, potionType);
        }
        return effect == null ? null : new PotionType(effect, effect.func_76458_c(), effect.func_76459_b());
    }

    protected static IPotionType getFromEffect_(PotionEffect effect) {
        return effect == null ? null : PotionType.getFromID(effect.func_76456_a());
    }

    @Deprecated
    public static IPotionType getFirstPotionType(ItemStack stack) {
        NBTTagList list;
        if (stack != null && stack.func_77942_o() && (list = (NBTTagList)stack.field_77990_d.func_74781_a("Brewing")).func_74745_c() > 0) {
            NBTTagCompound nbt1 = list.func_150305_b(0);
            IPotionType potionType = PotionType.getFromNBT(nbt1);
            return potionType;
        }
        return null;
    }

    public static List<IPotionType> getPotionTypes(ItemStack stack) {
        int len;
        NBTTagList list;
        if (stack != null && stack.func_77942_o() && (list = (NBTTagList)stack.field_77990_d.func_74781_a("Brewing")) != null && (len = list.func_74745_c()) > 0) {
            ArrayList<IPotionType> types = new ArrayList<IPotionType>(len);
            for (int i = 0; i < len; ++i) {
                NBTTagCompound nbt1 = list.func_150305_b(i);
                IPotionType potionType = PotionType.getFromNBT(nbt1);
                types.add(potionType);
            }
            return types;
        }
        return Collections.EMPTY_LIST;
    }

    public static boolean isPotionIngredient(ItemStack stack) {
        return PotionType.getFromIngredient(stack) != null || PotionType.hasIngredientHandler(stack);
    }

    public static IIngredientHandler getIngredientHandler(ItemStack ingredient) {
        for (IIngredientHandler handler : BrewingAPI.ingredientHandlers) {
            if (!handler.canHandleIngredient(ingredient)) continue;
            return handler;
        }
        return null;
    }

    public static boolean hasIngredientHandler(ItemStack ingredient) {
        return PotionType.getIngredientHandler(ingredient) != null;
    }

    public static ItemStack applyIngredient(ItemStack ingredient, ItemStack potion) {
        IIngredientHandler handler = PotionType.getIngredientHandler(ingredient);
        if (handler != null && handler.canApplyIngredient(ingredient, potion)) {
            return handler.applyIngredient(ingredient, potion);
        }
        IPotionType potionType = PotionType.getFromIngredient(ingredient);
        if (potionType != null) {
            PotionBase requiredBase = potionType.getBase();
            boolean flag = false;
            List<IPotionType> potionTypes = ((ItemPotion2)potion.func_77973_b()).getPotionTypes(potion);
            if (requiredBase == null) {
                flag = potionTypes.isEmpty();
            } else {
                for (IPotionType pt : potionTypes) {
                    if (!(pt instanceof PotionBase) || !((PotionBase)pt).equals(requiredBase)) continue;
                    flag = true;
                    pt.remove(potion);
                    break;
                }
            }
            if (flag) {
                return potionType.apply(potion);
            }
        }
        return potion;
    }

    public static boolean canApplyIngredient(ItemStack ingredient, ItemStack potion) {
        IIngredientHandler handler = PotionType.getIngredientHandler(ingredient);
        if (handler != null) {
            return handler.canApplyIngredient(ingredient, potion);
        }
        IPotionType type = PotionType.getFromIngredient(ingredient);
        if (type != null) {
            List<IPotionType> potionTypes = ((ItemPotion2)potion.func_77973_b()).getPotionTypes(potion);
            return PotionType.hasBase(type, potionTypes);
        }
        return false;
    }

    public static boolean hasBase(IPotionType type, List<IPotionType> types) {
        PotionBase base = type.getBase();
        if (base == null) {
            return true;
        }
        for (IPotionType pt : types) {
            if (!(pt instanceof PotionBase) || !base.matches((PotionBase)pt)) continue;
            return true;
        }
        return false;
    }

    public static PotionType getFromID(int potionID) {
        for (IPotionType pt : potionTypeList) {
            if (pt.getPotionID() != potionID) continue;
            return (PotionType)pt;
        }
        return null;
    }

    public static IPotionType getFromIngredient(ItemStack stack) {
        if (stack != null) {
            for (IPotionType pt : potionTypeList) {
                if (!CSStacks.equals(stack, pt.getIngredient())) continue;
                return pt;
            }
        }
        return null;
    }

    public static IPotionType getFromNBT(NBTTagCompound nbt) {
        if (nbt != null && !nbt.func_82582_d()) {
            AbstractPotionType result = nbt.func_74764_b("BaseName") ? new PotionBase() : new PotionTypeDelegate();
            result.readFromNBT(nbt);
            return result;
        }
        return null;
    }

    public static float getExperience(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemPotion2) {
            ItemPotion2 item = (ItemPotion2)stack.func_77973_b();
            List<IPotionType> effects = item.getPotionTypes(stack);
            float value = item.isSplashDamage(stack.func_77960_j()) ? 0.3f : 0.2f;
            for (IPotionType b : effects) {
                if (!b.hasEffect()) continue;
                float f1 = b.isBadEffect() ? 0.2f : 0.3f;
                value += f1 + (float)b.getAmplifier() * 0.1f + (float)(b.getEffect().func_76459_b() / 600);
            }
            return value;
        }
        return 0.0f;
    }

    public static List<IPotionType> removeDuplicates(Collection<IPotionType> list) {
        if (list != null && list.size() > 0) {
            ArrayList<IPotionType> result = new ArrayList<IPotionType>();
            for (IPotionType b : list) {
                boolean duplicate = false;
                for (IPotionType b2 : result) {
                    if (b.getPotionID() != b2.getPotionID()) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                result.add(b);
            }
            Collections.sort(result);
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public static List<IPotionType> removeDuplicates(IPotionType[] list) {
        if (list != null && list.length > 0) {
            ArrayList<IPotionType> result = new ArrayList<IPotionType>();
            for (IPotionType b : list) {
                boolean duplicate = false;
                for (IPotionType b2 : result) {
                    if (b.getPotionID() != b2.getPotionID()) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                result.add(b);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }
}

