/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.brewingapi.potion.type;

import clashsoft.brewingapi.potion.type.IPotionType;
import clashsoft.brewingapi.potion.type.PotionType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public abstract class AbstractPotionType
implements IPotionType {
    @Override
    public String getUUID() {
        return this.getEffectName();
    }

    @Override
    public AbstractPotionType register() {
        potionTypeList.add(this);
        if (this.isCombinable()) {
            combinableTypes.add(this);
        }
        if (this.hasEffect()) {
            effectTypes.add(this);
        }
        return this;
    }

    @Override
    public boolean isCombinable() {
        return !this.isBase();
    }

    @Override
    public boolean hasEffect() {
        return this.getPotionID() > 0;
    }

    @Override
    public Potion getPotion() {
        PotionEffect pe = this.getEffect();
        return pe != null ? Potion.field_76425_a[pe.func_76456_a()] : null;
    }

    @Override
    public int getPotionID() {
        PotionEffect pe = this.getEffect();
        return pe != null ? pe.func_76456_a() : -1;
    }

    @Override
    public int getDuration() {
        PotionEffect pe = this.getEffect();
        return pe != null ? pe.func_76459_b() : -1;
    }

    @Override
    public boolean isInstant() {
        Potion potion = this.getPotion();
        return potion != null && potion.func_76403_b();
    }

    @Override
    public int getAmplifier() {
        PotionEffect pe = this.getEffect();
        return pe != null ? pe.func_76458_c() : -1;
    }

    @Override
    public int getRedstoneAmount() {
        int duration;
        int defaultDuration = this.getDefaultDuration();
        int redstoneAmount = 0;
        if (duration > 0) {
            for (duration = this.getDuration(); duration > defaultDuration; duration /= 2) {
                ++redstoneAmount;
            }
        }
        return redstoneAmount;
    }

    @Override
    public int getGlowstoneAmount() {
        return this.getAmplifier();
    }

    @Override
    public String getEffectName() {
        PotionEffect effect = this.getEffect();
        return effect != null ? effect.func_76453_d() : "";
    }

    @Override
    public boolean isImprovable() {
        PotionEffect effect = this.getEffect();
        return effect != null && effect.func_76458_c() < this.getMaxAmplifier();
    }

    @Override
    public boolean isExtendable() {
        PotionEffect effect = this.getEffect();
        return effect != null && effect.func_76459_b() < this.getMaxDuration();
    }

    @Override
    public boolean isDilutable() {
        return this.hasEffect();
    }

    @Override
    public boolean isInversible() {
        return this.getInverted() != null;
    }

    @Override
    public int getLiquidColor() {
        Potion potion = this.getPotion();
        if (potion != null) {
            return potion.func_76401_j();
        }
        return 789759;
    }

    @Override
    public List<IPotionType> getSubTypes() {
        ArrayList<IPotionType> list = new ArrayList<IPotionType>();
        list.add(this);
        if (this.isImprovable()) {
            list.add(this.onImproved());
        }
        if (this.isExtendable()) {
            list.add(this.onExtended());
        }
        return list;
    }

    @Override
    public ItemStack apply(ItemStack stack) {
        if (stack != null) {
            NBTTagList list;
            if (stack.field_77990_d == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((list = (NBTTagList)stack.field_77990_d.func_74781_a("Brewing")) == null) {
                list = new NBTTagList();
            }
            NBTTagCompound nbt1 = new NBTTagCompound();
            this.writeToNBT(nbt1);
            list.func_74742_a((NBTBase)nbt1);
            stack.field_77990_d.func_74782_a("Brewing", (NBTBase)list);
        }
        return stack;
    }

    @Override
    public ItemStack remove(ItemStack stack) {
        if (stack != null && stack.func_77942_o()) {
            NBTTagList list = (NBTTagList)stack.field_77990_d.func_74781_a("Brewing");
            if (list != null) {
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound nbt1 = list.func_150305_b(i);
                    if (!this.equals(PotionType.getFromNBT(nbt1))) continue;
                    list.func_74744_a(i);
                    break;
                }
            }
            stack.field_77990_d.func_74782_a("Brewing", (NBTBase)list);
        }
        return stack;
    }

    @Override
    public void apply(EntityLivingBase target) {
        PotionEffect pe = new PotionEffect(this.getEffect());
        this.apply_do(target, pe);
    }

    @Override
    public void apply(EntityLivingBase thrower, EntityLivingBase target, double distance) {
        PotionEffect effect = this.getEffect();
        if (effect != null) {
            int id = effect.func_76456_a();
            if (id == Potion.field_76432_h.field_76415_H || id == Potion.field_76433_i.field_76415_H) {
                Potion.field_76425_a[id].func_76402_a(thrower, target, effect.func_76458_c(), distance);
            } else {
                int j = (int)(distance * (double)effect.func_76459_b() + 0.5);
                if (j > 20) {
                    this.apply_do(target, new PotionEffect(id, j, effect.func_76458_c()));
                }
            }
        }
    }

    @Override
    public int compareTo(IPotionType o) {
        return this.hasEffect() && o.hasEffect() ? Integer.compare(this.getPotionID(), o.getPotionID()) : 0;
    }
}

