/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.brewingapi;

import clashsoft.brewingapi.block.BlockBrewingStand2;
import clashsoft.brewingapi.command.CommandPotion;
import clashsoft.brewingapi.common.BAPIProxy;
import clashsoft.brewingapi.entity.EntityPotion2;
import clashsoft.brewingapi.item.ItemGlassBottle2;
import clashsoft.brewingapi.item.ItemPotion2;
import clashsoft.brewingapi.lib.PotionDispenser;
import clashsoft.brewingapi.network.BAPINetHandler;
import clashsoft.brewingapi.potion.IIngredientHandler;
import clashsoft.brewingapi.potion.IPotionEffectHandler;
import clashsoft.brewingapi.potion.IPotionList;
import clashsoft.brewingapi.potion.PotionList;
import clashsoft.brewingapi.potion.type.IPotionType;
import clashsoft.brewingapi.tileentity.TileEntityBrewingStand2;
import clashsoft.cslib.minecraft.ClashsoftMod;
import clashsoft.cslib.minecraft.block.CSBlocks;
import clashsoft.cslib.minecraft.command.CSCommand;
import clashsoft.cslib.minecraft.item.CSItems;
import clashsoft.cslib.minecraft.potion.CustomPotion;
import clashsoft.cslib.minecraft.util.CSConfig;
import clashsoft.cslib.reflect.CSReflection;
import clashsoft.cslib.util.CSLog;
import clashsoft.cslib.util.CSUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemReed;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingEvent;

@Mod(modid="brewingapi", name="Brewing API", version="1.7.2-1.0.1", dependencies="required-after:cslib")
public class BrewingAPI
extends ClashsoftMod {
    public static final String MODID = "brewingapi";
    public static final String NAME = "Brewing API";
    public static final String ACRONYM = "bapi";
    public static final String VERSION = "1.7.2-1.0.1";
    public static final String DEPENDENCIES = "required-after:cslib";
    @Mod.Instance(value="brewingapi")
    public static BrewingAPI instance;
    @SidedProxy(clientSide="clashsoft.brewingapi.client.BAPIClientProxy", serverSide="clashsoft.brewingapi.common.BAPIProxy")
    public static BAPIProxy proxy;
    private static Boolean mpmInstalled;
    public static boolean multiPotions;
    public static boolean advancedPotionInfo;
    public static boolean showAllBaseTypes;
    public static boolean defaultAwkwardBrewing;
    public static int potionStackSize;
    public static int brewingStand2ID;
    public static int splashPotion2ID;
    public static CreativeTabs potions;
    public static Block brewingStand2;
    public static Item brewingStandItem2;
    public static ItemPotion2 potion2;
    public static ItemGlassBottle2 glassBottle2;
    public static boolean hasLoaded;
    public static List<IPotionEffectHandler> effectHandlers;
    public static List<IIngredientHandler> ingredientHandlers;

    public BrewingAPI() {
        super(proxy, MODID, NAME, ACRONYM, VERSION);
        this.hasConfig = true;
        this.netHandlerClass = BAPINetHandler.class;
        this.eventHandler = this;
        this.url = "https://github.com/Clashsoft/Brewing-API/wiki/";
    }

    @Override
    public void readConfig() {
        brewingStand2ID = CSConfig.getTileEntity("Brewing Stand", 11);
        multiPotions = CSConfig.getBool("potions", "MultiPotions", multiPotions);
        advancedPotionInfo = CSConfig.getBool("potions", "Advanced Potion Info", advancedPotionInfo);
        showAllBaseTypes = CSConfig.getBool("potions", "Show All Base Potion Types", showAllBaseTypes);
        defaultAwkwardBrewing = CSConfig.getBool("potions", "Default Awkward Brewing", defaultAwkwardBrewing);
        potionStackSize = CSConfig.getInt("potions", "PotionStackSize", potionStackSize);
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        brewingStand2 = new BlockBrewingStand2().func_149663_c("brewingStand").func_149711_c(0.5f).func_149715_a(0.125f);
        brewingStandItem2 = new ItemReed(brewingStand2).func_77655_b("brewingStand").func_111206_d("brewing_stand").func_77637_a(CreativeTabs.field_78038_k);
        potion2 = (ItemPotion2)new ItemPotion2().func_77655_b("potion");
        glassBottle2 = (ItemGlassBottle2)new ItemGlassBottle2().func_77655_b("glassBottle").func_111206_d("potion_bottle_empty");
        CSBlocks.replaceBlock(Blocks.field_150382_bo, brewingStand2);
        CSItems.replaceItem(Items.field_151067_bt, brewingStandItem2);
        CSItems.replaceItem((Item)Items.field_151068_bn, (Item)potion2);
        CSItems.replaceItem(Items.field_151069_bo, (Item)glassBottle2);
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        super.init(event);
        PotionList.init();
        if (multiPotions) {
            potions = new CreativeTabs("mixedpotions"){
                ItemStack stack;
                {
                    this.stack = null;
                }

                public ItemStack func_151244_d() {
                    return this.stack == null ? (this.stack = PotionList.damageBoost.apply(new ItemStack((Item)potion2, 0, 1))) : this.stack;
                }

                public Item func_78016_d() {
                    return null;
                }
            };
        }
        GameRegistry.registerTileEntity(TileEntityBrewingStand2.class, (String)"BrewingStand2");
        EntityRegistry.registerGlobalEntityID(EntityPotion2.class, (String)"SplashPotion2", (int)splashPotion2ID);
        EntityRegistry.registerModEntity(EntityPotion2.class, (String)"SplashPotion2", (int)splashPotion2ID, (Object)this, (int)100, (int)20, (boolean)true);
        BlockDispenser.field_149943_a.func_82595_a((Object)potion2, (Object)new PotionDispenser());
        CSCommand.registerCommand((ICommand)new CommandPotion());
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    public static boolean isMorePotionsModInstalled() {
        if (mpmInstalled == null) {
            boolean b = CSUtil.checkClass("clashsoft.mods.morepotions.MorePotionsMod");
            mpmInstalled = b;
            return b;
        }
        return mpmInstalled;
    }

    public static IPotionType addPotionType(IPotionType potionType) {
        return potionType.register();
    }

    public static void setPotionList(IPotionList potionList) {
        PotionList.instance = potionList;
    }

    public static void registerIngredientHandler(IIngredientHandler handler) {
        if (ingredientHandlers.contains(handler)) {
            CSLog.info("Ingredient handler \"" + handler + "\" registered");
            ingredientHandlers.add(handler);
        }
    }

    public static void registerEffectHandler(IPotionEffectHandler handler) {
        if (!effectHandlers.contains(handler)) {
            CSLog.info("Effect handler \"" + handler + "\" registered");
            effectHandlers.add(handler);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase living = event.entityLiving;
        if (living != null && !living.field_70170_p.field_72995_K) {
            Collection c = living.func_70651_bq();
            ArrayList potionEffects = new ArrayList(c);
            for (PotionEffect effect : potionEffects) {
                for (IPotionEffectHandler handler : effectHandlers) {
                    if (!handler.canHandle(effect)) continue;
                    handler.onPotionUpdate(living.field_70725_aQ, living, effect);
                }
            }
        }
    }

    static {
        if (proxy == null) {
            proxy = FMLCommonHandler.instance().getEffectiveSide().isClient() ? CSReflection.createInstance(BAPIProxy.class, "clashsoft.brewingapi.client.BAPIClientProxy") : new BAPIProxy();
        }
        mpmInstalled = null;
        multiPotions = false;
        advancedPotionInfo = false;
        showAllBaseTypes = false;
        defaultAwkwardBrewing = false;
        potionStackSize = 1;
        brewingStand2ID = 11;
        splashPotion2ID = EntityRegistry.findGlobalUniqueEntityId();
        CustomPotion.expandPotionList(64);
        hasLoaded = false;
        effectHandlers = new LinkedList<IPotionEffectHandler>();
        ingredientHandlers = new LinkedList<IIngredientHandler>();
    }
}

