/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.util;

import clashsoft.cslib.util.CSArrays;
import clashsoft.cslib.util.CSLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;

public class CSString {
    private static final String[] ROMANCODE = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final int[] BINEQUAL = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    public static final String[] fastRomanCache = new String[]{"0", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI", "XVII", "XVIII", "XIX", "XX"};
    public static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    public static final String VOWELS = "aeiou";
    public static final String CONSONANTS = "bcdfghjklmnpqrstvwxyz";
    public static final String[] CONSONANTCOMBINATIONS = new String[]{"bl", "br", "cl", "cr", "dr", "fl", "fr", "gl", "gr", "pl", "pr", "sh", "sk", "sl", "sm", "sn", "sp", "st", "sw", "tr", "tw", "th"};
    public static final int LOWERCASE = 0;
    public static final int UPPERCASE = 1;
    public static final int LOWER_CAMELCASE = 2;
    public static final int UPPER_CAMELCASE = 3;
    public static final int INVERTED_CASE = 4;
    public static final int INVERTED_LOWER_CAMELCASE = 5;
    public static final int INVERTED_UPPER_CAMELCASE = 6;

    public static String format(String format, String ... args) {
        int len = format.length();
        int len1 = args.length;
        StringBuilder result = new StringBuilder(len + len1 * 10);
        int j = 0;
        for (int i = 0; i < len; ++i) {
            char c = format.charAt(i);
            if (c == '%') {
                char c1 = format.charAt(i + 1);
                if (c1 == '%') {
                    result.append('%');
                    ++i;
                    continue;
                }
                if (c1 != '{') {
                    result.append(args[j]);
                    if (j >= len1 - 1) continue;
                    ++j;
                    continue;
                }
                int k = format.indexOf(125, i + 1);
                String formatter = format.substring(i + 1, k);
                i = k;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static boolean isNumber(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String identifier(String string) {
        int len = string.length();
        StringBuilder result = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = Character.toLowerCase(string.charAt(i));
            if (Character.isWhitespace(c)) {
                c = '_';
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String convertToRoman(int number) {
        if (number < 0) {
            return "-" + CSString.convertToRoman(-number);
        }
        if (number < fastRomanCache.length) {
            return fastRomanCache[number];
        }
        if (number >= 4000) {
            CSLog.error("Exception while converting to Roman: Value outside roman numeral range.");
            return String.valueOf(number);
        }
        StringBuilder roman = new StringBuilder();
        for (int i = 0; i < ROMANCODE.length; ++i) {
            while (number >= BINEQUAL[i]) {
                number -= BINEQUAL[i];
                roman.append(ROMANCODE[i]);
            }
        }
        return roman.toString();
    }

    public static String cutString(String string, int maxLineLength) {
        String[] words = string.split(" ");
        StringBuilder ret = new StringBuilder(string.length());
        StringBuilder temp = new StringBuilder(10);
        for (int i = 0; i < words.length; ++i) {
            while (i < words.length && temp.append(words[i]).length() <= maxLineLength) {
                temp.append(' ');
                ++i;
            }
            ret.append(temp.toString().trim()).append('\n');
            temp.delete(0, temp.length());
        }
        return ret.toString().trim();
    }

    public static String[] lineArray(String string) {
        return string.split("\n");
    }

    public static List<String> lineList(String string) {
        return Arrays.asList(CSString.lineArray(string));
    }

    @Deprecated
    public static String[] makeLineList(String string) {
        return CSString.lineArray(string);
    }

    public static String getAcronym(String string) {
        String[] strings;
        StringBuilder builder = new StringBuilder(string.length());
        for (String s : strings = string.split("\\p{Punct}")) {
            char c = s.charAt(0);
            builder.append(c);
        }
        return builder.toString();
    }

    public static int count(String string, char ch) {
        int count = 0;
        for (char c : string.toCharArray()) {
            if (c != ch) continue;
            ++count;
        }
        return count;
    }

    public static String caseString(String string, int mode) {
        switch (mode) {
            case 0: {
                return string.toLowerCase();
            }
            case 1: {
                return string.toUpperCase();
            }
            case 2: {
                String[] array = string.toLowerCase().split(" ");
                for (int i = 0; i < string.length(); ++i) {
                    array[i] = CSString.firstCharToCase(array[i], 0);
                }
                return CSString.unsplit(" ", array);
            }
            case 3: {
                String[] array = string.toLowerCase().split(" ");
                for (int i = 0; i < string.length(); ++i) {
                    array[i] = CSString.firstCharToCase(array[i], 1);
                }
                return CSString.unsplit(" ", array);
            }
            case 4: {
                StringBuilder ret = new StringBuilder(string.length());
                for (char c : string.toCharArray()) {
                    if (Character.isUpperCase(c)) {
                        ret.append(Character.toLowerCase(c));
                        continue;
                    }
                    ret.append(Character.toUpperCase(c));
                }
                return ret.toString();
            }
            case 5: {
                return CSString.caseString(CSString.caseString(string, 2), 4);
            }
            case 6: {
                return CSString.caseString(CSString.caseString(string, 3), 4);
            }
        }
        return string;
    }

    public static String[] caseAll(String[] array, int mode) {
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] != null ? CSString.caseString(array[i], mode) : "";
        }
        return result;
    }

    public static List<String> caseAll(List<String> list, int mode) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != null) {
                result.add(CSString.caseString(list.get(i), mode));
                continue;
            }
            result.add("");
        }
        return result;
    }

    public static String unsplit(String split, String ... parts) {
        if (parts.length < 1) {
            return "";
        }
        StringBuilder result = new StringBuilder(parts.length * parts[0].length());
        for (int i = 0; i < parts.length; ++i) {
            result.append(parts[i]);
            if (i + 1 == parts.length) continue;
            result.append(split);
        }
        return result.toString();
    }

    public static String fastConcat(String ... strings) {
        if (strings.length < 1) {
            return "";
        }
        if (strings.length < 4) {
            String result = strings[0];
            for (int i = 1; i < strings.length; ++i) {
                result = result + strings[i];
            }
            return result;
        }
        StringBuilder result = new StringBuilder(strings.length * strings[0].length());
        for (int i = 0; i < strings.length; ++i) {
            result.append(strings[i]);
        }
        return result.toString();
    }

    public static String concat(String string, String prefix, String postfix) {
        return CSString.fastConcat(prefix, string, postfix);
    }

    public static String[] concatAll(String[] array, String prefix, String postfix) {
        String[] ret = new String[array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = CSString.concat(array[i], prefix, postfix);
        }
        return ret;
    }

    public static List<String> concatAll(List<String> list, String prefix, String postfix) {
        ArrayList<String> ret = new ArrayList<String>(list.size());
        for (int i = 0; i < ret.size(); ++i) {
            ret.add(CSString.concat(list.get(i), prefix, postfix));
        }
        return ret;
    }

    public static boolean contains(String string, char character) {
        return string.indexOf(character) != -1;
    }

    public static boolean containsRegex(String string, String regex) {
        return Pattern.compile(regex).matcher(string).find();
    }

    public static boolean containsAny(String string, String regex) {
        return CSString.indexOfAny(string, regex) != -1;
    }

    public static int indexOfRegex(String string, String regex) {
        return Pattern.compile(regex).matcher(string).start();
    }

    public static int indexOfAny(String string, String regex) {
        for (int i = 0; i < regex.length(); ++i) {
            int index = string.indexOf(regex.charAt(i));
            if (index == -1) continue;
            return index;
        }
        return -1;
    }

    public static int indexOfRange(String string, String regex, int min, int max) {
        int index = string.indexOf(regex, min);
        return index < max ? index : -1;
    }

    public static String firstCharToCase(String string, int mode) {
        return (mode == 0 ? Character.toLowerCase(string.charAt(0)) : Character.toUpperCase(string.charAt(0))) + string.substring(1);
    }

    public static boolean isVowel(char c) {
        return VOWELS.indexOf(Character.toLowerCase(c)) != -1;
    }

    public static boolean isConsonant(char c) {
        return CONSONANTS.indexOf(Character.toLowerCase(c)) != -1;
    }

    public static char nextLetter(Random random) {
        return ALPHABET.charAt(random.nextInt(ALPHABET.length()));
    }

    public static char nextVowel(Random random) {
        return VOWELS.charAt(random.nextInt(VOWELS.length()));
    }

    public static char nextConsonant(Random random) {
        return CONSONANTS.charAt(random.nextInt(CONSONANTS.length()));
    }

    public static boolean canCharFollowChar(char c1, char c2) {
        if (CSString.isVowel(c1) || CSString.isVowel(c2)) {
            return true;
        }
        String s = new String(new char[]{Character.toLowerCase(c1), Character.toLowerCase(c2)});
        return CSArrays.contains(CONSONANTCOMBINATIONS, s);
    }
}

