/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.util;

import clashsoft.cslib.collections.CSCollections;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class CSArrays {
    public static <T> T[] create(T ... array) {
        return array;
    }

    public static <T> T[] create(int size, Class<T> type) {
        return (Object[])Array.newInstance(type, size);
    }

    public static <T> T[] create(int size, T ... array) {
        Object[] array1 = CSArrays.create(array.getClass().getComponentType(), Integer.valueOf(size));
        System.arraycopy(array, 0, array1, 0, array.length);
        return array1;
    }

    public static <T> Class<T> getComponentType(T[] array) {
        return array.getClass().getComponentType();
    }

    public static <T> Class getDeepComponentType(T[] array) {
        Class<?> c;
        Class<Object> ret = CSArrays.getComponentType(array);
        while ((c = ret.getComponentType()) != null && c != ret) {
            ret = c;
        }
        return ret;
    }

    public static <T> T[][] split(T[] array, int maxLength) {
        Class<?> clazz = array.getClass().getComponentType();
        int arrays = array.length / maxLength + 1;
        Object[][] ret = (Object[][])Array.newInstance(clazz, arrays, maxLength);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Object[])Array.newInstance(clazz, maxLength);
            for (int j = 0; j < maxLength && j + i * maxLength < array.length; ++j) {
                ret[i][j] = array[j + i * maxLength];
            }
        }
        return ret;
    }

    public static <T> T[] concat(T[] ... arrays) {
        ArrayList<T> list = new ArrayList<T>(arrays.length);
        for (int i = 0; i < arrays.length; ++i) {
            for (int j = 0; j < arrays[i].length; ++j) {
                list.add(arrays[i][j]);
            }
        }
        return CSArrays.fromList(CSArrays.getDeepComponentType(arrays), list);
    }

    public static <T> T[] removeDuplicates(T ... array) {
        if (array != null && array.length > 0) {
            ArrayList<T> result = new ArrayList<T>(array.length);
            for (T t1 : array) {
                Object t2;
                boolean duplicate = false;
                Iterator i$ = result.iterator();
                if (i$.hasNext() && Objects.equals(t1, t2 = i$.next())) {
                    duplicate = true;
                }
                if (duplicate) continue;
                result.add(t1);
            }
            return CSArrays.fromList(CSArrays.getComponentType(array), result);
        }
        return array;
    }

    public static <T> List<T> asList(T ... array) {
        return Arrays.asList(array);
    }

    public static <T> T[] fromList(Collection<? extends T> collection) {
        return CSCollections.toArray(collection);
    }

    public static <T> T[] fromList(Class<T> type, Collection<? extends T> collection) {
        return CSCollections.toArray(type, collection);
    }

    public static <T> int indexOf(T[] array, T object) {
        return CSArrays.indexOf(array, 0, object);
    }

    public static <T> int indexOf(T[] array, int start, T object) {
        for (int i = start; i < array.length; ++i) {
            if (!Objects.equals(object, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, T object) {
        return CSArrays.lastIndexOf(array, array.length - 1, object);
    }

    public static <T> int lastIndexOf(T[] array, int start, T object) {
        for (int i = start; i >= 0; --i) {
            if (!Objects.equals(object, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOfAny(T[] array, T ... objects) {
        for (T object : objects) {
            int index = CSArrays.indexOf(array, object);
            if (index == -1) continue;
            return index;
        }
        return -1;
    }

    public static <T> int lastIndexOfAny(T[] array, T ... objects) {
        for (T object : objects) {
            int index = CSArrays.lastIndexOf(array, object);
            if (index == -1) continue;
            return index;
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T object) {
        return CSArrays.indexOf(array, object) != -1;
    }

    public static <T> boolean containsAny(T[] array, T ... objects) {
        for (T object : objects) {
            if (!CSArrays.contains(array, object)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(T[] array, T ... objects) {
        for (T object : objects) {
            if (CSArrays.contains(array, object)) continue;
            return false;
        }
        return true;
    }

    public static Object[] primitiveTransform(Object array) {
        Object[] result;
        block8: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    result = (Object[])array;
                                    if (!(array instanceof boolean[])) break block7;
                                    boolean[] array1 = (boolean[])array;
                                    result = new Object[array1.length];
                                    for (int i = 0; i < array1.length; ++i) {
                                        result[i] = array1[i];
                                    }
                                    break block8;
                                }
                                if (!(array instanceof byte[])) break block9;
                                byte[] array1 = (byte[])array;
                                result = new Object[array1.length];
                                for (int i = 0; i < array1.length; ++i) {
                                    result[i] = array1[i];
                                }
                                break block8;
                            }
                            if (!(array instanceof short[])) break block10;
                            short[] array1 = (short[])array;
                            result = new Object[array1.length];
                            for (int i = 0; i < array1.length; ++i) {
                                result[i] = array1[i];
                            }
                            break block8;
                        }
                        if (!(array instanceof int[])) break block11;
                        int[] array1 = (int[])array;
                        result = new Object[array1.length];
                        for (int i = 0; i < array1.length; ++i) {
                            result[i] = array1[i];
                        }
                        break block8;
                    }
                    if (!(array instanceof float[])) break block12;
                    float[] array1 = (float[])array;
                    result = new Object[array1.length];
                    for (int i = 0; i < array1.length; ++i) {
                        result[i] = Float.valueOf(array1[i]);
                    }
                    break block8;
                }
                if (!(array instanceof double[])) break block13;
                double[] array1 = (double[])array;
                result = new Object[array1.length];
                for (int i = 0; i < array1.length; ++i) {
                    result[i] = array1[i];
                }
                break block8;
            }
            if (!(array instanceof long[])) break block8;
            long[] array1 = (long[])array;
            result = new Object[array1.length];
            for (int i = 0; i < array1.length; ++i) {
                result[i] = array1[i];
            }
        }
        return result;
    }

    public static int indexOf(int[] array, int integer) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != integer) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(int[] intArray, int integer) {
        return CSArrays.indexOf(intArray, integer) != -1;
    }
}

