/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.reflect;

import clashsoft.cslib.util.CSLog;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class CSReflection {
    private static Field modifiersField;

    public static void setModifier(Field field, int mod, boolean flag) {
        try {
            field.setAccessible(true);
            int modifiers = modifiersField.getInt(field);
            modifiers = flag ? (modifiers |= mod) : (modifiers &= ~mod);
            modifiersField.setInt(field, modifiers);
        }
        catch (ReflectiveOperationException ex) {
            CSLog.error(ex);
        }
    }

    public static Class getCallerClass() {
        try {
            return Class.forName(CSReflection.getCallerClassName());
        }
        catch (ClassNotFoundException ex) {
            CSLog.error(ex);
            return null;
        }
    }

    public static String getCallerClassName() {
        return CSReflection.getCaller().getClassName();
    }

    public static StackTraceElement getCaller() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        String callerClassName = null;
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            String className = ste.getClassName();
            if (CSReflection.class.getName().equals(className) || className.startsWith("java.lang.Thread")) continue;
            if (callerClassName == null) {
                callerClassName = className;
                continue;
            }
            if (callerClassName.equals(className)) continue;
            return ste;
        }
        return null;
    }

    public static Method getMethod(Class clazz, String ... methodNames) {
        Method[] methods = clazz.getDeclaredMethods();
        for (String methodName : methodNames) {
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!methodName.equals(method.getName())) continue;
                return method;
            }
        }
        CSLog.error(new NoSuchMethodException("Method not found! (Class: " + clazz + "; Expected field names: " + Arrays.toString(methodNames)));
        return null;
    }

    public static <T, R> R invokeStatic(Class<? super T> clazz, Object[] args, String ... methodNames) {
        return CSReflection.invoke(clazz, null, args, methodNames);
    }

    public static <T, R> R invoke(T instance, Object[] args, String ... methodNames) {
        return CSReflection.invoke(instance.getClass(), instance, args, methodNames);
    }

    public static <T, R> R invoke(Class<? super T> clazz, T instance, Object[] args, String ... methodNames) {
        try {
            Method m = CSReflection.getMethod(clazz, methodNames);
            m.setAccessible(true);
            return (R)m.invoke(instance, args);
        }
        catch (Exception ex) {
            CSLog.error(ex);
            return null;
        }
    }

    public static <T> T[] getStaticObjects(Class clazz, Class<T> fieldType, boolean subtypes) {
        return CSReflection.getObjects(clazz, null, fieldType, subtypes);
    }

    public static <T> T[] getObjects(Class clazz, Object instance, Class<T> fieldType, boolean subtypes) {
        ArrayList<Object> list = new ArrayList<Object>();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Field field = fields[i];
                Class<?> c = field.getType();
                Object o = field.get(instance);
                if (c != fieldType && (!subtypes || !fieldType.isAssignableFrom(c))) continue;
                list.add(o);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return list.toArray();
    }

    public static Field getField(Class clazz, String ... fieldNames) throws NoSuchFieldException {
        Field[] fields = clazz.getDeclaredFields();
        for (String fieldName : fieldNames) {
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
        }
        CSLog.error(new NoSuchFieldException("Field not found! (Class: " + clazz + "; Expected field names: " + Arrays.toString(fieldNames)));
        return null;
    }

    public static int getFieldID(Class clazz, String ... fieldNames) throws NoSuchFieldException {
        Field[] fields = clazz.getDeclaredFields();
        for (String fieldName : fieldNames) {
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!fieldName.equals(field.getName())) continue;
                return i;
            }
        }
        CSLog.error(new NoSuchFieldException("Field not found! (Class: " + clazz + "; Expected field names: " + Arrays.toString(fieldNames)));
        return -1;
    }

    public static String getFieldName(Class clazz, int fieldID) {
        return CSReflection.getField(clazz, fieldID).getName();
    }

    public static Field getField(Class clazz, int fieldID) {
        return clazz.getDeclaredFields()[fieldID];
    }

    public static <T, R> R getStaticValue(Class<? super T> clazz, String ... fieldNames) {
        return CSReflection.getValue(clazz, null, fieldNames);
    }

    public static <T, R> R getValue(T instance, String ... fieldNames) {
        return CSReflection.getValue(instance.getClass(), instance, fieldNames);
    }

    public static <T, R> R getValue(Class<? super T> clazz, T instance, String ... fieldNames) {
        try {
            Field f = CSReflection.getField(clazz, fieldNames);
            f.setAccessible(true);
            return (R)f.get(instance);
        }
        catch (Exception ex) {
            CSLog.error(ex);
            return null;
        }
    }

    public static <T, R> R getStaticValue(Class<? super T> clazz, int fieldID) {
        return CSReflection.getValue(clazz, null, fieldID);
    }

    public static <T, R> R getValue(T instance, int fieldID) {
        return CSReflection.getValue(instance.getClass(), instance, fieldID);
    }

    public static <T, R> R getValue(Class<? super T> clazz, T instance, int fieldID) {
        try {
            Field f = CSReflection.getField(clazz, fieldID);
            f.setAccessible(true);
            return (R)f.get(instance);
        }
        catch (Exception ex) {
            CSLog.error(ex);
            return null;
        }
    }

    public static <T, V> void setStaticValue(Class<? super T> clazz, V value, String ... fieldNames) {
        CSReflection.setValue(clazz, null, value, fieldNames);
    }

    public static <T, V> void setValue(T instance, V value, String ... fieldNames) {
        CSReflection.setValue(instance.getClass(), instance, value, fieldNames);
    }

    public static <T, V> void setValue(Class<? super T> clazz, T instance, V value, String ... fieldNames) {
        try {
            Field f = CSReflection.getField(clazz, fieldNames);
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception ex) {
            CSLog.error(ex);
        }
    }

    public static <T, V> void setStaticValue(Class<? super T> clazz, V value, int fieldID) {
        CSReflection.setValue(clazz, null, value, fieldID);
    }

    public static <T, V> void setValue(T instance, V value, int fieldID) {
        CSReflection.setValue(instance.getClass(), instance, value, fieldID);
    }

    public static <T, V> void setValue(Class<? super T> clazz, T instance, V value, int fieldID) {
        try {
            Field f = CSReflection.getField(clazz, fieldID);
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception ex) {
            CSLog.error(ex);
        }
    }

    public static <T> T createInstance(Class<T> c, Object ... parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] == null) continue;
            parameterTypes[i] = parameters[i].getClass();
        }
        try {
            Constructor<T> constructor = c.getConstructor(parameterTypes);
            return constructor.newInstance(parameters);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        try {
            modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

