/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.world.gen;

import clashsoft.cslib.minecraft.world.gen.CustomTreeGen;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class CustomBigTreeGen
extends CustomTreeGen {
    public static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    public Random rand = new Random();
    public World worldObj;
    public int[] basePos = new int[]{0, 0, 0};
    public int heightLimit;
    public int height;
    public double heightAttenuation = 0.618;
    public double branchDensity = 1.0;
    public double branchSlope = 0.381;
    public double scaleWidth = 1.0;
    public double leafDensity = 1.0;
    public int trunkSize = 1;
    public int heightLimitLimit = 12;
    public int leafDistanceLimit = 4;
    public int[][] leafNodes;

    public CustomBigTreeGen(boolean blockUpdates, int minTreeHeight, Block log, Block leaf, int woodMetadata, int leavesMetadata, boolean vinesGrow) {
        super(blockUpdates, minTreeHeight, log, leaf, woodMetadata, leavesMetadata, vinesGrow);
    }

    public CustomBigTreeGen(boolean blockUpdates, int minTreeHeight, Block log, Block leaf, int woodMetadata, int leavesMetadata) {
        super(blockUpdates, minTreeHeight, log, leaf, woodMetadata, leavesMetadata);
    }

    public CustomBigTreeGen(boolean blockUpdates, int minTreeHeight, Block log, Block leaf) {
        super(blockUpdates, minTreeHeight, log, leaf);
    }

    public void generateLeafNodeList() {
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int[][] aint = new int[i * this.heightLimit][4];
        int j = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int k = 1;
        int l = this.basePos[1] + this.height;
        int i1 = j - this.basePos[1];
        aint[0][0] = this.basePos[0];
        aint[0][1] = j--;
        aint[0][2] = this.basePos[2];
        aint[0][3] = l;
        while (i1 >= 0) {
            float f = this.layerSize(i1);
            if (f < 0.0f) {
                --j;
                --i1;
                continue;
            }
            double d0 = 0.5;
            for (int j1 = 0; j1 < i; ++j1) {
                int[] aint2;
                int l1;
                double d2;
                double d1 = this.scaleWidth * (double)f * ((double)this.rand.nextFloat() + 0.328);
                int k1 = MathHelper.func_76128_c((double)(d1 * Math.sin(d2 = (double)this.rand.nextFloat() * 2.0 * Math.PI) + (double)this.basePos[0] + d0));
                int[] aint1 = new int[]{k1, j, l1 = MathHelper.func_76128_c((double)(d1 * Math.cos(d2) + (double)this.basePos[2] + d0))};
                if (this.checkBlockLine(aint1, aint2 = new int[]{k1, j + this.leafDistanceLimit, l1}) != -1) continue;
                int[] aint3 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                double d3 = Math.sqrt(Math.pow(Math.abs(this.basePos[0] - aint1[0]), 2.0) + Math.pow(Math.abs(this.basePos[2] - aint1[2]), 2.0));
                double d4 = d3 * this.branchSlope;
                aint3[1] = (double)aint1[1] - d4 > (double)l ? l : (int)((double)aint1[1] - d4);
                if (this.checkBlockLine(aint3, aint1) != -1) continue;
                aint[k][0] = k1;
                aint[k][1] = j;
                aint[k][2] = l1;
                aint[k][3] = aint3[1];
                ++k;
            }
            --j;
            --i1;
        }
        this.leafNodes = new int[k][4];
        System.arraycopy(aint, 0, this.leafNodes, 0, k);
    }

    public void genTreeLayer(int x, int y, int z, float f, byte b, Block block, int metadata) {
        int i1 = (int)((double)f + 0.618);
        byte b1 = otherCoordPairs[b];
        byte b2 = otherCoordPairs[b + 3];
        int[] coords = new int[]{x, y, z};
        int[] newCoords = new int[]{0, 0, 0};
        int k1 = -i1;
        newCoords[b] = coords[b];
        for (int j1 = -i1; j1 <= i1; ++j1) {
            newCoords[b1] = coords[b1] + j1;
            k1 = -i1;
            while (k1 <= i1) {
                double d0 = Math.pow((double)Math.abs(j1) + 0.5, 2.0) + Math.pow((double)Math.abs(k1) + 0.5, 2.0);
                if (d0 > (double)(f * f)) {
                    ++k1;
                    continue;
                }
                newCoords[b2] = coords[b2] + k1;
                Block block1 = this.worldObj.func_147439_a(newCoords[0], newCoords[1], newCoords[2]);
                if (block != block1) {
                    ++k1;
                    continue;
                }
                this.func_150516_a(this.worldObj, newCoords[0], newCoords[1], newCoords[2], block, metadata);
                ++k1;
            }
        }
    }

    public float layerSize(int layer) {
        if ((double)layer < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = (float)this.heightLimit / 2.0f - (float)layer;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f1), 2.0)));
        return f2 *= 0.5f;
    }

    public float leafSize(int layer) {
        return layer >= 0 && layer < this.leafDistanceLimit ? (layer != 0 && layer != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    public void generateLeafNode(int x, int y, int z) {
        int y1 = y + this.leafDistanceLimit;
        for (int l = y; l < y1; ++l) {
            float f = this.leafSize(l - y);
            this.genTreeLayer(x, l, z, f, (byte)1, this.leafBlock, 1);
        }
    }

    public void placeBlockLine(int[] src, int[] dest, Block block, int metadata) {
        int[] coords = new int[]{0, 0, 0};
        int b1 = 0;
        for (int b0 = 0; b0 < 3; ++b0) {
            coords[b0] = dest[b0] - src[b0];
            if (Math.abs(coords[b0]) <= Math.abs(coords[b1])) continue;
            b1 = b0;
        }
        if (coords[b1] != 0) {
            byte b2 = otherCoordPairs[b1];
            byte b3 = otherCoordPairs[b1 + 3];
            int b4 = coords[b1] > 0 ? 1 : -1;
            double d0 = (double)coords[b2] / (double)coords[b1];
            double d1 = (double)coords[b3] / (double)coords[b1];
            int[] aint3 = new int[]{0, 0, 0};
            int k = coords[b1] + b4;
            for (int j = 0; j != k; j += b4) {
                int i1;
                aint3[b1] = MathHelper.func_76128_c((double)((double)(src[b1] + j) + 0.5));
                aint3[b2] = MathHelper.func_76128_c((double)((double)src[b2] + (double)j * d0 + 0.5));
                aint3[b3] = MathHelper.func_76128_c((double)((double)src[b3] + (double)j * d1 + 0.5));
                int b5 = metadata;
                int l = Math.abs(aint3[0] - src[0]);
                int j1 = Math.max(l, i1 = Math.abs(aint3[2] - src[2]));
                if (j1 > 0) {
                    if (l == j1) {
                        b5 |= 4;
                    } else if (i1 == j1) {
                        b5 |= 8;
                    }
                }
                this.func_150516_a(this.worldObj, aint3[0], aint3[1], aint3[2], block, b5);
            }
        }
    }

    public void generateLeaves() {
        int j = this.leafNodes.length;
        for (int i = 0; i < j; ++i) {
            int k = this.leafNodes[i][0];
            int l = this.leafNodes[i][1];
            int i1 = this.leafNodes[i][2];
            this.generateLeafNode(k, l, i1);
        }
    }

    public boolean leafNodeNeedsBase(int layer) {
        return (double)layer >= (double)this.heightLimit * 0.2;
    }

    public void generateTrunk() {
        int i = this.basePos[0];
        int j = this.basePos[1];
        int k = this.basePos[1] + this.height;
        int l = this.basePos[2];
        int[] src = new int[]{i, j, l};
        int[] dest = new int[]{i, k, l};
        this.placeBlockLine(src, dest, this.leafBlock, this.leafMetadata);
        if (this.trunkSize == 2) {
            src[0] = src[0] + 1;
            dest[0] = dest[0] + 1;
            this.placeBlockLine(src, dest, this.leafBlock, this.leafMetadata);
            src[2] = src[2] + 1;
            dest[2] = dest[2] + 1;
            this.placeBlockLine(src, dest, this.leafBlock, this.leafMetadata);
            src[0] = src[0] + -1;
            dest[0] = dest[0] + -1;
            this.placeBlockLine(src, dest, this.leafBlock, this.leafMetadata);
        }
    }

    public void generateLeafNodeBases() {
        int j = this.leafNodes.length;
        int[] aint = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int i = 0; i < j; ++i) {
            int[] aint1 = this.leafNodes[i];
            int[] aint2 = new int[]{aint1[0], aint1[1], aint1[2]};
            aint[1] = aint1[3];
            int k = aint[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(k)) continue;
            this.placeBlockLine(aint, aint2, this.logBlock, this.logMetadata);
        }
    }

    public int checkBlockLine(int[] sourceCoords, int[] destCoords) {
        int i;
        int[] aint2 = new int[3];
        int b1 = 0;
        for (int b0 = 0; b0 < 3; b0 = (int)((byte)(b0 + 1))) {
            aint2[b0] = destCoords[b0] - sourceCoords[b0];
            if (Math.abs(aint2[b0]) <= Math.abs(aint2[b1])) continue;
            b1 = b0;
        }
        if (aint2[b1] == 0) {
            return -1;
        }
        byte b2 = otherCoordPairs[b1];
        byte b3 = otherCoordPairs[b1 + 3];
        int b4 = aint2[b1] > 0 ? 1 : -1;
        double d0 = (double)aint2[b2] / (double)aint2[b1];
        double d1 = (double)aint2[b3] / (double)aint2[b1];
        int[] aint3 = new int[]{0, 0, 0};
        int j = aint2[b1] + b4;
        for (i = 0; i != j; i += b4) {
            aint3[b1] = sourceCoords[b1] + i;
            aint3[b2] = MathHelper.func_76128_c((double)((double)sourceCoords[b2] + (double)i * d0));
            aint3[b3] = MathHelper.func_76128_c((double)((double)sourceCoords[b3] + (double)i * d1));
            Block block1 = this.worldObj.func_147439_a(aint3[0], aint3[1], aint3[2]);
            if (block1 != this.leafBlock) break;
        }
        return i == j ? -1 : Math.abs(i);
    }

    public boolean validTreeLocation() {
        boolean isValidSoil;
        int[] aint = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[] aint1 = new int[]{this.basePos[0], this.basePos[1] + this.heightLimit - 1, this.basePos[2]};
        Block soil = this.worldObj.func_147439_a(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        boolean bl = isValidSoil = soil != null && soil.canSustainPlant((IBlockAccess)this.worldObj, this.basePos[0], this.basePos[1] - 1, this.basePos[2], ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
        if (!isValidSoil) {
            return false;
        }
        int j = this.checkBlockLine(aint, aint1);
        if (j == -1) {
            return true;
        }
        if (j < 6) {
            return false;
        }
        this.heightLimit = j;
        return true;
    }

    public void func_76487_a(double scaleHeight, double scaleWidth, double leafDensity) {
        this.heightLimitLimit = (int)(scaleHeight * 12.0);
        if (scaleHeight > 0.5) {
            this.leafDistanceLimit = 5;
        }
        this.scaleWidth = scaleWidth;
        this.leafDensity = leafDensity;
    }

    @Override
    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        this.worldObj = world;
        long l = random.nextLong();
        this.rand.setSeed(l);
        this.basePos[0] = x;
        this.basePos[1] = y;
        this.basePos[2] = z;
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation()) {
            return false;
        }
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateTrunk();
        this.generateLeafNodeBases();
        return true;
    }
}

