/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.util;

import clashsoft.cslib.minecraft.util.IParsable;
import clashsoft.cslib.util.CSLog;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class CSConfig {
    public static String configName = null;
    public static Configuration config = null;
    public static boolean enableComments = true;

    public static void loadConfig(File configFile, String configName) {
        if (config != null) {
            CSConfig.saveConfig();
        }
        CSLog.info("[CSCONFIG] Loading configuration file " + configName);
        config = new Configuration(configFile);
        CSConfig.configName = configName;
    }

    public static void loadConfig(File configFile) {
        CSConfig.loadConfig(configFile, configFile.getName());
    }

    public static void saveConfig() {
        config.save();
        config = null;
        CSLog.info("[CSCONFIG] Saving configuration file " + configName);
    }

    public static String getDefaultDesc(String key, Object _default) {
        return enableComments ? key + ". Default: " + _default : null;
    }

    public static void checkConfig() {
        if (config == null) {
            throw new IllegalStateException("No config loaded!");
        }
    }

    public static int getInt(String category, String key, int _default) {
        return CSConfig.getInt(category, key, CSConfig.getDefaultDesc(key, _default), _default);
    }

    public static float getFloat(String category, String key, float _default) {
        return CSConfig.getFloat(category, key, CSConfig.getDefaultDesc(key, Float.valueOf(_default)), _default);
    }

    public static double getDouble(String category, String key, double _default) {
        return CSConfig.getDouble(category, key, CSConfig.getDefaultDesc(key, _default), _default);
    }

    public static boolean getBool(String category, String key, boolean _default) {
        return CSConfig.getBool(category, key, CSConfig.getDefaultDesc(key, _default), _default);
    }

    public static String getString(String category, String key, String _default) {
        return CSConfig.getString(category, key, CSConfig.getDefaultDesc(key, _default), _default);
    }

    public static String getString(String category, String key, Object _default) {
        return CSConfig.getString(category, key, CSConfig.getDefaultDesc(key, _default), _default);
    }

    public static <T extends IParsable> T getObject(String category, String key, T _default) {
        return CSConfig.getObject(category, key, CSConfig.getDefaultDesc(key, _default), _default);
    }

    public static int getInt(String category, String key, String desc, int _default) {
        CSConfig.checkConfig();
        return config.get(category, key, _default, desc).getInt(_default);
    }

    public static float getFloat(String category, String key, String desc, float _default) {
        return (float)CSConfig.getDouble(category, key, desc, _default);
    }

    public static double getDouble(String category, String key, String desc, double _default) {
        CSConfig.checkConfig();
        return config.get(category, key, _default, desc).getDouble(_default);
    }

    public static boolean getBool(String category, String key, String desc, boolean _default) {
        CSConfig.checkConfig();
        return config.get(category, key, _default, desc).getBoolean(_default);
    }

    public static String getString(String category, String key, String desc, String _default) {
        CSConfig.checkConfig();
        return config.get(category, key, _default, desc).getString();
    }

    public static String getString(String category, String key, String desc, Object _default) {
        return CSConfig.getString(category, key, desc, _default.toString());
    }

    public static <T extends IParsable> T getObject(String category, String key, String desc, T _default) {
        return (T)_default.parse(CSConfig.getString(category, key, desc, _default.toString()));
    }

    public static int getItem(String key, int _default) {
        if (!key.contains("Item ID")) {
            key = key + " Item ID";
        }
        return CSConfig.getInt("item", key, _default);
    }

    public static int getTerrainBlock(String key, int _default) {
        if (!key.contains("Block ID")) {
            key = key + " Block ID";
        }
        return CSConfig.getInt("terrainblock", key, _default);
    }

    public static int getBlock(String key, int _default) {
        if (!key.contains("Block ID")) {
            key = key + " Block ID";
        }
        return CSConfig.getInt("block", key, _default);
    }

    public static int getTileEntity(String key, int _default) {
        if (!key.contains("TileEntity ID")) {
            key = key + " TileEntity ID";
        }
        return CSConfig.getInt("tileentity", key, _default);
    }

    public static int getDimension(String key, int _default) {
        if (!key.contains("Dimension ID")) {
            key = key + " Dimension ID";
        }
        return CSConfig.getInt("dim", key, _default);
    }

    public static int getBiome(String key, int _default) {
        if (!key.contains("Biome ID")) {
            key = key + " Biome ID";
        }
        return CSConfig.getInt("biome", key, _default);
    }
}

