/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.update;

import clashsoft.cslib.minecraft.update.ModUpdate;
import clashsoft.cslib.minecraft.util.CSWeb;
import clashsoft.cslib.util.CSLog;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class InstallUpdateThread
extends Thread {
    private ModUpdate update;
    private EntityPlayer player;

    public InstallUpdateThread(ModUpdate update, EntityPlayer player) {
        this.update = update;
        this.player = player;
    }

    @Override
    public void run() {
        if (this.update.isValid() && this.update.hasDownload()) {
            this.update.installStatus = 1;
            String modName = this.update.getModName();
            String newVersion = this.update.getNewVersion();
            String mod = this.update.getName();
            this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("update.install", new Object[]{modName, newVersion}));
            File dataDir = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? Minecraft.func_71410_x().field_71412_D : new File(MinecraftServer.func_71276_C().func_71270_I());
            File modsDir = new File(dataDir, "mods");
            try {
                File output = new File(modsDir, this.update.getDownloadedFileName());
                if (output.exists()) {
                    this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("update.install.skipping", new Object[]{mod}));
                    this.update.installStatus = 2;
                    return;
                }
                for (File f : modsDir.listFiles()) {
                    String fileName = f.getName();
                    if (!fileName.startsWith(modName)) continue;
                    this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("update.install.oldversion", new Object[]{modName, fileName}));
                    f.delete();
                }
                CSWeb.download(this.update.getUpdateURL(), output);
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("update.install.success", new Object[]{mod}));
                this.update.installStatus = 2;
            }
            catch (Exception ex) {
                CSLog.error(ex);
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("update.install.failure", new Object[]{mod, ex.getMessage()}));
                this.update.installStatus = -1;
            }
        }
    }
}

