/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.network;

import clashsoft.cslib.minecraft.network.CSPacket;
import clashsoft.cslib.util.CSLog;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;

@ChannelHandler.Sharable
public class CSNetHandler
extends MessageToMessageCodec<FMLProxyPacket, CSPacket> {
    public final String name;
    protected EnumMap<Side, FMLEmbeddedChannel> channels;
    protected List<Class<? extends CSPacket>> packets = new ArrayList<Class<? extends CSPacket>>();
    protected boolean initiliased = false;
    protected boolean postInitialised = false;

    public CSNetHandler(String name) {
        this.name = name;
    }

    public boolean registerPacket(Class<? extends CSPacket> clazz) {
        if (this.postInitialised) {
            return false;
        }
        if (this.packets.size() > 256 || this.packets.contains(clazz)) {
            return false;
        }
        this.packets.add(clazz);
        return true;
    }

    protected byte getDiscriminator(Class<? extends CSPacket> packetClass) {
        byte index = (byte)this.packets.indexOf(packetClass);
        if (index == -1) {
            throw new NullPointerException("No Packet Registered for: " + packetClass.getCanonicalName());
        }
        return index;
    }

    protected Class<? extends CSPacket> getClass(byte discriminator) {
        Class<? extends CSPacket> clazz = this.packets.get(discriminator);
        if (clazz == null) {
            throw new NullPointerException("No packet registered for discriminator: " + discriminator);
        }
        return clazz;
    }

    protected void encode(ChannelHandlerContext ctx, CSPacket msg, List<Object> out) throws Exception {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        Class<?> clazz = msg.getClass();
        byte discriminator = this.getDiscriminator(clazz);
        buffer.writeByte((int)discriminator);
        msg.write(buffer);
        FMLProxyPacket proxyPacket = new FMLProxyPacket(buffer.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        out.add(proxyPacket);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        ByteBuf payload = msg.payload();
        byte discriminator = payload.readByte();
        Class<? extends CSPacket> clazz = this.getClass(discriminator);
        PacketBuffer buffer = new PacketBuffer(payload.slice());
        CSPacket pkt = clazz.newInstance();
        pkt.read(buffer);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            EntityPlayerMP player = ((NetHandlerPlayServer)netHandler).field_147369_b;
            pkt.handleServer(player);
        } else {
            EntityPlayer player = this.getClientPlayer();
            pkt.handleClient(player);
        }
        out.add(pkt);
    }

    public void init() {
        if (this.initiliased) {
            return;
        }
        this.initiliased = true;
        this.channels = NetworkRegistry.INSTANCE.newChannel(this.name, new ChannelHandler[]{this});
    }

    public void postInit() {
        if (!this.initiliased) {
            CSLog.warning("The net handler " + this.name + " is attempting to post-init, but it hasn't been initialised yet.");
        }
        if (this.postInitialised) {
            return;
        }
        this.postInitialised = true;
        Collections.sort(this.packets, new Comparator<Class>(){

            @Override
            public int compare(Class clazz1, Class clazz2) {
                String canon2;
                String canon1 = clazz1.getCanonicalName();
                int com = String.CASE_INSENSITIVE_ORDER.compare(canon1, canon2 = clazz2.getCanonicalName());
                if (com == 0) {
                    com = canon1.compareTo(canon2);
                }
                return com;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToAll(CSPacket message) {
        FMLEmbeddedChannel channel = this.channels.get(Side.SERVER);
        if (channel != null) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            channel.writeAndFlush((Object)message);
        } else {
            CSLog.error("Unable to send packet to players: No Server Channel!");
        }
    }

    public void sendTo(CSPacket message, EntityPlayerMP player) {
        FMLEmbeddedChannel channel = this.channels.get(Side.SERVER);
        if (channel != null) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            channel.writeAndFlush((Object)message);
        } else {
            CSLog.error("Unable to send packet to player: No Server Channel!");
        }
    }

    public void sendToAllAround(CSPacket message, NetworkRegistry.TargetPoint point) {
        FMLEmbeddedChannel channel = this.channels.get(Side.SERVER);
        if (channel != null) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            channel.writeAndFlush((Object)message);
        } else {
            CSLog.error("Unable to send packet to players around point: No Server Channel!");
        }
    }

    public void sendToDimension(CSPacket message, int dimensionId) {
        FMLEmbeddedChannel channel = this.channels.get(Side.SERVER);
        if (channel != null) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
            channel.writeAndFlush((Object)message);
        } else {
            CSLog.error("Unable to send packet to players in dimension: No Server Channel!");
        }
    }

    public void sendToServer(CSPacket message) {
        FMLEmbeddedChannel channel = this.channels.get(Side.CLIENT);
        if (channel != null) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
            channel.writeAndFlush((Object)message);
        } else {
            CSLog.error("Unable to send packet to server: No Client Channel!");
        }
    }

    public void send(CSPacket message) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.sendToServer(message);
        } else {
            this.sendToAll(message);
        }
    }
}

