/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.item.datatools;

import clashsoft.cslib.minecraft.item.datatools.ItemDataAxe;
import clashsoft.cslib.minecraft.item.datatools.ItemDataHoe;
import clashsoft.cslib.minecraft.item.datatools.ItemDataPickaxe;
import clashsoft.cslib.minecraft.item.datatools.ItemDataSpade;
import clashsoft.cslib.minecraft.item.datatools.ItemDataSword;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DataToolSet {
    public List<Item.ToolMaterial> materials = new ArrayList<Item.ToolMaterial>();
    public Map<String, Item.ToolMaterial> nameToMaterial = new HashMap<String, Item.ToolMaterial>();
    public Map<Item.ToolMaterial, String> materialToName = new HashMap<Item.ToolMaterial, String>();
    public ItemDataSword sword;
    public ItemDataSpade shovel;
    public ItemDataPickaxe pickaxe;
    public ItemDataAxe axe;
    public ItemDataHoe hoe;

    public DataToolSet(ItemDataSword sword, ItemDataSpade shovel, ItemDataPickaxe pickaxe, ItemDataAxe axe, ItemDataHoe hoe) {
        this.sword = sword;
        this.shovel = shovel;
        this.pickaxe = pickaxe;
        this.axe = axe;
        this.hoe = hoe;
    }

    public void registerToolMaterial(Item.ToolMaterial material, String name) {
        this.materials.add(material);
        this.materialToName.put(material, name);
        this.nameToMaterial.put(name, material);
    }

    public Item.ToolMaterial getToolMaterial(ItemStack stack) {
        return this.nameToMaterial.get(this.getMaterialName(stack));
    }

    public String getMaterialName(ItemStack stack) {
        if (stack != null) {
            NBTTagCompound nbt = stack.func_77978_p();
            return nbt.func_74779_i("ToolMaterial");
        }
        return null;
    }

    public ItemStack setToolMaterial(ItemStack stack, Item.ToolMaterial material) {
        return this.setMaterialName(stack, this.materialToName.get(material));
    }

    public ItemStack setMaterialName(ItemStack stack, String name) {
        if (stack != null) {
            NBTTagCompound nbt = stack.func_77978_p();
            nbt.func_74778_a("ToolMaterial", name);
        }
        return stack;
    }
}

