/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;

public class GuiBuilder
extends Gui {
    public static final ResourceLocation slots = new ResourceLocation("cslib", "textures/gui/container/slots.png");
    public static final ResourceLocation progress = new ResourceLocation("cslib", "textures/gui/container/progress.png");
    public static final ResourceLocation window = new ResourceLocation("cslib", "textures/gui/container/window.png");
    public static final ResourceLocation widgets = new ResourceLocation("cslib", "textures/gui/container/widgets.png");
    public static final GuiBuilder global = new GuiBuilder(null);
    public static int hoveringFrameDefaultColor = 0x5000FF;
    public static int hoveringFrameBackgroundColor = 0x10000F;
    public static int hoveringFrameAlpha = 176;
    public final Gui gui;
    public final Minecraft mc;
    public int width;
    public int height;

    public GuiBuilder(Gui gui) {
        this.gui = gui;
        this.mc = Minecraft.func_71410_x();
    }

    public void bind(ResourceLocation resourceLocation) {
        this.mc.field_71446_o.func_110577_a(resourceLocation);
    }

    public void drawFrame(int x, int y, int width, int height) {
        this.bind(window);
        this.drawFrame_(x, y, width, height);
    }

    public void drawFrame_(int x, int y, int width, int height) {
        boolean flag1 = width > 176;
        boolean flag2 = height > 166;
        int i = width - 4;
        int j = height - 4;
        int k = flag1 ? 172 : i;
        int l = flag2 ? 162 : j;
        this.func_73729_b(x, y, 0, 0, k, l);
        this.func_73729_b(x + i, y, 172, 0, 4, l);
        this.func_73729_b(x, y + j, 0, 162, k, 4);
        this.func_73729_b(x + i, y + j, 172, 162, 4, 4);
        if (flag1) {
            int x1 = x + 172;
            int k1 = i - 172;
            this.func_73729_b(x1, y, 4, 0, k1, l);
            this.func_73729_b(x1, y + j, 4, 162, k1, 4);
        }
        if (flag2) {
            int y1 = y + 162;
            int l1 = j - 162;
            this.func_73729_b(x, y1, 0, 4, k, l1);
            this.func_73729_b(x + i, y1, 172, 4, 4, l1);
            if (flag1) {
                this.func_73729_b(x + 172, y1, 4, 4, i - 172, l1);
            }
        }
    }

    public void drawPlayerBackgroundL(int x, int y) {
        this.drawWidget(x, y, 0, 0, 54, 72);
    }

    public void drawPlayerBackgroundS(int x, int y) {
        this.drawWidget(x, y, 54, 0, 34, 45);
    }

    public void drawWidget(int x, int y, int u, int v, int width, int height) {
        this.bind(widgets);
        this.drawWidget_(x, y, u, v, width, height);
    }

    public void drawWidget_(int x, int y, int u, int v, int width, int height) {
        this.func_73729_b(x, y, u, v, width, height);
    }

    public void drawSlots(int[] x, int[] y) {
        this.bind(slots);
        for (int i = 0; i < x.length; ++i) {
            this.drawSlot_(x[i], y[i], 0, false);
        }
    }

    public void drawSlots(int[] x, int[] y, int[] type) {
        this.bind(slots);
        for (int i = 0; i < x.length; ++i) {
            this.drawSlot_(x[i], y[i], type[i], false);
        }
    }

    public void drawSlots(int[] x, int[] y, int[] type, boolean[] locked) {
        this.bind(slots);
        for (int i = 0; i < x.length; ++i) {
            this.drawSlot_(x[i], y[i], type[i], locked[i]);
        }
    }

    public void drawSlot(int x, int y) {
        this.drawSlot(x, y, 0);
    }

    public void drawSlot(int x, int y, int type) {
        this.drawSlot(x, y, type, false);
    }

    public void drawSlot(int x, int y, int type, boolean locked) {
        this.bind(slots);
        this.drawSlot_(x - 5, y - 5, type, locked);
    }

    public void drawSlot_(int x, int y, int type, boolean locked) {
        this.func_73729_b(x, y, type * 32, locked ? 32 : 0, 32, 32);
    }

    public void drawHoveringFrame(int x, int y, int width, int height) {
        this.drawHoveringFrame(x, y, width, height, hoveringFrameDefaultColor);
    }

    public void drawHoveringFrame(int x, int y, int width, int height, int color) {
        this.drawHoveringFrame(x, y, width, height, color, hoveringFrameBackgroundColor, hoveringFrameAlpha);
    }

    public void drawHoveringFrame(int x, int y, int width, int height, int color, int bg, int alpha) {
        if (width < 2 || height < 2) {
            return;
        }
        alpha = (alpha & 0xFF) << 24;
        int bgAlpha = (bg &= 0xFFFFFF) | alpha;
        int colorAlpha = (color &= 0xFFFFFF) | alpha;
        int colorGradient = (color & 0xFEFEFE) >> 1 | alpha;
        GuiBuilder.func_73734_a((int)(x + 1), (int)y, (int)(x + width - 1), (int)(y + 1), (int)bgAlpha);
        GuiBuilder.func_73734_a((int)(x + 1), (int)(y + height - 1), (int)(x + width - 1), (int)(y + height), (int)bgAlpha);
        GuiBuilder.func_73734_a((int)(x + 2), (int)(y + 2), (int)(x + width - 2), (int)(y + height - 2), (int)bgAlpha);
        GuiBuilder.func_73734_a((int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)bgAlpha);
        GuiBuilder.func_73734_a((int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)bgAlpha);
        this.func_73733_a(x + 1, y + 2, x + 2, y + height - 2, colorAlpha, colorGradient);
        this.func_73733_a(x + width - 2, y + 2, x + width - 1, y + height - 2, colorAlpha, colorGradient);
        GuiBuilder.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + 2), (int)colorAlpha);
        GuiBuilder.func_73734_a((int)(x + 1), (int)(y + height - 2), (int)(x + width - 1), (int)(y + height - 1), (int)colorGradient);
    }
}

