/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.Bidi;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class CSFontRenderer
extends FontRenderer {
    private static final ResourceLocation[] field_111274_c = new ResourceLocation[256];
    public static final CSFontRenderer instance = new CSFontRenderer(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
    private final int[] charWidth = new int[256];
    public int field_78288_b = 9;
    public Random field_78289_c = new Random();
    private final byte[] glyphWidth = new byte[65536];
    public int[] field_78285_g = new int[32];
    private final ResourceLocation locationFontTexture;
    private float posX;
    private float posY;
    private boolean unicodeFlag;
    private boolean bidiFlag;
    private float red;
    private float blue;
    private float green;
    private float alpha;
    private int textColor;
    private boolean randomStyle = false;
    private boolean boldStyle = false;
    private boolean italicStyle = false;
    private boolean underlineStyle = false;
    private boolean strikethroughStyle = false;
    private TextureManager renderEngine;

    public CSFontRenderer(GameSettings gameSettings, ResourceLocation fontTexture, TextureManager textureManager, boolean unicode) {
        super(gameSettings, fontTexture, textureManager, unicode);
        this.locationFontTexture = fontTexture;
        this.renderEngine = textureManager;
        this.unicodeFlag = unicode;
        textureManager.func_110577_a(this.locationFontTexture);
        for (int i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i >> 0 & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            if (gameSettings.field_74337_g) {
                int j1 = (k * 30 + l * 59 + i1 * 11) / 100;
                int k1 = (k * 30 + l * 70) / 100;
                int l1 = (k * 30 + i1 * 70) / 100;
                k = j1;
                l = k1;
                i1 = l1;
            }
            if (i >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            this.field_78285_g[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
        this.readGlyphSizes();
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.readFontTexture();
    }

    private void readFontTexture() {
        BufferedImage bufferedimage;
        try {
            bufferedimage = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(this.locationFontTexture).func_110527_b());
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        int[] aint = new int[i * j];
        bufferedimage.getRGB(0, 0, i, j, aint, 0, i);
        int k = j / 16;
        int l = i / 16;
        int b0 = 1;
        float f = 8.0f / (float)l;
        for (int i1 = 0; i1 < 256; ++i1) {
            int l1;
            int j1 = i1 % 16;
            int k1 = i1 / 16;
            if (i1 == 32) {
                this.charWidth[i1] = 3 + b0;
            }
            for (l1 = l - 1; l1 >= 0; --l1) {
                int i2 = j1 * l + l1;
                boolean flag = true;
                for (int j2 = 0; j2 < k && flag; ++j2) {
                    int k2 = (k1 * l + j2) * i;
                    if ((aint[i2 + k2] >> 24 & 0xFF) == 0) continue;
                    flag = false;
                }
                if (!flag) break;
            }
            this.charWidth[i1] = (int)(0.5 + (double)((float)(++l1) * f)) + b0;
        }
    }

    private void readGlyphSizes() {
        try {
            InputStream inputstream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("font/glyph_sizes.bin")).func_110527_b();
            inputstream.read(this.glyphWidth);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
    }

    public static CSFontRenderer getFontRenderer() {
        return instance;
    }

    private float renderCharAtPos(int i, char c, boolean italic) {
        return c == ' ' ? 4.0f : (i > 0 && !this.unicodeFlag ? this.renderDefaultChar(i + 32, italic) : this.renderUnicodeChar(c, italic));
    }

    private float renderDefaultChar(int i, boolean italic) {
        float scale = 2.0f;
        float f = i % 16 * 8;
        float f1 = i / 16 * 8;
        float f2 = italic ? 1.0f : 0.0f;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.locationFontTexture);
        float f3 = (float)this.charWidth[i] - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.posX + f2), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.posX - f2), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f + f3) / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.posX + f3 + f2), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)((f + f3) / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.posX + f3 - f2), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glEnd();
        return this.charWidth[i];
    }

    private void loadGlyphTexture(int i) {
        this.renderEngine.func_110577_a(this.func_111271_a(i));
    }

    private ResourceLocation func_111271_a(int i) {
        if (field_111274_c[i] == null) {
            CSFontRenderer.field_111274_c[i] = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", i));
        }
        return field_111274_c[i];
    }

    private float renderUnicodeChar(char c, boolean italic) {
        if (this.glyphWidth[c] == 0) {
            return 0.0f;
        }
        int i = c / 256;
        this.loadGlyphTexture(i);
        int j = this.glyphWidth[c] >>> 4;
        int k = this.glyphWidth[c] & 0xF;
        float f = j;
        float f1 = k + 1;
        float f2 = (float)(c % 16 * 16) + f;
        float f3 = (c & 0xFF) / 16 * 16;
        float f4 = f1 - f - 0.02f;
        float f5 = italic ? 1.0f : 0.0f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.posX + f5), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.posX - f5), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.posX + f4 / 2.0f + f5), (float)this.posY, (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.posX + f4 / 2.0f - f5), (float)(this.posY + 7.99f), (float)0.0f);
        GL11.glEnd();
        return (f1 - f) / 2.0f + 1.0f;
    }

    public int func_78261_a(String string, int x, int y, int color) {
        return this.func_85187_a(string, x, y, color, true);
    }

    public int func_78276_b(String string, int x, int y, int color) {
        return this.func_85187_a(string, x, y, color, false);
    }

    public int func_85187_a(String string, int x, int y, int color, boolean shadow) {
        int l;
        this.resetStyles();
        if (this.bidiFlag) {
            string = this.bidiReorder(string);
        }
        if (shadow) {
            l = this.renderString(string, x + 1, y + 1, color, true);
            l = Math.max(l, this.renderString(string, x, y, color, false));
        } else {
            l = this.renderString(string, x, y, color, false);
        }
        return l;
    }

    private String bidiReorder(String string) {
        if (string != null && Bidi.requiresBidi(string.toCharArray(), 0, string.length())) {
            int i;
            Bidi bidi = new Bidi(string, -2);
            byte[] abyte = new byte[bidi.getRunCount()];
            Object[] astring = new String[abyte.length];
            for (int j = 0; j < abyte.length; ++j) {
                int k = bidi.getRunStart(j);
                i = bidi.getRunLimit(j);
                int l = bidi.getRunLevel(j);
                String s1 = string.substring(k, i);
                abyte[j] = (byte)l;
                astring[j] = s1;
            }
            String[] astring1 = (String[])astring.clone();
            Bidi.reorderVisually(abyte, 0, astring, 0, abyte.length);
            StringBuilder stringbuilder = new StringBuilder();
            for (i = 0; i < astring.length; ++i) {
                int i1;
                byte b0 = abyte[i];
                for (i1 = 0; i1 < astring1.length; ++i1) {
                    if (!astring1[i1].equals(astring[i])) {
                        continue;
                    }
                    b0 = abyte[i1];
                    break;
                }
                if ((b0 & 1) == 0) {
                    stringbuilder.append((String)astring[i]);
                    continue;
                }
                for (i1 = ((String)astring[i]).length() - 1; i1 >= 0; --i1) {
                    char c0 = ((String)astring[i]).charAt(i1);
                    if (c0 == '(') {
                        c0 = ')';
                    } else if (c0 == ')') {
                        c0 = '(';
                    }
                    stringbuilder.append(c0);
                }
            }
            return stringbuilder.toString();
        }
        return string;
    }

    private void resetStyles() {
        this.alpha = 1.0f;
        this.blue = 1.0f;
        this.green = 1.0f;
        this.red = 1.0f;
        this.randomStyle = false;
        this.boldStyle = false;
        this.italicStyle = false;
        this.underlineStyle = false;
        this.strikethroughStyle = false;
    }

    public void setColor_I(int color) {
        this.setColor_F((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 0 & 0xFF) / 255.0f);
    }

    public void setColor_F(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public void setColor_S(String color) {
        try {
            if (color.startsWith("0x")) {
                this.setColor_I(Integer.parseInt(color.substring(2), 16));
            } else if (color.contains(";")) {
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                String[] split = color.split(";");
                if (split.length >= 1) {
                    r = Float.parseFloat(split[0]);
                }
                if (split.length >= 2) {
                    g = Float.parseFloat(split[1]);
                }
                if (split.length >= 3) {
                    b = Float.parseFloat(split[2]);
                }
                this.setColor_F(r, g, b);
            } else {
                this.setColor_I(Integer.parseInt(color));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void updateColor(boolean shadow) {
        if (shadow) {
            GL11.glColor4f((float)(this.red / 4.0f), (float)(this.green / 4.0f), (float)(this.blue / 4.0f), (float)this.alpha);
        } else {
            GL11.glColor4f((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
        }
    }

    private void renderStringAtPos(String text, boolean shadow) {
        for (int i = 0; i < text.length(); ++i) {
            Tessellator tessellator;
            boolean flag1;
            char c = text.charAt(i);
            if (c == '\u00a7' && i + 1 < text.length()) {
                char c1 = text.charAt(i + 1);
                if (c1 == 'k') {
                    this.randomStyle = !this.randomStyle;
                } else if (c1 == 'l') {
                    this.boldStyle = !this.boldStyle;
                } else if (c1 == 'm') {
                    this.strikethroughStyle = !this.strikethroughStyle;
                } else if (c1 == 'n') {
                    this.underlineStyle = !this.underlineStyle;
                } else if (c1 == 'o') {
                    this.italicStyle = !this.italicStyle;
                } else if (c1 == 'r') {
                    this.resetStyles();
                    this.updateColor(shadow);
                } else if (c1 == 'C') {
                    int i2 = text.indexOf(91, i + 2);
                    int i3 = text.indexOf(93, i + 3);
                    if (i2 != -1 && i3 != -1) {
                        String s1 = text.substring(i2 + 1, i3);
                        this.setColor_S(s1);
                        this.updateColor(shadow);
                        i = i3;
                        continue;
                    }
                } else {
                    int i1 = "0123456789abcdef".indexOf(Character.toLowerCase(c1));
                    this.setColor_I(this.field_78285_g[i1]);
                    this.updateColor(shadow);
                }
                ++i;
                continue;
            }
            int j = Arrays.binarySearch(ChatAllowedCharacters.field_71567_b, c);
            if (this.randomStyle && j > 0) {
                int k;
                while (this.charWidth[j + 32] != this.charWidth[(k = this.field_78289_c.nextInt(ChatAllowedCharacters.field_71567_b.length)) + 32]) {
                }
                j = k;
            }
            float f = this.unicodeFlag ? 0.5f : 1.0f;
            boolean bl = flag1 = (j <= 0 || this.unicodeFlag) && shadow;
            if (flag1) {
                this.posX -= f;
                this.posY -= f;
            }
            float f1 = this.renderCharAtPos(j, c, this.italicStyle);
            if (flag1) {
                this.posX += f;
                this.posY += f;
            }
            if (this.boldStyle) {
                this.posX += f;
                if (flag1) {
                    this.posX -= f;
                    this.posY -= f;
                }
                this.renderCharAtPos(j, c, this.italicStyle);
                this.posX -= f;
                if (flag1) {
                    this.posX += f;
                    this.posY += f;
                }
                f1 += 1.0f;
            }
            if (this.strikethroughStyle) {
                tessellator = Tessellator.field_78398_a;
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                tessellator.func_78377_a((double)this.posX, (double)(this.posY + (float)(this.field_78288_b / 2)), 0.0);
                tessellator.func_78377_a((double)(this.posX + f1), (double)(this.posY + (float)(this.field_78288_b / 2)), 0.0);
                tessellator.func_78377_a((double)(this.posX + f1), (double)(this.posY + (float)(this.field_78288_b / 2) - 1.0f), 0.0);
                tessellator.func_78377_a((double)this.posX, (double)(this.posY + (float)(this.field_78288_b / 2) - 1.0f), 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
            }
            if (this.underlineStyle) {
                tessellator = Tessellator.field_78398_a;
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                int l = this.underlineStyle ? -1 : 0;
                tessellator.func_78377_a((double)(this.posX + (float)l), (double)(this.posY + (float)this.field_78288_b), 0.0);
                tessellator.func_78377_a((double)(this.posX + f1), (double)(this.posY + (float)this.field_78288_b), 0.0);
                tessellator.func_78377_a((double)(this.posX + f1), (double)(this.posY + (float)this.field_78288_b - 1.0f), 0.0);
                tessellator.func_78377_a((double)(this.posX + (float)l), (double)(this.posY + (float)this.field_78288_b - 1.0f), 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
            }
            this.posX += (float)((int)f1);
        }
    }

    private int renderStringAligned(String string, int x, int y, int off, int color, boolean shadow) {
        if (this.bidiFlag) {
            string = this.bidiReorder(string);
            int i1 = this.func_78256_a(string);
            x = x + off - i1;
        }
        return this.renderString(string, x, y, color, shadow);
    }

    private int renderString(String string, int x, int y, int color, boolean shadow) {
        if (string == null) {
            return 0;
        }
        if ((color & 0xFC000000) == 0) {
            color |= 0xFF000000;
        }
        if (shadow) {
            color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        }
        this.red = (float)(color >> 16 & 0xFF) / 255.0f;
        this.blue = (float)(color >> 8 & 0xFF) / 255.0f;
        this.green = (float)(color & 0xFF) / 255.0f;
        this.alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        GL11.glColor4f((float)this.red, (float)this.blue, (float)this.green, (float)this.alpha);
        this.posX = x;
        this.posY = y;
        this.renderStringAtPos(string, shadow);
        return (int)this.posX;
    }

    public int func_78256_a(String string) {
        if (string == null) {
            return 0;
        }
        int i = 0;
        boolean flag = false;
        for (int j = 0; j < string.length(); ++j) {
            char c0 = string.charAt(j);
            int k = this.func_78263_a(c0);
            if ((c0 == '\u00a7' || c0 == '@') && j + 2 < string.length() && string.charAt(j + 1) == 'C' && string.charAt(j + 2) == '[') {
                j = string.indexOf(93, j + 2);
                continue;
            }
            if (k < 0 && j < string.length() - 1) {
                if ((c0 = string.charAt(++j)) != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
                k = 0;
            }
            i += k;
            if (!flag) continue;
            ++i;
        }
        return i;
    }

    public int func_78263_a(char c) {
        if (c == '\u00a7') {
            return -1;
        }
        if (c == ' ') {
            return 4;
        }
        int i = Arrays.binarySearch(ChatAllowedCharacters.field_71567_b, c);
        if (i >= 0 && !this.unicodeFlag) {
            return this.charWidth[i + 32];
        }
        if (this.glyphWidth[c] != 0) {
            int j = this.glyphWidth[c] >>> 4;
            int k = this.glyphWidth[c] & 0xF;
            if (k > 7) {
                k = 15;
                j = 0;
            }
            return (++k - j) / 2 + 1;
        }
        return 0;
    }

    public String func_78269_a(String string, int width) {
        return this.func_78262_a(string, width, false);
    }

    public String func_78262_a(String string, int width, boolean reverse) {
        StringBuilder stringbuilder = new StringBuilder();
        int j = 0;
        int k = reverse ? string.length() - 1 : 0;
        int l = reverse ? -1 : 1;
        boolean flag1 = false;
        boolean flag2 = false;
        for (int i1 = k; i1 >= 0 && i1 < string.length() && j < width; i1 += l) {
            char c0 = string.charAt(i1);
            int j1 = this.func_78263_a(c0);
            if (flag1) {
                flag1 = false;
                if (c0 != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag2 = false;
                    }
                } else {
                    flag2 = true;
                }
            } else if (j1 < 0) {
                flag1 = true;
            } else {
                j += j1;
                if (flag2) {
                    ++j;
                }
            }
            if (j > width) break;
            if (reverse) {
                stringbuilder.insert(0, c0);
                continue;
            }
            stringbuilder.append(c0);
        }
        return stringbuilder.toString();
    }

    private String trimStringNewline(String string) {
        while (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void func_78279_b(String string, int x, int y, int width, int color) {
        this.resetStyles();
        this.textColor = color;
        string = this.trimStringNewline(string);
        this.renderSplitString(string, x, y, width, false);
    }

    private void renderSplitString(String string, int x, int y, int width, boolean shadow) {
        List list = this.func_78271_c(string, width);
        for (String s1 : list) {
            this.renderStringAligned(s1, x, y, width, this.textColor, shadow);
            y += this.field_78288_b;
        }
    }

    public int func_78267_b(String string, int width) {
        return this.field_78288_b * this.func_78271_c(string, width).size();
    }

    public void func_78264_a(boolean unicodeFlag) {
        this.unicodeFlag = unicodeFlag;
    }

    public boolean func_82883_a() {
        return this.unicodeFlag;
    }

    public void func_78275_b(boolean bidiFlag) {
        this.bidiFlag = bidiFlag;
    }

    public List func_78271_c(String string, int width) {
        return Arrays.asList(this.func_78280_d(string, width).split("\n"));
    }

    public String func_78280_d(String string, int width) {
        int j = this.sizeStringToWidth(string, width);
        if (string.length() <= j) {
            return string;
        }
        String s1 = string.substring(0, j);
        char c0 = string.charAt(j);
        boolean flag = c0 == ' ' || c0 == '\n';
        String s2 = CSFontRenderer.getFormatFromString(s1) + string.substring(j + (flag ? 1 : 0));
        return s1 + "\n" + this.func_78280_d(s2, width);
    }

    private int sizeStringToWidth(String string, int width) {
        int l;
        int j = string.length();
        int k = 0;
        int i1 = -1;
        boolean flag = false;
        for (l = 0; l < j; ++l) {
            char c0 = string.charAt(l);
            switch (c0) {
                case '\n': {
                    --l;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (l >= j - 1) break;
                    if ((c1 = string.charAt(++l)) != 'l' && c1 != 'L') {
                        if (c1 != 'r' && c1 != 'R' && !CSFontRenderer.isFormatColor(c1)) break;
                        flag = false;
                        break;
                    }
                    flag = true;
                    break;
                }
                case ' ': {
                    i1 = l;
                }
                default: {
                    k += this.func_78263_a(c0);
                    if (!flag) break;
                    ++k;
                }
            }
            if (c0 == '\n') {
                i1 = ++l;
                break;
            }
            if (k > width) break;
        }
        return l != j && i1 != -1 && i1 < l ? i1 : l;
    }

    private static boolean isFormatColor(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isFormatSpecial(char c) {
        return c >= 'k' && c <= 'o' || c >= 'K' && c <= 'O' || c == 'r' || c == 'R' || c == 'C';
    }

    private static String getFormatFromString(String string) {
        String s1 = "";
        int i = -1;
        int j = string.length();
        while ((i = string.indexOf(167, i + 1)) != -1) {
            if (i >= j - 1) continue;
            char c0 = string.charAt(i + 1);
            if (CSFontRenderer.isFormatColor(c0)) {
                s1 = "\u00a7" + c0;
                continue;
            }
            if (!CSFontRenderer.isFormatSpecial(c0)) continue;
            s1 = s1 + "\u00a7" + c0;
        }
        return s1;
    }

    public boolean func_78260_a() {
        return this.bidiFlag;
    }

    static {
        IReloadableResourceManager manager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        manager.func_110542_a((IResourceManagerReloadListener)instance);
        if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null) {
            instance.func_78264_a(Minecraft.func_71410_x().func_135016_M().func_135042_a());
            instance.func_78275_b(Minecraft.func_71410_x().func_135016_M().func_135044_b());
        }
    }
}

