/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.block;

import clashsoft.cslib.minecraft.block.ICustomBlock;
import clashsoft.cslib.minecraft.lang.I18n;
import clashsoft.cslib.util.CSString;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class CustomBlock
extends Block
implements ICustomBlock {
    public String[] names;
    public String[] iconNames;
    public String[][] iconNames2D;
    public IIcon[] icons;
    public IIcon[][] icons2D;
    public boolean field_149787_q;
    public int renderType;
    public ItemStack[] drops;
    public float[] hardnesses;
    public CreativeTabs[] tabs;
    public boolean[] enabled;

    public static String[] applyDomain(String[] names, String domain) {
        return CSString.concatAll(names, domain + ":", "");
    }

    protected CustomBlock(Material material, String[] names, CreativeTabs[] creativeTabs) {
        super(material);
        this.func_149663_c(names[0]);
        this.names = names;
        this.drops = new ItemStack[this.names.length];
        this.hardnesses = new float[this.names.length];
        this.enabled = new boolean[this.names.length];
        Arrays.fill(this.enabled, true);
        this.tabs = creativeTabs;
        if (this.tabs != null) {
            this.func_149647_a(creativeTabs[0]);
        }
    }

    public CustomBlock(Material material, String[] names, String[][] iconNames, CreativeTabs[] tabs) {
        this(material, names, tabs);
        this.iconNames2D = iconNames;
    }

    public CustomBlock(Material material, String[] names, String[] iconNames, CreativeTabs[] tabs) {
        this(material, names, tabs);
        this.iconNames = iconNames;
    }

    public CustomBlock(Material material, String[] names, String domain, CreativeTabs[] tabs) {
        this(material, names, CustomBlock.applyDomain(names, domain), tabs);
    }

    public CustomBlock(Material material, String name, String iconName, CreativeTabs tab) {
        this(material, new String[]{name}, new String[][]{{iconName, iconName, iconName, iconName, iconName, iconName}}, new CreativeTabs[]{tab});
    }

    public CustomBlock setEnabled(int metadata, boolean flag) {
        this.enabled[metadata] = flag;
        return this;
    }

    public CustomBlock setHardness(float hardness) {
        return this.setHardness(0, hardness);
    }

    public CustomBlock setHardness(int metadata, float hardness) {
        this.hardnesses[metadata] = hardness;
        return this;
    }

    public CustomBlock setHardnesses(float ... hardnessArray) {
        this.hardnesses = hardnessArray;
        return this;
    }

    public CustomBlock setDrops(int metadata, ItemStack drop) {
        this.drops[metadata] = drop;
        return this;
    }

    public CustomBlock setDrops(ItemStack ... drops) {
        this.drops = drops;
        return this;
    }

    public CustomBlock setCreativeTab(int metadata, CreativeTabs tab) {
        this.tabs[metadata] = tab;
        return this;
    }

    public CustomBlock setCreativeTabs(CreativeTabs ... tabs) {
        this.tabs = tabs;
        return this;
    }

    public CreativeTabs getCreativeTab(int metadata) {
        if (this.tabs == null) {
            return this.func_149708_J();
        }
        return this.tabs[metadata % this.tabs.length];
    }

    public String[] getNames() {
        return this.names;
    }

    public boolean func_149662_c() {
        return this.field_149787_q;
    }

    public boolean func_149686_d() {
        return this.renderType == 0;
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (this.icons2D != null) {
            try {
                return this.icons2D[metadata][side];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return this.icons2D[0][side];
            }
        }
        try {
            return this.icons[metadata];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.icons[0];
        }
    }

    public float func_149712_f(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) < this.hardnesses.length && this.hardnesses[world.func_72805_g(x, y, z)] > 0.0f) {
            return this.hardnesses[world.func_72805_g(x, y, z)];
        }
        return this.field_149782_v;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        if (this.iconNames2D != null) {
            int len = this.iconNames2D.length;
            this.icons2D = new IIcon[len][6];
            for (int i = 0; i < len; ++i) {
                String[] sides = this.iconNames2D[i];
                for (int j = 0; j < sides.length; ++j) {
                    this.icons2D[i][j] = iconRegister.func_94245_a(sides[j]);
                }
            }
        } else {
            int len = this.iconNames.length;
            this.icons = new IIcon[len];
            for (int i = 0; i < len; ++i) {
                this.icons[i] = iconRegister.func_94245_a(this.iconNames[i]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.enabled[i] || tab != this.getCreativeTab(i)) continue;
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    public int quantityDropped(int metadata, int fortune, Random random) {
        if (this.drops[metadata] != null) {
            return this.drops[metadata].field_77994_a;
        }
        return 1;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        if (this.drops[metadata] != null) {
            return this.drops[metadata].func_77973_b();
        }
        return super.func_149650_a(metadata, random, fortune);
    }

    public int func_149692_a(int metadata) {
        if (this.drops[metadata] != null) {
            return this.drops[metadata].func_77960_j();
        }
        return metadata;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return CustomBlock.getUnlocalizedName(this, stack, this.names);
    }

    public static String getUnlocalizedName(Block block, ItemStack stack, String[] names) {
        int metadata = stack.func_77960_j();
        return block.func_149739_a() + "." + names[metadata % names.length];
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list) {
        CustomBlock.addInformation(this, stack, list);
    }

    public static void addInformation(ICustomBlock block, ItemStack stack, List<String> list) {
        String key = block.getUnlocalizedName(stack) + ".desc";
        String desc = I18n.getString(key);
        if (desc != key) {
            String[] lines;
            for (String s : lines = CSString.lineArray(desc)) {
                list.add(s);
            }
        }
    }
}

