/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.block;

import clashsoft.cslib.minecraft.crafting.CSCrafting;
import clashsoft.cslib.minecraft.item.block.ItemCustomBlock;
import clashsoft.cslib.reflect.CSReflection;
import clashsoft.cslib.util.CSLog;
import clashsoft.cslib.util.CSString;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class CSBlocks {
    public static boolean replaceBlock(Block block, Block newBlock) {
        long now = System.currentTimeMillis();
        try {
            for (Field field : Blocks.class.getDeclaredFields()) {
                Block block1;
                if (!Block.class.isAssignableFrom(field.getType()) || (block1 = (Block)field.get(null)) != block) continue;
                FMLControlledNamespacedRegistry registry = GameData.getBlockRegistry();
                String registryName = registry.func_148750_c((Object)block1);
                int id = Block.func_149682_b((Block)block1);
                ItemBlock item = (ItemBlock)Item.func_150898_a((Block)block1);
                CSReflection.setModifier(field, 16, false);
                field.set(null, newBlock);
                CSReflection.invoke(FMLControlledNamespacedRegistry.class, registry, new Object[]{id, registryName, newBlock}, "addObjectRaw");
                if (item != null) {
                    CSReflection.setValue(ItemBlock.class, item, newBlock, 0);
                }
                now = System.currentTimeMillis() - now;
                CSLog.info("Replace Item : %s (%s) with %s", field.getName(), block1.getClass().getSimpleName(), newBlock.getClass().getSimpleName(), now);
                return true;
            }
        }
        catch (Exception e) {
            CSLog.error(e);
        }
        return false;
    }

    public static void addAllBlocks(Class mod) {
        Block[] blocks;
        for (Block block : blocks = CSReflection.getStaticObjects(mod, Block.class, true)) {
            CSBlocks.addBlock(block);
        }
    }

    public static void addBlock(Block block) {
        String name = block.func_149739_a();
        if (name.startsWith("tile.")) {
            name = name.substring(5);
        }
        CSBlocks.addBlock(block, name);
    }

    public static void addBlock(Block block, String name) {
        CSBlocks.addBlock(block, ItemCustomBlock.class, name);
    }

    public static void addBlock(Block block, Class<? extends ItemBlock> itemClass, String name) {
        name = CSString.identifier(name);
        block.func_149663_c(name);
        GameRegistry.registerBlock((Block)block, itemClass, (String)name);
    }

    public static void addBlockWithRecipe(Block block, String name, int craftingAmount, Object ... recipe) {
        CSBlocks.addBlock(block, name);
        CSCrafting.addRecipe(new ItemStack(block, craftingAmount), recipe);
    }
}

