/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.block;

import clashsoft.cslib.minecraft.block.CustomBlock;
import clashsoft.cslib.minecraft.block.ICustomBlock;
import clashsoft.cslib.util.CSString;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCustomPlant
extends CustomBlock
implements ICustomBlock,
IPlantable {
    @SideOnly(value=Side.CLIENT)
    public IIcon[] icons;

    public BlockCustomPlant(String[] names, String[] icons) {
        super(Material.field_151585_k, names, icons, null);
        this.func_149676_a(0.3f, 0.0f, 0.3f, 0.7f, 0.6f, 0.7f);
        this.func_149672_a(Block.field_149779_h);
    }

    public BlockCustomPlant(String[] names, String domain) {
        this(names, CSString.concatAll(names, domain + ":", ""));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.icons[metadata];
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        return super.func_149707_d(world, x, y, z, side) && this.canBlockStay(world, x, y, z, 0);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.checkFlowerChange(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        super.func_149695_a(world, x, y, z, neighborBlock);
        this.checkFlowerChange(world, x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        this.checkFlowerChange(world, x, y, z);
    }

    protected void checkFlowerChange(World world, int x, int y, int z) {
        this.checkFlowerChange(world, x, y, z, world.func_72805_g(x, y, z));
    }

    protected void checkFlowerChange(World world, int x, int y, int z, int metadata) {
        if (!this.canBlockStay(world, x, y, z, metadata)) {
            this.func_149697_b(world, x, y, z, metadata, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.canBlockStay(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public boolean canBlockStay(World world, int x, int y, int z, int metadata) {
        Block soil = world.func_147439_a(x, y - 1, z);
        if (soil == null) {
            return false;
        }
        boolean validLight = world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z);
        boolean validSoil = soil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
        return validLight && this.isValidGround(metadata, soil, world.func_72805_g(x, y - 1, z));
    }

    public boolean isValidGround(World world, int x, int y, int z) {
        return this.isValidGround(world.func_72805_g(x, y, z), world.func_147439_a(x, y - 1, z), world.func_72805_g(x, y - 1, z));
    }

    public boolean isValidGround(int metadata, Block block, int blockMetadata) {
        return block == Blocks.field_150346_d || block == Blocks.field_150349_c;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return 1;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public int func_149692_a(int metadata) {
        return metadata;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List itemList) {
        for (int i = 0; i < this.names.length; ++i) {
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.iconNames.length];
        for (int i = 0; i < this.iconNames.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a(this.iconNames[i]);
        }
        this.iconNames = null;
    }
}

