/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.block;

import clashsoft.cslib.minecraft.block.CustomBlock;
import clashsoft.cslib.minecraft.block.ICustomBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCustomLog
extends BlockRotatedPillar
implements ICustomBlock {
    public String[] names;
    public String[] topIconNames;
    public String[] sideIconNames;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] sideIcons;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] topIcons;

    public BlockCustomLog(String name, String topIcon, String sideIcon) {
        this(new String[]{name}, new String[]{topIcon}, new String[]{sideIcon});
    }

    public BlockCustomLog(String[] names, String[] topIcons, String[] sideIcons) {
        super(Material.field_151575_d);
        this.func_149672_a(Block.field_149766_f);
        this.func_149711_c(2.0f);
        this.names = names;
        this.topIconNames = topIcons;
        this.sideIconNames = sideIcons;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldBlockMetadata) {
        int b0 = 4;
        int j1 = b0 + 1;
        if (world.func_72904_c(x - j1, y - j1, z - j1, x + j1, y + j1, z + j1)) {
            for (int k1 = -b0; k1 <= b0; ++k1) {
                for (int l1 = -b0; l1 <= b0; ++l1) {
                    for (int i2 = -b0; i2 <= b0; ++i2) {
                        Block block = world.func_147439_a(x + k1, y + l1, z + i2);
                        block.beginLeavesDecay(world, x + k1, y + l1, z + i2);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon func_150163_b(int metadata) {
        return this.sideIcons[metadata];
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon func_150161_d(int metadata) {
        return this.topIcons[metadata];
    }

    public static int limitToValidMetadata(int metadata) {
        return metadata & 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
        for (int i = 0; i < this.names.length; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        int i;
        int len1 = this.topIconNames.length;
        int len2 = this.sideIconNames.length;
        this.topIcons = new IIcon[len1];
        this.sideIcons = new IIcon[len2];
        for (i = 0; i < len1; ++i) {
            this.topIcons[i] = iconRegister.func_94245_a(this.topIconNames[i]);
        }
        for (i = 0; i < len2; ++i) {
            this.sideIcons[i] = iconRegister.func_94245_a(this.sideIconNames[i]);
        }
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) & 3;
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return CustomBlock.getUnlocalizedName((Block)this, stack, this.names);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list) {
        CustomBlock.addInformation(this, stack, list);
    }
}

