/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft.block;

import clashsoft.cslib.minecraft.block.CustomBlock;
import clashsoft.cslib.minecraft.block.ICustomBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCustomLeaves
extends BlockLeaves
implements ICustomBlock {
    public String[] names;
    public String[] iconNames;
    public ItemStack[] appleStacks = new ItemStack[4];
    public ItemStack[] saplingStacks = new ItemStack[4];
    public boolean[] isColored = new boolean[4];
    public IIcon[] icons;
    public IIcon[] opaqueIcons;
    public int[] adjacentTreeBlocks;
    public static boolean graphicsLevel;

    public BlockCustomLeaves(String[] names, String[] iconNames) {
        this.func_149675_a(true);
        this.func_149672_a(Block.field_149779_h);
        this.func_149713_g(1);
        this.names = names;
        this.iconNames = iconNames;
    }

    public BlockCustomLeaves(String[] names, String domain) {
        this(names, CustomBlock.applyDomain(names, domain));
    }

    public BlockCustomLeaves setAppleStacks(ItemStack ... appleStacks) {
        this.appleStacks = appleStacks;
        return this;
    }

    public BlockCustomLeaves setSaplingStacks(ItemStack ... saplingStacks) {
        this.saplingStacks = saplingStacks;
        return this;
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return CustomBlock.getUnlocalizedName((Block)this, stack, this.names);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list) {
        CustomBlock.addInformation(this, stack, list);
    }

    public String[] func_150125_e() {
        return this.names;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (this.isColored[world.func_72805_g(x, y, z) & 3]) {
            return super.func_149720_d(world, x, y, z);
        }
        return 0xFFFFFF;
    }

    public int func_149745_a(Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        ItemStack stack = this.saplingStacks[metadata];
        return stack != null ? stack.func_77973_b() : null;
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float dropChance, int fortune) {
        if (!world.field_72995_K) {
            ItemStack stack;
            int j1 = 20;
            if (fortune > 0 && (j1 -= 2 << fortune) < 10) {
                j1 = 10;
            }
            if (world.field_73012_v.nextInt(j1) == 0 && (stack = this.saplingStacks[metadata & 3]) != null) {
                this.func_149642_a(world, x, y, z, stack);
            }
            j1 = 200;
            if (fortune > 0 && (j1 -= 10 << fortune) < 40) {
                j1 = 40;
            }
            if (world.field_73012_v.nextInt(j1) == 0 && (stack = this.appleStacks[metadata & 3]) != null) {
                this.func_149642_a(world, x, y, z, stack);
            }
        }
    }

    public boolean func_149662_c() {
        return !graphicsLevel;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        graphicsLevel = Minecraft.func_71410_x().field_71474_y.field_74347_j;
        return graphicsLevel ? this.icons[metadata & 3] : this.opaqueIcons[metadata & 3];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
        for (int i = 0; i < this.names.length; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        int len = this.iconNames.length;
        this.icons = new IIcon[len];
        this.opaqueIcons = new IIcon[len];
        for (int i = 0; i < len; ++i) {
            this.icons[i] = iconRegister.func_94245_a(this.iconNames[i]);
            this.opaqueIcons[i] = iconRegister.func_94245_a(this.iconNames[i] + "_opaque");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        return graphicsLevel || block != this;
    }
}

