/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.minecraft;

import clashsoft.cslib.minecraft.common.BaseProxy;
import clashsoft.cslib.minecraft.network.CSNetHandler;
import clashsoft.cslib.minecraft.util.CSConfig;
import clashsoft.cslib.util.CSLog;
import clashsoft.cslib.util.CSString;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;

public abstract class BaseMod<N extends CSNetHandler> {
    public String modID;
    public String name;
    public String acronym;
    public String version;
    public String logoFile = "";
    public String url = "";
    public List<String> authors = Collections.EMPTY_LIST;
    public boolean hasConfig;
    public Class<N> netHandlerClass;
    public N netHandler;
    public Object eventHandler;
    public BaseProxy proxy;
    public boolean isClient;

    public BaseMod(BaseProxy proxy, String modID, String name, String version) {
        this(proxy, modID, name, CSString.getAcronym(name), version);
    }

    public BaseMod(BaseProxy proxy, String modID, String name, String acronym, String version) {
        this.proxy = proxy;
        this.modID = modID;
        this.name = name;
        this.acronym = acronym;
        this.version = version;
        this.logoFile = this.modID + ":logo.png";
        this.isClient = proxy == null ? FMLCommonHandler.instance().getSide().isClient() : proxy.isClient();
    }

    public void readConfig() {
        CSLog.warning("The mod " + this.name + " claims that it has a config, but doesn't override the read method.");
    }

    public void updateCheck() {
    }

    public N createNetHandler() {
        if (this.netHandlerClass != null) {
            try {
                return (N)((Object)((CSNetHandler)((Object)this.netHandlerClass.newInstance())));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return (N)((Object)new CSNetHandler(this.name));
    }

    public void writeMetadata(ModMetadata metadata) {
        metadata.autogenerated = false;
        metadata.name = this.name;
        metadata.modId = this.modID;
        metadata.version = this.version;
        metadata.logoFile = this.logoFile;
        metadata.url = this.url;
        metadata.authorList = this.authors;
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.writeMetadata(event.getModMetadata());
        if (this.hasConfig) {
            File configFile = new File(event.getModConfigurationDirectory(), this.name + ".cfg");
            CSConfig.loadConfig(configFile, this.name);
            this.readConfig();
            CSConfig.saveConfig();
        }
        if (this.proxy != null) {
            NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.proxy);
            this.proxy.preInit(event);
        }
        if (this.netHandler == null) {
            this.netHandler = this.createNetHandler();
        }
        if (this.eventHandler != null) {
            MinecraftForge.EVENT_BUS.register(this.eventHandler);
            FMLCommonHandler.instance().bus().register(this.eventHandler);
        }
    }

    public void init(FMLInitializationEvent event) {
        if (this.proxy != null) {
            this.proxy.init(event);
        }
        if (this.netHandler != null) {
            ((CSNetHandler)((Object)this.netHandler)).init();
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (this.isClient) {
            this.updateCheck();
        }
        if (this.proxy != null) {
            this.proxy.postInit(event);
        }
        if (this.netHandler != null) {
            ((CSNetHandler)((Object)this.netHandler)).postInit();
        }
    }
}

