/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.math;

public class CSBits {
    public static boolean checkBit(long number, int pos) {
        return (number & (long)(1 << pos)) != 0L;
    }

    public static long setBit(long number, int pos, boolean value) {
        long bitToSet = 1L << pos;
        return value ? number | bitToSet : (number | bitToSet) ^ bitToSet;
    }

    public static boolean[] getBits(byte b) {
        boolean[] bits = new boolean[8];
        return CSBits.getBits(b, bits);
    }

    public static boolean[] getBits(short s) {
        boolean[] bits = new boolean[16];
        return CSBits.getBits(s, bits);
    }

    public static boolean[] getBits(int i) {
        boolean[] bits = new boolean[32];
        return CSBits.getBits(i, bits);
    }

    public static boolean[] getBits(long l) {
        boolean[] bits = new boolean[64];
        return CSBits.getBits(l, bits);
    }

    public static boolean[] getBits(float f) {
        return CSBits.getBits(Float.floatToRawIntBits(f));
    }

    public static boolean[] getBits(double d) {
        return CSBits.getBits(Double.doubleToRawLongBits(d));
    }

    public static boolean[] getBits(char c) {
        return CSBits.getBits((int)c);
    }

    private static boolean[] getBits(byte b, boolean[] bits) {
        bits[0] = (b & 1) != 0;
        bits[1] = (b & 2) != 0;
        bits[2] = (b & 4) != 0;
        bits[3] = (b & 8) != 0;
        bits[4] = (b & 0x10) != 0;
        bits[5] = (b & 0x20) != 0;
        bits[6] = (b & 0x40) != 0;
        bits[7] = (b & 0x80) != 0;
        return bits;
    }

    private static boolean[] getBits(short s, boolean[] bits) {
        CSBits.getBits((byte)(s & 0xFF), bits);
        bits[8] = (s & 0x100) != 0;
        bits[9] = (s & 0x200) != 0;
        bits[10] = (s & 0x400) != 0;
        bits[11] = (s & 0x800) != 0;
        bits[12] = (s & 0x1000) != 0;
        bits[13] = (s & 0x2000) != 0;
        bits[14] = (s & 0x4000) != 0;
        bits[15] = (s & 0x8000) != 0;
        return bits;
    }

    private static boolean[] getBits(int i, boolean[] bits) {
        CSBits.getBits((short)(i & 0xFFFF), bits);
        bits[16] = (i & 0x10000) != 0;
        bits[17] = (i & 0x20000) != 0;
        bits[18] = (i & 0x40000) != 0;
        bits[19] = (i & 0x80000) != 0;
        bits[20] = (i & 0x100000) != 0;
        bits[21] = (i & 0x200000) != 0;
        bits[22] = (i & 0x400000) != 0;
        bits[23] = (i & 0x800000) != 0;
        bits[24] = (i & 0x1000000) != 0;
        bits[25] = (i & 0x2000000) != 0;
        bits[26] = (i & 0x4000000) != 0;
        bits[27] = (i & 0x8000000) != 0;
        bits[28] = (i & 0x10000000) != 0;
        bits[29] = (i & 0x20000000) != 0;
        bits[30] = (i & 0x40000000) != 0;
        bits[31] = (i & Integer.MIN_VALUE) != 0;
        return bits;
    }

    private static boolean[] getBits(long l, boolean[] bits) {
        CSBits.getBits((int)(l & 0xFFFFFFFFFFFFFFFFL), bits);
        bits[32] = (l & 0x100000000L) != 0L;
        bits[33] = (l & 0x200000000L) != 0L;
        bits[34] = (l & 0x400000000L) != 0L;
        bits[35] = (l & 0x800000000L) != 0L;
        bits[36] = (l & 0x1000000000L) != 0L;
        bits[37] = (l & 0x2000000000L) != 0L;
        bits[38] = (l & 0x4000000000L) != 0L;
        bits[39] = (l & 0x8000000000L) != 0L;
        bits[40] = (l & 0x10000000000L) != 0L;
        bits[41] = (l & 0x20000000000L) != 0L;
        bits[42] = (l & 0x40000000000L) != 0L;
        bits[43] = (l & 0x80000000000L) != 0L;
        bits[44] = (l & 0x100000000000L) != 0L;
        bits[45] = (l & 0x200000000000L) != 0L;
        bits[46] = (l & 0x400000000000L) != 0L;
        bits[47] = (l & 0x800000000000L) != 0L;
        bits[48] = (l & 0x1000000000000L) != 0L;
        bits[49] = (l & 0x2000000000000L) != 0L;
        bits[50] = (l & 0x4000000000000L) != 0L;
        bits[51] = (l & 0x8000000000000L) != 0L;
        bits[52] = (l & 0x10000000000000L) != 0L;
        bits[53] = (l & 0x20000000000000L) != 0L;
        bits[54] = (l & 0x40000000000000L) != 0L;
        bits[55] = (l & 0x80000000000000L) != 0L;
        bits[56] = (l & 0x100000000000000L) != 0L;
        bits[57] = (l & 0x200000000000000L) != 0L;
        bits[58] = (l & 0x400000000000000L) != 0L;
        bits[59] = (l & 0x800000000000000L) != 0L;
        bits[60] = (l & 0x1000000000000000L) != 0L;
        bits[61] = (l & 0x2000000000000000L) != 0L;
        bits[62] = (l & 0x4000000000000000L) != 0L;
        bits[63] = (l & Long.MIN_VALUE) != 0L;
        return bits;
    }

    public static void checkLength(boolean[] bits, int size) {
        if (bits.length < size) {
            throw new IllegalArgumentException("Bit array to short! Length must be at least " + size);
        }
    }

    public static byte getByte(boolean[] bits) {
        CSBits.checkLength(bits, 8);
        return CSBits.getByte_(bits);
    }

    public static short getShort(boolean[] bits) {
        CSBits.checkLength(bits, 16);
        return CSBits.getShort_(bits);
    }

    public static int getInt(boolean[] bits) {
        CSBits.checkLength(bits, 32);
        return CSBits.getInt_(bits);
    }

    public static long getLong(boolean[] bits) {
        CSBits.checkLength(bits, 64);
        return CSBits.getLong_(bits);
    }

    public static float getFloat(boolean[] bits) {
        return Float.intBitsToFloat(CSBits.getInt(bits));
    }

    public static double getDouble(boolean[] bits) {
        return Double.longBitsToDouble(CSBits.getLong(bits));
    }

    public static char getChar(boolean[] bits) {
        return (char)CSBits.getInt(bits);
    }

    private static byte getByte_(boolean[] bits) {
        byte b0 = (byte)((bits[0] ? 1 : 0) | (bits[1] ? 2 : 0) | (bits[2] ? 4 : 0) | (bits[3] ? 8 : 0) | (bits[4] ? 16 : 0) | (bits[5] ? 32 : 0) | (bits[6] ? 64 : 0) | (bits[7] ? 128 : 0));
        return b0;
    }

    private static short getShort_(boolean[] bits) {
        byte b0 = CSBits.getByte_(bits);
        short b1 = (short)((bits[8] ? 256 : 0) | (bits[9] ? 512 : 0) | (bits[10] ? 1024 : 0) | (bits[11] ? 2048 : 0) | (bits[12] ? 4096 : 0) | (bits[13] ? 8192 : 0) | (bits[14] ? 16384 : 0) | (bits[15] ? 32768 : 0));
        return (short)(b0 | b1);
    }

    private static int getInt_(boolean[] bits) {
        short b0 = CSBits.getShort_(bits);
        int b3 = (bits[16] ? 65536 : 0) | (bits[17] ? 131072 : 0) | (bits[18] ? 262144 : 0) | (bits[19] ? 524288 : 0) | (bits[20] ? 0x100000 : 0) | (bits[21] ? 0x200000 : 0) | (bits[22] ? 0x400000 : 0) | (bits[23] ? 0x800000 : 0);
        int b4 = (bits[24] ? 0x1000000 : 0) | (bits[25] ? 0x2000000 : 0) | (bits[26] ? 0x4000000 : 0) | (bits[27] ? 0x8000000 : 0) | (bits[28] ? 0x10000000 : 0) | (bits[29] ? 0x20000000 : 0) | (bits[30] ? 0x40000000 : 0) | (bits[31] ? Integer.MIN_VALUE : 0);
        return b0 | b3 | b4;
    }

    private static long getLong_(boolean[] bits) {
        int b0 = CSBits.getInt_(bits);
        long b4 = (byte)((bits[32] ? 0x100000000L : 0L) | (bits[33] ? 0x200000000L : 0L) | (bits[34] ? 0x400000000L : 0L) | (bits[35] ? 0x800000000L : 0L) | (bits[36] ? 0x1000000000L : 0L) | (bits[37] ? 0x2000000000L : 0L) | (bits[38] ? 0x4000000000L : 0L) | (bits[39] ? 0x8000000000L : 0L));
        long b5 = (byte)((bits[40] ? 0x10000000000L : 0L) | (bits[41] ? 0x20000000000L : 0L) | (bits[42] ? 0x40000000000L : 0L) | (bits[43] ? 0x80000000000L : 0L) | (bits[44] ? 0x100000000000L : 0L) | (bits[45] ? 0x200000000000L : 0L) | (bits[46] ? 0x400000000000L : 0L) | (bits[47] ? 0x800000000000L : 0L));
        long b6 = (byte)((bits[48] ? 0x1000000000000L : 0L) | (bits[49] ? 0x2000000000000L : 0L) | (bits[50] ? 0x4000000000000L : 0L) | (bits[51] ? 0x8000000000000L : 0L) | (bits[52] ? 0x10000000000000L : 0L) | (bits[53] ? 0x20000000000000L : 0L) | (bits[54] ? 0x40000000000000L : 0L) | (bits[55] ? 0x80000000000000L : 0L));
        long b7 = (byte)((bits[56] ? 0x100000000000000L : 0L) | (bits[57] ? 0x200000000000000L : 0L) | (bits[58] ? 0x400000000000000L : 0L) | (bits[59] ? 0x800000000000000L : 0L) | (bits[60] ? 0x1000000000000000L : 0L) | (bits[61] ? 0x2000000000000000L : 0L) | (bits[62] ? 0x4000000000000000L : 0L) | (bits[63] ? Long.MIN_VALUE : 0L));
        return (long)b0 | b4 | b5 | b6 | b7;
    }
}

