/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.cslib.collections;

import clashsoft.cslib.util.CSArrays;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class ArraySet<E>
extends AbstractSet<E> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private Object[] entries;
    private int initialCapacity;
    private int size = 0;
    private int currentIndex = 0;
    private transient Object[] toArray;

    public ArraySet() {
        this(16);
    }

    public ArraySet(int capacity) {
        this.initialCapacity = capacity;
        this.entries = new Object[capacity];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return CSArrays.contains(this.entries, o);
    }

    @Override
    public Iterator<E> iterator() {
        return new ArraySetIterator();
    }

    @Override
    public Object[] toArray() {
        if (this.toArray != null) {
            return this.toArray;
        }
        Object[] o = new Object[this.size];
        int i0 = 0;
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null) continue;
            o[i0] = this.entries[i];
            ++i0;
        }
        Arrays.sort(o);
        this.toArray = o;
        return o;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        for (int i = 0; i < this.size; ++i) {
            a[i] = this.entries[i];
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        if (e != null && !this.contains(e)) {
            this.ensureCapacity(++this.size);
            this.currentIndex = this.nextIndex();
            this.entries[this.currentIndex] = e;
            this.onChanged();
            return true;
        }
        return false;
    }

    protected void onChanged() {
        this.toArray = null;
    }

    protected void ensureCapacity(int minCapacity) {
        if (minCapacity - this.entries.length > 0) {
            int oldCapacity = this.entries.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = this.initialCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = ArraySet.hugeCapacity(minCapacity);
            }
            this.entries = Arrays.copyOf(this.entries, newCapacity);
        }
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    protected int nextIndex() {
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] != null) continue;
            return i;
        }
        return this.currentIndex++;
    }

    @Override
    public boolean remove(Object o) {
        int index = CSArrays.indexOf(this.entries, o);
        if (index != -1) {
            this.entries[index] = null;
            this.currentIndex = index;
            --this.size;
            this.onChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (CSArrays.contains(this.entries, object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean value = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            value = true;
        }
        return value;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator<?> iterator = c.iterator();
        Object entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (this.contains(entry)) continue;
            this.remove(entry);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean value = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            value = true;
        }
        return value;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.entries = new Object[this.initialCapacity];
        this.onChanged();
    }

    public class ArraySetIterator
    implements Iterator {
        int currentIndex = 0;

        @Override
        public boolean hasNext() {
            return this.currentIndex < ArraySet.this.size;
        }

        @Override
        public E next() {
            Object e = ArraySet.this.entries[this.currentIndex];
            ++this.currentIndex;
            return e;
        }

        @Override
        public void remove() {
            ArraySet.this.remove(ArraySet.this.entries[this.currentIndex]);
        }
    }
}

