/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.brewingapi.potion;

import clashsoft.brewingapi.potion.type.IPotionType;
import clashsoft.brewingapi.potion.type.PotionType;
import java.util.List;
import net.minecraft.item.ItemStack;

public class PotionUtils {
    public static int getGoodEffects(List<IPotionType> potion) {
        return potion.size() - PotionUtils.getBadEffects(potion);
    }

    public static int getBadEffects(List<IPotionType> potion) {
        int badEffects = 0;
        for (IPotionType pt : potion) {
            if (!pt.isBadEffect()) continue;
            ++badEffects;
        }
        return badEffects;
    }

    public static int getAverageAmplifier(List<IPotionType> potion) {
        int averageAmplifier = 0;
        for (IPotionType pt : potion) {
            averageAmplifier += pt.getAmplifier() + 1;
        }
        averageAmplifier = averageAmplifier / potion.size() - 1;
        return averageAmplifier;
    }

    public static int getAverageDuration(List<IPotionType> potion) {
        int averageDuration = 0;
        for (IPotionType pt : potion) {
            averageDuration += pt.getDuration();
        }
        return averageDuration /= potion.size();
    }

    public static int getMaxAmplifier(List<IPotionType> potion) {
        int maxAmplifier = 0;
        for (IPotionType pt : potion) {
            if (maxAmplifier >= pt.getAmplifier()) continue;
            maxAmplifier = pt.getAmplifier();
        }
        return maxAmplifier;
    }

    public static int getMaxDuration(List<IPotionType> potion) {
        int maxDuration = 0;
        for (IPotionType pt : potion) {
            if (maxDuration >= pt.getDuration()) continue;
            maxDuration = pt.getDuration();
        }
        return maxDuration;
    }

    public static float getValue(ItemStack potion) {
        return PotionType.getExperience(potion) * 100.0f / 223.9f;
    }

    public static int combineColors(int ... colors) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i : colors) {
            r += i >> 16 & 0xFF;
            g += i >> 8 & 0xFF;
            b += i >> 0 & 0xFF;
        }
        return ((r /= colors.length) & 0xFF) << 16 | ((g /= colors.length) & 0xFF) << 8 | ((b /= colors.length) & 0xFF) << 0;
    }
}

