/*
 * Decompiled with CFR 0.152.
 */
package clashsoft.brewingapi.item;

import clashsoft.brewingapi.BrewingAPI;
import clashsoft.brewingapi.entity.EntityPotion2;
import clashsoft.brewingapi.lib.AttributeModifierComparator;
import clashsoft.brewingapi.potion.PotionUtils;
import clashsoft.brewingapi.potion.type.IPotionType;
import clashsoft.brewingapi.potion.type.PotionBase;
import clashsoft.brewingapi.potion.type.PotionType;
import clashsoft.cslib.minecraft.lang.I18n;
import clashsoft.cslib.minecraft.potion.CustomPotion;
import clashsoft.cslib.util.CSString;
import com.google.common.collect.TreeMultimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.BaseAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemPotion2
extends ItemPotion {
    public Map<NBTTagCompound, List<IPotionType>> field_77836_a = new HashMap<NBTTagCompound, List<IPotionType>>();
    public IIcon bottle;
    public IIcon splashbottle;
    public IIcon liquid;
    private static int glowPos = 0;

    public ItemPotion2() {
        this.func_77625_d(BrewingAPI.potionStackSize);
        this.func_77627_a(true);
        this.func_77637_a(CreativeTabs.field_78038_k);
    }

    public List<PotionEffect> func_77832_l(ItemStack stack) {
        if (stack == null || this.isWater(stack)) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<PotionEffect> effects = new LinkedList<PotionEffect>();
        List<IPotionType> types = this.getPotionTypes(stack);
        for (IPotionType type : types) {
            PotionEffect effect = type.getEffect();
            if (effect == null) continue;
            effects.add(effect);
        }
        return effects;
    }

    public List<IPotionType> getLegacyEffects(ItemStack stack) {
        List effects = super.func_77832_l(stack);
        LinkedList<IPotionType> types = new LinkedList<IPotionType>();
        for (PotionEffect effect : effects) {
            types.add(PotionType.getFromEffect(effect));
        }
        return types;
    }

    public List<IPotionType> getPotionTypes(ItemStack stack) {
        if (stack == null || this.isWater(stack)) {
            return Collections.EMPTY_LIST;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            if (this.field_77836_a.containsKey(compound)) {
                return this.field_77836_a.get(compound);
            }
            List<IPotionType> result = PotionType.getPotionTypes(stack);
            this.field_77836_a.put(compound, result);
            return result;
        }
        return this.getLegacyEffects(stack);
    }

    public boolean hasEffects(ItemStack stack) {
        List<IPotionType> effects = this.getPotionTypes(stack);
        return effects != null && !effects.isEmpty();
    }

    public ItemStack getGlassBottle() {
        return new ItemStack(Items.field_151069_bo);
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getPotionIcon(String iconName) {
        return iconName.equals("bottle_drinkable") ? BrewingAPI.potion2.bottle : (iconName.equals("bottle_splash") ? BrewingAPI.potion2.splashbottle : (iconName.equals("overlay") ? BrewingAPI.potion2.liquid : null));
    }

    public IIcon getSplashIcon(ItemStack stack) {
        return this.splashbottle;
    }

    public boolean isSplash(ItemStack stack) {
        return this.isSplashDamage(stack.func_77960_j());
    }

    public boolean isSplashDamage(int metadata) {
        return (metadata & 2) != 0 || ItemPotion.func_77831_g((int)metadata);
    }

    public int setSplash(ItemStack stack, boolean splash) {
        int metadata = stack.func_77960_j();
        return splash ? metadata | 2 : metadata & 0xFFFFFFFD;
    }

    public boolean isWater(ItemStack stack) {
        return stack.func_77960_j() == 0;
    }

    public int getLiquidColor(ItemStack stack) {
        if (this.isWater(stack)) {
            return 789759;
        }
        List<IPotionType> effects = this.getPotionTypes(stack);
        if (effects.isEmpty()) {
            return 789759;
        }
        int[] colors = new int[effects.size()];
        for (int j = 0; j < effects.size(); ++j) {
            IPotionType b = effects.get(j);
            colors[j] = b.getLiquidColor();
        }
        return PotionUtils.combineColors(colors);
    }

    public boolean isEffectInstant(ItemStack stack) {
        List<IPotionType> effects = this.getPotionTypes(stack);
        if (effects.size() == 0) {
            return false;
        }
        boolean flag = true;
        for (IPotionType b : effects) {
            if (!b.hasEffect()) continue;
            flag &= b.isInstant();
        }
        return flag;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            for (IPotionType potionType : this.getPotionTypes(stack)) {
                potionType.apply((EntityLivingBase)player);
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                return this.getGlassBottle();
            }
            player.field_71071_by.func_70441_a(this.getGlassBottle());
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.drink;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.isSplash(stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityPotion2(world, (EntityLivingBase)player, stack));
            }
            return stack;
        }
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int metadata) {
        return this.isSplashDamage(metadata) ? this.splashbottle : this.bottle;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        return pass == 0 ? this.liquid : this.func_77617_a(stack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = this.bottle = iconRegister.func_94245_a("minecraft:potion_bottle_drinkable");
        this.splashbottle = iconRegister.func_94245_a("minecraft:potion_bottle_splash");
        this.liquid = iconRegister.func_94245_a("minecraft:potion_overlay");
    }

    public int func_82790_a(ItemStack stack, int pass) {
        return pass == 0 ? this.getLiquidColor(stack) : 0xFFFFFF;
    }

    public boolean func_77623_v() {
        return true;
    }

    public String func_77653_i(ItemStack stack) {
        if (this.isWater(stack)) {
            return I18n.getString("item.emptyPotion.name");
        }
        List<IPotionType> potionTypes = this.getPotionTypes(stack);
        ArrayList<IPotionType> effects = new ArrayList<IPotionType>();
        ArrayList<PotionBase> bases = new ArrayList<PotionBase>();
        StringBuilder result = new StringBuilder(potionTypes.size() * 20);
        if (this.isSplash(stack)) {
            result.append(I18n.getString("potion.prefix.grenade")).append(" ");
        }
        if (!potionTypes.isEmpty()) {
            if (potionTypes.size() == IPotionType.combinableTypes.size()) {
                result.insert(0, EnumChatFormatting.BLUE.toString()).append(I18n.getString("potion.alleffects.postfix"));
            } else {
                for (IPotionType pt : potionTypes) {
                    if (pt.isBase()) {
                        bases.add((PotionBase)pt);
                        continue;
                    }
                    effects.add(pt);
                }
                for (PotionBase base : bases) {
                    result.append(I18n.getString(base.getEffectName())).append(" ");
                }
                if (effects.isEmpty()) {
                    result.append(I18n.getString(this.func_77658_a() + ".name"));
                } else if (effects.size() > 4) {
                    result.append(I18n.getString("potion.potionof")).append(" ").append(effects.size()).append(" ").append(I18n.getString("potion.effects"));
                } else {
                    int size = effects.size();
                    for (int i = 0; i < size; ++i) {
                        boolean isLast;
                        IPotionType type = (IPotionType)effects.get(i);
                        boolean hasPrevious = i > 0;
                        boolean bl = isLast = i == size - 1;
                        if (!hasPrevious) {
                            result.append(I18n.getString(type.getEffectName() + ".postfix"));
                            continue;
                        }
                        if (isLast) {
                            result.append(" ").append(I18n.getString("potion.and")).append(" ");
                        } else {
                            result.append(", ");
                        }
                        result.append(I18n.getString(type.getEffectName()));
                    }
                }
            }
            return result.toString();
        }
        return StatCollector.func_74838_a((String)"item.potion.name");
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        if (!this.isWater(stack)) {
            List<IPotionType> potionTypes = this.getPotionTypes(stack);
            TreeMultimap hashmultimap = TreeMultimap.create((Comparator)String.CASE_INSENSITIVE_ORDER, (Comparator)AttributeModifierComparator.instance);
            int size = potionTypes.size();
            if (size > 0) {
                if (++glowPos > 100) {
                    glowPos = 0;
                }
                if (size > 5) {
                    glowPos = -1;
                }
                for (int i = 0; i < size; ++i) {
                    Map map;
                    String effectName;
                    boolean isNormalEffect;
                    IPotionType potionType = potionTypes.get(i);
                    Potion potion = potionType.getPotion();
                    boolean bl = isNormalEffect = !potionType.isBase();
                    if (!isNormalEffect) {
                        if (size > 1) continue;
                        effectName = EnumChatFormatting.GRAY + I18n.getString("potion.empty");
                    } else {
                        effectName = I18n.getString(potionType.getEffectName());
                    }
                    StringBuilder builder = new StringBuilder(effectName);
                    if (potion != null && (map = potion.func_111186_k()) != null && map.size() > 0) {
                        for (Object object : map.keySet()) {
                            AttributeModifier attributemodifier = (AttributeModifier)map.get(object);
                            if (attributemodifier == null) continue;
                            AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potionType.getEffect().func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                            hashmultimap.put((Object)((BaseAttribute)object).func_111108_a(), (Object)attributemodifier1);
                        }
                    }
                    if (potionType.getAmplifier() > 0) {
                        builder.append(" ").append(CSString.convertToRoman(potionType.getAmplifier() + 1));
                    }
                    if (potionType.getDuration() > 20) {
                        builder.append(" (").append(potionType.getDuration() >= 1000000 ? I18n.getString("potion.infinite") : Potion.func_76389_a((PotionEffect)potionType.getEffect())).append(")");
                    }
                    int glowPosInt = glowPos / 2;
                    if (isNormalEffect) {
                        String colorLight = "";
                        String colorDark = "";
                        if (potion instanceof CustomPotion && ((CustomPotion)potion).getCustomColor() != -1) {
                            int c = ((CustomPotion)potion).getCustomColor();
                            colorLight = "\u00a7" + Integer.toHexString(c + 8 & 0xF);
                            colorDark = "\u00a7" + Integer.toHexString(c);
                        } else if (potionType.isBadEffect()) {
                            colorLight = EnumChatFormatting.RED.toString();
                            colorDark = EnumChatFormatting.DARK_RED.toString();
                        } else {
                            colorLight = EnumChatFormatting.GREEN.toString();
                            colorDark = EnumChatFormatting.DARK_GREEN.toString();
                        }
                        builder.insert(0, colorDark);
                        if (glowPos >= 0) {
                            if ((glowPosInt += colorDark.length()) < builder.length()) {
                                builder.insert(glowPosInt, colorLight);
                            }
                            if ((glowPosInt += colorLight.length() + 1) < builder.length()) {
                                builder.insert(glowPosInt, colorDark);
                            }
                        }
                    }
                    list.add(builder.toString());
                }
                if (BrewingAPI.advancedPotionInfo && Keyboard.isKeyDown((int)58)) {
                    if (potionTypes.size() == 1 && BrewingAPI.isMorePotionsModInstalled()) {
                        for (IPotionType pt : potionTypes) {
                            if (!pt.hasEffect()) continue;
                            String description = pt.getEffectName() + ".description";
                            String localizedDescription = I18n.getString(description);
                            if (localizedDescription != description) {
                                localizedDescription = CSString.cutString(localizedDescription, stack.func_82833_r().length());
                                for (String line : CSString.lineArray(localizedDescription)) {
                                    list.add(EnumChatFormatting.BLUE.toString() + EnumChatFormatting.ITALIC.toString() + line);
                                }
                                continue;
                            }
                            list.add(EnumChatFormatting.RED.toString() + EnumChatFormatting.ITALIC.toString() + I18n.getString("potion.description.missing"));
                        }
                    }
                    if (potionTypes.size() > 1) {
                        int goodEffects = PotionUtils.getGoodEffects(potionTypes);
                        float goodEffectsPercentage = (float)goodEffects / (float)potionTypes.size() * 100.0f;
                        int badEffects = PotionUtils.getBadEffects(potionTypes);
                        float badEffectsPercentage = (float)badEffects / (float)potionTypes.size() * 100.0f;
                        int averageAmplifier = PotionUtils.getAverageAmplifier(potionTypes);
                        int averageDuration = PotionUtils.getAverageDuration(potionTypes);
                        int maxAmplifier = PotionUtils.getMaxAmplifier(potionTypes);
                        int maxDuration = PotionUtils.getMaxDuration(potionTypes);
                        StringBuilder builder = new StringBuilder(20);
                        builder.append(EnumChatFormatting.GRAY).append(EnumChatFormatting.ITALIC);
                        builder.append(I18n.getString("potion.goodeffects")).append(": ").append(EnumChatFormatting.GREEN).append(goodEffects);
                        builder.append(" (").append(String.format("%.2f", Float.valueOf(goodEffectsPercentage))).append("%)");
                        list.add(builder.toString());
                        builder.delete(4, builder.length());
                        builder.append(I18n.getString("potion.badeffects")).append(": ").append(EnumChatFormatting.RED).append(badEffects);
                        builder.append(" (").append(String.format("%.2f", Float.valueOf(badEffectsPercentage))).append("%)");
                        list.add(builder.toString());
                        builder.delete(4, builder.length());
                        builder.append(I18n.getString("potion.averageamplifier")).append(": ").append(CSString.convertToRoman(averageAmplifier));
                        list.add(builder.toString());
                        builder.delete(4, builder.length());
                        builder.append(I18n.getString("potion.maxamplifier")).append(": ").append(CSString.convertToRoman(averageAmplifier));
                        list.add(builder.toString());
                        builder.delete(4, builder.length());
                        builder.append(I18n.getString("potion.averageduration")).append(": ").append(StringUtils.func_76337_a((int)averageDuration));
                        list.add(builder.toString());
                        builder.delete(4, builder.length());
                        builder.append(I18n.getString("potion.maxduration")).append(": ").append(StringUtils.func_76337_a((int)maxDuration));
                        list.add(builder.toString());
                    }
                    if (PotionType.getExperience(stack) > 0.3f) {
                        StringBuilder value = new StringBuilder(20);
                        value.append(EnumChatFormatting.GRAY).append(EnumChatFormatting.ITALIC);
                        value.append(I18n.getString("potion.value"));
                        value.append(": ");
                        value.append(EnumChatFormatting.YELLOW).append(EnumChatFormatting.ITALIC);
                        value.append(ItemStack.field_111284_a.format(PotionUtils.getValue(stack)));
                        list.add(value.toString());
                    }
                }
                if (!hashmultimap.isEmpty()) {
                    list.add("");
                    list.add(EnumChatFormatting.DARK_PURPLE + I18n.getString("potion.effects.whenDrank"));
                    for (String key : hashmultimap.keys()) {
                        for (AttributeModifier modifier : hashmultimap.get((Object)key)) {
                            int operation = modifier.func_111169_c();
                            double amount = modifier.func_111164_d();
                            if (operation == 1 || operation == 2) {
                                amount *= 100.0;
                            }
                            if (amount > 0.0) {
                                list.add(EnumChatFormatting.BLUE + I18n.getStringParams("attribute.modifier.plus." + operation, ItemStack.field_111284_a.format(amount), I18n.getString("attribute.name." + key)));
                                continue;
                            }
                            if (!(amount < 0.0)) continue;
                            amount = -amount;
                            list.add(EnumChatFormatting.RED + I18n.getStringParams("attribute.modifier.take." + operation, ItemStack.field_111284_a.format(amount), I18n.getString("attribute.name." + key)));
                        }
                    }
                }
            } else {
                String empty = I18n.getString("potion.empty").trim();
                list.add("\u00a77" + empty);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        if (pass == 0 && stack.func_77960_j() > 0) {
            List<IPotionType> list = this.getPotionTypes(stack);
            return list != null && !list.isEmpty() && list.get(0).getEffect() != null;
        }
        return false;
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{BrewingAPI.potions, CreativeTabs.field_78038_k};
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        if (tab == CreativeTabs.field_78038_k || tab == null) {
            list.add(new ItemStack((Item)this, 1, 0));
            for (PotionBase pt : PotionBase.baseList) {
                list.add(pt.apply(new ItemStack((Item)this, 1, 1)));
                list.add(pt.apply(new ItemStack((Item)this, 1, 2)));
            }
            for (IPotionType type : IPotionType.effectTypes) {
                List<IPotionType> subTypes = type.getSubTypes();
                for (IPotionType subType : subTypes) {
                    list.add(subType.apply(new ItemStack((Item)this, 1, 1)));
                }
                subTypes = type.onGunpowderUsed().getSubTypes();
                for (IPotionType subType : subTypes) {
                    list.add(subType.apply(new ItemStack((Item)this, 1, 2)));
                }
            }
            if (BrewingAPI.isMorePotionsModInstalled() && BrewingAPI.multiPotions && tab == BrewingAPI.potions) {
                this.addMultiPotions(list);
            }
        }
    }

    public void addMultiPotions(List list) {
        ItemStack allEffects1 = new ItemStack((Item)this, 1, 1);
        ItemStack allEffects2 = new ItemStack((Item)this, 1, 2);
        ItemStack good1 = new ItemStack((Item)this, 1, 1);
        ItemStack good2 = new ItemStack((Item)this, 1, 2);
        ItemStack bad1 = new ItemStack((Item)this, 1, 1);
        ItemStack bad2 = new ItemStack((Item)this, 1, 2);
        for (IPotionType potionType : IPotionType.combinableTypes) {
            if (!potionType.isBadEffect()) {
                potionType.apply(good1);
                potionType.apply(good2);
            } else {
                potionType.apply(bad1);
                potionType.apply(bad2);
            }
            potionType.apply(allEffects1);
            potionType.apply(allEffects2);
        }
        list.add(allEffects1);
        list.add(allEffects2);
        list.add(good1);
        list.add(good2);
        list.add(bad1);
        list.add(bad2);
        for (int i = 1; i <= 2; ++i) {
            for (IPotionType pt1 : IPotionType.combinableTypes) {
                for (IPotionType pt2 : IPotionType.combinableTypes) {
                    if (pt1 == pt2) continue;
                    if (this.isSplashDamage(i)) {
                        pt1 = pt1.onGunpowderUsed();
                        pt2 = pt2.onGunpowderUsed();
                    }
                    ItemStack stack = new ItemStack((Item)this, 1, i);
                    pt1.apply(stack);
                    pt2.apply(stack);
                    list.add(stack);
                }
            }
        }
    }

    public Entity createEntity(World world, Entity entity, ItemStack stack) {
        if (entity instanceof EntityPlayer && this.isSplash(stack)) {
            if (!((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            world.func_72956_a(entity, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            EntityPotion2 e = new EntityPotion2(world, (EntityLivingBase)((EntityPlayer)entity), stack);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)e);
            }
            return e;
        }
        return null;
    }
}

