/*
 * Decompiled with CFR 0.152.
 */
package com.revereor.tileentity;

import com.revereor.enums.ExtractinatorInput;
import com.revereor.enums.ExtractinatorOutput;
import com.revereor.items.ItemChip;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityExtractinator
extends TileEntity
implements ISidedInventory {
    private ItemStack[] slots = new ItemStack[13];
    private ItemStack[] oldSlots = new ItemStack[13];
    private int extractTime;
    public int maxExtractTime = 1000;
    private static final int filled = 528;
    boolean isExtracting;
    private Item lastItem;
    public int inputValueWeight = 1;
    public boolean smelts = false;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{1};
    private static final int[] slots_sides = new int[0];

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.slots[var1];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                ItemStack newstack = stack.func_77979_a(stack.field_77994_a - amt);
                this.func_70299_a(slot, newstack);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.slots[slot] = stack;
    }

    public String func_145825_b() {
        return "Extractinator";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isExtracting() {
        return this.isExtracting;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return false;
    }

    public void func_70295_k_() {
    }

    public int extractTimeLeftRender() {
        return (int)((double)this.extractTime * (528.0 / (double)this.maxExtractTime));
    }

    public void func_70305_f() {
    }

    public void func_145845_h() {
        this.chips();
        this.extract();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || this.slots[i].field_77994_a != 0) continue;
            this.slots[i] = null;
        }
    }

    private void chips() {
        for (int i = 7; i < this.slots.length; ++i) {
            if (this.slots[i] != null) {
                if (!(this.slots[i].func_77973_b() instanceof ItemChip)) continue;
                ((ItemChip)this.slots[i].func_77973_b()).function(this);
                this.oldSlots[i] = this.slots[i];
                continue;
            }
            if (this.oldSlots == null || this.oldSlots[i] == null) continue;
            ((ItemChip)this.oldSlots[i].func_77973_b()).dump(this);
            this.oldSlots[i] = null;
        }
    }

    private void extract() {
        if (this.slots[0] != null) {
            if (ExtractinatorInput.isInput(this.slots[0].func_77973_b())) {
                if (this.getPossibleOutputs().size() > 0 || this.openSlots()) {
                    if (this.extractTime >= this.maxExtractTime) {
                        boolean added;
                        this.extractTime = 0;
                        ItemStack output = new ItemStack(ExtractinatorOutput.randomExclude(ExtractinatorInput.getEnumFromItem((Item)this.slots[0].func_77973_b()).value * this.inputValueWeight, this.getPossibleOutputs(), this.smelts));
                        if (output.func_77973_b() != null && !(added = this.add(output))) {
                            this.drop(output);
                        }
                        if (this.slots[0].field_77994_a <= 1) {
                            this.slots[0] = null;
                        } else {
                            --this.slots[0].field_77994_a;
                        }
                        return;
                    }
                    ++this.extractTime;
                } else {
                    this.extractTime = 0;
                }
            } else {
                this.extractTime = 0;
            }
        } else {
            this.extractTime = 0;
        }
    }

    private void drop(ItemStack item) {
        Random rand = new Random();
        if (item != null && item.field_77994_a > 0) {
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem((World)Minecraft.func_71410_x().field_71441_e, (double)((float)this.field_145851_c + rx), (double)((float)this.field_145848_d + ry), (double)((float)this.field_145849_e + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            Minecraft.func_71410_x().field_71441_e.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    private void remove(Item lastItem2) {
        for (int i = 1; i < this.slots.length; ++i) {
            if (this.slots[i] == null || Item.func_150891_b((Item)this.slots[i].func_77973_b()) != Item.func_150891_b((Item)lastItem2)) continue;
            --this.slots[i].field_77994_a;
        }
    }

    private boolean add(ItemStack item) {
        for (int i = 1; i < this.slots.length; ++i) {
            if (this.slots[i] == null) {
                this.func_70299_a(i, item);
                return true;
            }
            if (Item.func_150891_b((Item)this.slots[i].func_77973_b()) != Item.func_150891_b((Item)item.func_77973_b()) || this.slots[i].field_77994_a >= 64) continue;
            ++this.slots[i].field_77994_a;
            return true;
        }
        return false;
    }

    private boolean openSlots() {
        for (ItemStack slot : this.slots) {
            if (slot != null) continue;
            return true;
        }
        return false;
    }

    private ArrayList<ItemStack> getPossibleOutputs() {
        ArrayList<ItemStack> pos = new ArrayList<ItemStack>();
        for (int i = 1; i < this.slots.length; ++i) {
            if (this.slots[i] == null || this.slots[i].field_77994_a >= 64) continue;
            pos.add(this.slots[i]);
        }
        return pos;
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return var1 == 0;
    }

    public int[] func_94128_d(int var1) {
        return var1 == 0 ? slots_bottom : (var1 == 1 ? slots_top : slots_sides);
    }

    public boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return this.func_94041_b(var1, var2);
    }

    public boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return (var3 != 0 || var1 != 1) && var1 > 6;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList tagList = par1NBTTagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.slots.length) continue;
            this.slots[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.extractTime = par1NBTTagCompound.func_74762_e("timeLeft");
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            ItemStack stack = this.slots[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        par1NBTTagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        par1NBTTagCompound.func_74768_a("timeLeft", this.extractTime);
    }

    public boolean containsChip(int idFromItem) {
        for (int i = 7; i < this.slots.length; ++i) {
            if (this.slots[i] == null || Item.func_150891_b((Item)this.slots[i].func_77973_b()) != idFromItem) continue;
            return true;
        }
        return false;
    }
}

