/*
 * Decompiled with CFR 0.152.
 */
package com.revereor.enums;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public enum ExtractinatorOutput {
    COAL(Blocks.field_150365_q, 2),
    IRON(Blocks.field_150366_p, 4),
    GOLD(Blocks.field_150352_o, 14),
    DIAMOND(Blocks.field_150482_ag, 32);

    public Item item;
    public int value;

    private ExtractinatorOutput(Block bl, int value) {
        this.item = Item.func_150898_a((Block)bl);
        this.value = value;
    }

    private ExtractinatorOutput(Item bl, int value) {
        this.item = bl;
        this.value = value;
    }

    public static Item random(int influencer, boolean smelts) {
        return ExtractinatorOutput.randomExclude(influencer, new ArrayList<ItemStack>(), smelts);
    }

    public static Item randomExclude(int influencer, ArrayList<ItemStack> excluded, boolean smelts) {
        Random rand = new Random();
        Item item = null;
        for (ExtractinatorOutput out : ExtractinatorOutput.values()) {
            ItemStack result;
            if (ExtractinatorOutput.contains(out.item, excluded)) continue;
            int value = out.value;
            if (influencer > value) {
                value *= influencer;
            } else if (influencer != value) {
                value /= influencer;
            }
            if (rand.nextInt(value) != 0) continue;
            item = out.item;
            if (!smelts || (result = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(item))) == null) continue;
            item = result.func_77973_b();
        }
        return item;
    }

    private static boolean contains(Item item2, ArrayList<ItemStack> excluded) {
        for (ItemStack item : excluded) {
            if (Item.func_150891_b((Item)item.func_77973_b()) != Item.func_150891_b((Item)item2) || item.field_77994_a < 64) continue;
            return true;
        }
        return false;
    }
}

