/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.me.tiles.ICraftingTracker;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.util.ICraftingPattern;
import appeng.api.me.util.ICraftingPatternMAC;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.ITileCraftingProvider;
import extracells.Extracells;
import extracells.ItemEnum;
import extracells.util.ECPrivateInventory;
import extracells.util.ECPrivatePatternInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityFluidCrafter
extends TileEntity
implements ITileCraftingProvider,
IGridMachine {
    private List<ICraftingPattern> patternHandlers = new ArrayList<ICraftingPattern>();
    private ItemStack currentRequest = null;
    private ECPrivatePatternInventory patternInventory = new ECPrivatePatternInventory("", 9, 64, (IGridTileEntity)this);
    private ECPrivateInventory bufferInventory = new ECPrivateInventory("", 18, 10000);
    private IGridInterface grid;
    private boolean powerStatus = false;
    private boolean networkStatus = true;
    private int currentTick = 0;
    private final int tickRate = Extracells.tickRateChamber;

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            ++this.currentTick;
            if (this.currentTick == this.tickRate) {
                this.currentTick = 0;
                this.doUpdateEntity();
            }
        }
    }

    public void doUpdateEntity() {
        if (this.grid != null && this.isMachineActive() && this.grid.getCellArray() != null) {
            for (ICraftingPattern pattern : this.patternHandlers) {
                if (!this.itemsForPatternExist(pattern)) continue;
                for (ItemStack stack : pattern.getRequirements()) {
                    this.removeItems(stack);
                }
                this.grid.getCellArray().addItems(Util.createItemStack((ItemStack)pattern.getOutput()));
            }
        }
    }

    public void removeItems(ItemStack stack) {
        for (int i = 0; i < this.bufferInventory.slots.size(); ++i) {
            ItemStack item;
            ItemStack itemStack = item = this.bufferInventory.func_70301_a(i) != null ? this.bufferInventory.func_70301_a(i).func_77946_l() : null;
            if (item == null || !item.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)item)) continue;
            if (item.field_77994_a > stack.field_77994_a) {
                item.field_77994_a -= stack.field_77994_a;
                this.bufferInventory.slots.set(i, item);
                continue;
            }
            if (item.field_77994_a != stack.field_77994_a) continue;
            this.bufferInventory.slots.set(i, null);
        }
    }

    public boolean itemsForPatternExist(ICraftingPattern pattern) {
        for (ItemStack stack : pattern.getRequirements()) {
            if (this.itemContainedInInventory(stack, pattern)) continue;
            return false;
        }
        return true;
    }

    public boolean itemContainedInInventory(ItemStack items, ICraftingPattern pattern) {
        for (ItemStack stack : this.bufferInventory.slots) {
            if (stack == null || !stack.func_77969_a(items) || !ItemStack.func_77970_a((ItemStack)items, (ItemStack)stack) || stack.field_77994_a < items.field_77994_a) continue;
            return true;
        }
        return false;
    }

    public void func_70312_q() {
        super.func_70312_q();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public void func_70313_j() {
        super.func_70313_j();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public boolean isBusy() {
        return this.currentRequest != null;
    }

    public ItemStack pushItem(ItemStack out) {
        if (this.canPushItem(out)) {
            ItemStack rejected = null;
            for (int i = 0; i < this.bufferInventory.slots.size(); ++i) {
                ItemStack stack;
                ItemStack itemStack = stack = this.bufferInventory.func_70301_a(i) != null ? this.bufferInventory.func_70301_a(i).func_77946_l() : null;
                if (stack == null) {
                    this.bufferInventory.slots.set(i, out);
                    if (!out.func_77973_b().func_77630_h(out)) {
                        this.grid.getCellArray().addItems(Util.createItemStack((ItemStack)out));
                    }
                    return rejected;
                }
                if (!stack.func_77969_a(out) || !ItemStack.func_77970_a((ItemStack)out, (ItemStack)stack)) continue;
                stack.field_77994_a += out.field_77994_a;
                if (!out.func_77973_b().func_77630_h(out)) {
                    this.grid.getCellArray().addItems(Util.createItemStack((ItemStack)out));
                }
                this.bufferInventory.slots.set(i, stack);
                return rejected;
            }
        }
        return out;
    }

    public boolean canPushItem(ItemStack out) {
        return out != null;
    }

    public void provideCrafting(ICraftingTracker craftingTracker) {
        this.patternHandlers = new ArrayList<ICraftingPattern>();
        for (ItemStack currentPatternStack : this.patternInventory.slots) {
            ICraftingPatternMAC currentPattern;
            if (currentPatternStack == null || (currentPattern = Util.getAssemblerPattern((ItemStack)currentPatternStack)) == null) continue;
            this.convertToRequirementsToFluid(currentPattern.getRequirements());
            this.patternHandlers.add((ICraftingPattern)currentPattern);
            craftingTracker.addCraftingOption((ITileCraftingProvider)this, (ICraftingPattern)currentPattern);
        }
    }

    public void convertToRequirementsToFluid(List<ItemStack> requirements) {
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>();
        for (ItemStack currentRequirement : requirements) {
            if (currentRequirement == null) continue;
            FluidStack fluid = null;
            if (FluidContainerRegistry.isFilledContainer((ItemStack)currentRequirement)) {
                fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)currentRequirement);
            } else if (currentRequirement.func_77973_b() instanceof IFluidContainerItem) {
                fluid = ((IFluidContainerItem)currentRequirement.func_77973_b()).getFluid(currentRequirement);
            }
            if (fluid == null) continue;
            toAdd.add(new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), fluid.amount, fluid.fluidID));
            toRemove.add(currentRequirement);
        }
        for (ItemStack currentRequirement : toRemove) {
            requirements.remove(currentRequirement);
        }
        for (ItemStack currentRequirement : toAdd) {
            requirements.add(currentRequirement);
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74782_a("BufferItems", (NBTBase)this.bufferInventory.writeToNBT());
        nbt.func_74782_a("InventoryItems", (NBTBase)this.patternInventory.writeToNBT());
        if (this.getInventory().func_94042_c()) {
            nbt.func_74778_a("BufferItemsName", this.bufferInventory.customName);
            nbt.func_74778_a("InventoryItemsName", this.patternInventory.customName);
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList bufferList = nbt.func_74761_m("BufferItems");
        NBTTagList patternList = nbt.func_74761_m("InventoryItems");
        this.bufferInventory.readFromNBT(bufferList);
        this.patternInventory.readFromNBT(patternList);
        if (nbt.func_74764_b("BufferItemsName")) {
            this.bufferInventory.customName = nbt.func_74779_i("BufferItemsName");
        }
        if (nbt.func_74764_b("InventoryItemsName")) {
            this.patternInventory.customName = nbt.func_74779_i("InventoryItemsName");
        }
    }

    public ECPrivateInventory getInventory() {
        return this.patternInventory;
    }

    public WorldCoord getLocation() {
        return new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isValid() {
        return true;
    }

    public void setPowerStatus(boolean hasPower) {
        this.powerStatus = hasPower;
    }

    public boolean isPowered() {
        return this.powerStatus;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setGrid(IGridInterface gi) {
        this.grid = gi;
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public float getPowerDrainPerTick() {
        return 10.0f;
    }

    public void setNetworkReady(boolean isReady) {
        this.networkStatus = isReady;
    }

    public boolean isMachineActive() {
        return this.networkStatus && this.powerStatus;
    }
}

