/*
 * Decompiled with CFR 0.152.
 */
package extracells.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import extracells.network.packet.PacketBusFluidExport;
import extracells.network.packet.PacketBusFluidImport;
import extracells.network.packet.PacketBusFluidStorage;
import extracells.network.packet.PacketLevelEmitterFluid;
import extracells.network.packet.PacketMEBattery;
import extracells.network.packet.PacketMonitorFluid;
import extracells.network.packet.PacketSolderingStation;
import extracells.network.packet.PacketTerminalFluid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;

public abstract class AbstractPacket {
    public static final String CHANNEL = "ExtraCells";
    private static final BiMap<Integer, Class<? extends AbstractPacket>> idMap;

    public static AbstractPacket constructPacket(int packetId) throws ProtocolException, Throwable {
        Class clazz = (Class)idMap.get((Object)packetId);
        if (clazz == null) {
            throw new ProtocolException("Unknown Packet Id!");
        }
        return (AbstractPacket)clazz.newInstance();
    }

    public final int getPacketId() {
        if (idMap.inverse().containsKey(this.getClass())) {
            return (Integer)idMap.inverse().get(this.getClass());
        }
        throw new RuntimeException("Packet " + this.getClass().getSimpleName() + " is missing a mapping!");
    }

    public final Packet makePacket() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeByte(this.getPacketId());
        this.write(out);
        return PacketDispatcher.getPacket((String)CHANNEL, (byte[])out.toByteArray());
    }

    public abstract void write(ByteArrayDataOutput var1);

    public abstract void read(ByteArrayDataInput var1) throws ProtocolException;

    public abstract void execute(EntityPlayer var1, Side var2) throws ProtocolException;

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)0, PacketSolderingStation.class);
        builder.put((Object)1, PacketMonitorFluid.class);
        builder.put((Object)2, PacketMEBattery.class);
        builder.put((Object)3, PacketBusFluidImport.class);
        builder.put((Object)4, PacketBusFluidExport.class);
        builder.put((Object)5, PacketBusFluidStorage.class);
        builder.put((Object)6, PacketLevelEmitterFluid.class);
        builder.put((Object)7, PacketTerminalFluid.class);
        idMap = builder.build();
    }

    public static class ProtocolException
    extends Exception {
        public ProtocolException() {
        }

        public ProtocolException(String message, Throwable cause) {
            super(message, cause);
        }

        public ProtocolException(String message) {
            super(message);
        }

        public ProtocolException(Throwable cause) {
            super(cause);
        }
    }
}

