/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui.widget;

import cpw.mods.fml.common.network.PacketDispatcher;
import extracells.Extracells;
import extracells.gui.GuiTerminalFluid;
import extracells.gui.widget.AbstractFluidWidget;
import extracells.network.packet.PacketTerminalFluid;
import extracells.tileentity.TileEntityTerminalFluid;
import extracells.util.SpecialFluidStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.network.packet.Packet;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class WidgetFluidSelector
extends AbstractFluidWidget {
    private long amount = 0L;
    private int color;
    private int borderThickness;
    private boolean selected = false;

    public WidgetFluidSelector(GuiTerminalFluid guiTerminalFluid, SpecialFluidStack stack) {
        super(guiTerminalFluid, 18, 18, stack.getFluidStack().getFluid());
        this.amount = stack.getAmount();
        this.color = -16711681;
        this.borderThickness = 1;
    }

    @Override
    public void drawWidget(int posX, int posY) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glDisable((int)2896);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.fluid != null && this.fluid.getIcon() != null) {
            this.func_94065_a(posX + 1, posY + 1, this.fluid.getIcon(), this.sizeX - 2, this.sizeY - 2);
        }
        if (this.selected) {
            this.drawHollowRectWithCorners(posX, posY, this.sizeX, this.sizeY, this.color, this.borderThickness);
        }
        GL11.glEnable((int)2896);
    }

    @Override
    public void drawTooltip(int posX, int posY, int mouseX, int mouseY) {
        if (this.fluid != null && this.isPointInRegion(posX, posY, this.sizeX, this.sizeY, mouseX, mouseY) && this.amount > 0L && this.fluid != null) {
            boolean shiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            String amountToText = Long.toString(this.amount) + "mB";
            if (Extracells.shortenedBuckets) {
                if (this.amount > 1000000000L) {
                    amountToText = shiftDown ? Long.toString(this.amount / 1000000L) + "KiloB" : Long.toString(this.amount / 1000000000L) + "MegaB";
                } else if (this.amount > 1000000L) {
                    amountToText = shiftDown ? Long.toString(this.amount / 1000L) + "B" : Long.toString(this.amount / 1000000L) + "KiloB";
                } else if (this.amount > 9999L) {
                    amountToText = Long.toString(this.amount / 1000L) + "B";
                }
            }
            ArrayList<String> description = new ArrayList<String>();
            description.add(this.fluid.getLocalizedName());
            description.add(amountToText);
            this.drawHoveringText(description, mouseX - this.guiTerminalFluid.guiLeft(), mouseY - this.guiTerminalFluid.guiTop(), Minecraft.func_71410_x().field_71466_p);
        }
    }

    @Override
    public void mouseClicked(int posX, int posY, int mouseX, int mouseY) {
        if (this.fluid != null && this.isPointInRegion(posX, posY, this.sizeX, this.sizeY, mouseX, mouseY)) {
            TileEntityTerminalFluid terminalFluid = this.guiTerminalFluid.tileEntity;
            PacketDispatcher.sendPacketToServer((Packet)new PacketTerminalFluid(terminalFluid.field_70331_k, terminalFluid.field_70329_l, terminalFluid.field_70330_m, terminalFluid.field_70327_n, this.fluid).makePacket());
            this.selected = true;
            this.guiTerminalFluid.updateSelected(this);
            this.guiTerminalFluid.currentFluidAmount = this.amount;
            this.guiTerminalFluid.currentFluidName = this.fluid.getLocalizedName();
        }
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    private void drawHollowRectWithCorners(int posX, int posY, int sizeX, int sizeY, int color, int thickness) {
        WidgetFluidSelector.func_73734_a((int)posX, (int)posY, (int)(posX + sizeX), (int)(posY + thickness), (int)color);
        WidgetFluidSelector.func_73734_a((int)posX, (int)(posY + sizeY - thickness), (int)(posX + sizeX), (int)(posY + sizeY), (int)color);
        WidgetFluidSelector.func_73734_a((int)posX, (int)posY, (int)(posX + thickness), (int)(posY + sizeY), (int)color);
        WidgetFluidSelector.func_73734_a((int)(posX + sizeX - thickness), (int)posY, (int)(posX + sizeX), (int)(posY + sizeY), (int)color);
        WidgetFluidSelector.func_73734_a((int)posX, (int)posY, (int)(posX + thickness + 1), (int)(posY + thickness + 1), (int)color);
        WidgetFluidSelector.func_73734_a((int)(posX + sizeX), (int)(posY + sizeY), (int)(posX + sizeX - thickness - 1), (int)(posY + sizeY - thickness - 1), (int)color);
        WidgetFluidSelector.func_73734_a((int)(posX + sizeX), (int)posY, (int)(posX + sizeX - thickness - 1), (int)(posY + thickness + 1), (int)color);
        WidgetFluidSelector.func_73734_a((int)posX, (int)(posY + sizeY), (int)(posX + thickness + 1), (int)(posY + sizeY - thickness - 1), (int)color);
    }
}

