/*
 * Decompiled with CFR 0.152.
 */
package extracells.blocks;

import appeng.api.Materials;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.Extracells;
import extracells.blocks.RotatableColorBlock;
import extracells.tileentity.TileEntityMonitorStorageFluid;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class BlockMonitorStorageFluid
extends RotatableColorBlock {
    @SideOnly(value=Side.CLIENT)
    Icon frontIcon;
    @SideOnly(value=Side.CLIENT)
    Icon topIcon;
    @SideOnly(value=Side.CLIENT)
    Icon sideIcon;
    @SideOnly(value=Side.CLIENT)
    Icon bottomIcon;
    @SideOnly(value=Side.CLIENT)
    public Icon baseLayer;
    @SideOnly(value=Side.CLIENT)
    public Icon[] colorLayers;

    public BlockMonitorStorageFluid(int id) {
        super(id, Material.field_76246_e);
        this.func_71849_a(Extracells.ModTab);
        this.func_71864_b("block.fluid.monitor.storage");
        this.func_71848_c(2.0f);
        this.func_71894_b(10.0f);
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float offsetX, float offsetY, float offsetZ) {
        TileEntity te;
        super.func_71903_a(world, x, y, z, player, side, offsetX, offsetY, offsetZ);
        if (!world.field_72995_K && (te = world.func_72796_p(x, y, z)) instanceof TileEntityMonitorStorageFluid) {
            TileEntityMonitorStorageFluid monitorTE = (TileEntityMonitorStorageFluid)te;
            ItemStack currItem = player.func_71045_bC();
            if (currItem != null) {
                ItemStack toAdd;
                if (!monitorTE.isMatrixed() && currItem.func_77969_a(Materials.matConversionMatrix)) {
                    monitorTE.setMatrixed();
                    --currItem.field_77994_a;
                    if (currItem.field_77994_a <= 0) {
                        currItem = null;
                    }
                    return true;
                }
                if (!monitorTE.isLocked()) {
                    if (currItem.func_77973_b() instanceof IFluidContainerItem) {
                        FluidStack fluid = ((IFluidContainerItem)currItem.func_77973_b()).getFluid(currItem);
                        monitorTE.setFluid(fluid != null ? fluid.getFluid() : null);
                    } else if (FluidContainerRegistry.isFilledContainer((ItemStack)currItem)) {
                        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)currItem);
                        monitorTE.setFluid(fluid != null ? fluid.getFluid() : null);
                    } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)currItem)) {
                        monitorTE.setFluid(null);
                    }
                } else if (monitorTE.isMatrixed() && (toAdd = monitorTE.fillContainer(currItem.func_77946_l())) != null) {
                    ForgeDirection orientation = ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z));
                    this.func_71929_a(world, x + orientation.offsetX, y + orientation.offsetY, z + orientation.offsetZ, toAdd);
                    --currItem.field_77994_a;
                    if (currItem.field_77994_a <= 0) {
                        currItem = null;
                    }
                }
            } else if (player.func_70093_af()) {
                if (!monitorTE.isLocked()) {
                    monitorTE.setLocked(true);
                    player.func_70006_a(new ChatMessageComponent().func_111079_a(StatCollector.func_74838_a((String)"ChatMsg.Locked")));
                } else {
                    monitorTE.setLocked(false);
                    player.func_70006_a(new ChatMessageComponent().func_111079_a(StatCollector.func_74838_a((String)"ChatMsg.Unlocked")));
                }
            } else if (!player.func_70093_af() && !monitorTE.isLocked()) {
                monitorTE.setFluid(null);
            }
        }
        return true;
    }

    public int func_71857_b() {
        return Extracells.renderID;
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityMonitorStorageFluid();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconregister) {
        this.frontIcon = iconregister.func_94245_a("extracells:fluid.monitor.hotbar");
        this.sideIcon = iconregister.func_94245_a("extracells:machine.side");
        this.bottomIcon = iconregister.func_94245_a("extracells:machine.bottom");
        this.topIcon = iconregister.func_94245_a("extracells:machine.top");
        this.baseLayer = iconregister.func_94245_a("extracells:fluid.monitor.layerbase");
        this.colorLayers = new Icon[]{iconregister.func_94245_a("extracells:fluid.monitor.layer3"), iconregister.func_94245_a("extracells:fluid.monitor.layer2"), iconregister.func_94245_a("extracells:fluid.monitor.layer1")};
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        return side == 3 ? this.frontIcon : (side == 0 ? this.bottomIcon : (side == 1 ? this.topIcon : this.sideIcon));
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity tileentity = blockAccess.func_72796_p(x, y, z);
        int metadata = blockAccess.func_72805_g(x, y, z);
        if (tileentity != null) {
            return side == metadata ? this.baseLayer : (side == 0 ? this.bottomIcon : (side == 1 ? this.topIcon : this.sideIcon));
        }
        return null;
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList items = super.getBlockDropped(world, x, y, z, metadata, fortune);
        TileEntity blockTE = world.func_72796_p(x, y, z);
        if (blockTE instanceof TileEntityMonitorStorageFluid && ((TileEntityMonitorStorageFluid)blockTE).isMatrixed()) {
            items.add(Materials.matConversionMatrix.func_77946_l());
        }
        return items;
    }
}

