/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.WorldCoord;
import appeng.api.config.ItemFlow;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.IMEPowerStorage;
import appeng.api.me.util.IGridInterface;
import appeng.api.networkevents.MENetworkEvent;
import appeng.api.networkevents.MENetworkPowerStorage;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityMEBattery
extends TileEntity
implements IGridTileEntity,
IMEPowerStorage {
    private double energy = 0.0;
    private final double maxEnergy = 2000000.0;
    private boolean powerStatus = true;
    private boolean networkReady = true;
    private IGridInterface grid;
    private boolean redstoneCached = false;
    public boolean redstonePowered = false;

    public void func_70316_g() {
        if (!this.redstoneCached) {
            this.redstoneCached = true;
            this.updateRedstone();
        }
    }

    public void updateRedstone() {
        boolean newRedstone;
        boolean bl = newRedstone = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) || this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
        if (newRedstone != this.redstonePowered && this.grid != null) {
            if (this.energy > 0.001) {
                this.getGrid().postEvent((MENetworkEvent)new MENetworkPowerStorage((IGridTileEntity)this, MENetworkPowerStorage.PowerEventType.PROVIDE_POWER));
            } else if (this.energy < 2000000.0) {
                this.getGrid().postEvent((MENetworkEvent)new MENetworkPowerStorage((IGridTileEntity)this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
        }
        this.redstonePowered = newRedstone;
    }

    public void updateGuiTile(String playername) {
        Player player = (Player)this.field_70331_k.func_72924_a(playername);
        if (!this.field_70331_k.field_72995_K) {
            PacketDispatcher.sendPacketToPlayer((Packet)this.func_70319_e(), (Player)player);
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_70310_b(nbtTag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    public void func_70312_q() {
        super.func_70312_q();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public void func_70313_j() {
        super.func_70313_j();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.energy = nbt.func_74769_h("storedEnergy");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74780_a("storedEnergy", this.energy);
    }

    public WorldCoord getLocation() {
        return new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isValid() {
        return true;
    }

    public void setPowerStatus(boolean hasPower) {
        this.powerStatus = hasPower;
    }

    public boolean isPowered() {
        return this.powerStatus;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setGrid(IGridInterface gi) {
        this.grid = gi;
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public void setNetworkReady(boolean isReady) {
        this.networkReady = isReady;
    }

    public boolean isMachineActive() {
        return this.powerStatus && this.networkReady;
    }

    public boolean useMEEnergy(float use, String for_what) {
        if (this.energy > (double)use) {
            this.energy -= (double)use;
            this.onUpdatePower();
            return true;
        }
        this.energy = 0.0;
        this.onUpdatePower();
        return false;
    }

    public double addMEPower(double amt) {
        if (this.getGrid() == null || !this.canFill()) {
            return amt;
        }
        boolean wasEmpty = this.energy < 0.001;
        this.energy += amt;
        if (this.energy > this.getMEMaxPower()) {
            double overheadPower = this.energy - this.getMEMaxPower();
            this.energy = this.getMEMaxPower();
            this.onUpdatePower();
            return overheadPower;
        }
        if (wasEmpty && this.energy > 0.001) {
            this.getGrid().postEvent((MENetworkEvent)new MENetworkPowerStorage((IGridTileEntity)this, MENetworkPowerStorage.PowerEventType.PROVIDE_POWER));
        }
        this.onUpdatePower();
        return 0.0;
    }

    public double getMEMaxPower() {
        return 2000000.0;
    }

    public double getMECurrentPower() {
        return this.energy;
    }

    public boolean isPublicPowerStorage() {
        return true;
    }

    public ItemFlow getPowerFlow() {
        return ItemFlow.READ_WRITE;
    }

    public double drainMEPower(double amt) {
        if (this.getGrid() == null || !this.canDrain()) {
            return 0.0;
        }
        boolean wasFull = this.energy >= 2000000.0;
        this.energy -= amt;
        if (this.energy < 0.0) {
            amt += this.energy;
            this.energy = 0.0;
        }
        if (this.energy < 2000000.0 && wasFull) {
            this.getGrid().postEvent((MENetworkEvent)new MENetworkPowerStorage((IGridTileEntity)this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
        }
        this.onUpdatePower();
        return amt;
    }

    public boolean canDrain() {
        return this.redstonePowered;
    }

    public boolean canFill() {
        return this.redstonePowered;
    }

    void onUpdatePower() {
        PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
        if (this.field_70331_k != null) {
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }
}

