/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.IStorageAware;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.PacketDispatcher;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import dan200.computer.api.IPeripheral;
import extracells.ItemEnum;
import extracells.integration.logisticspipes.IFluidNetworkAccess;
import extracells.items.ItemFluidDisplay;
import extracells.tileentity.ColorableECTile;
import extracells.util.ECPrivateInventory;
import extracells.util.SpecialFluidStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Optional.Interface(modid="ComputerCraft", iface="dan200.computer.api.IPeripheral")
public class TileEntityInterfaceFluid
extends ColorableECTile
implements IGridMachine,
IFluidHandler,
IStorageAware,
IFluidNetworkAccess,
IPeripheral {
    private boolean powerStatus = true;
    private boolean networkReady = true;
    private boolean cached = false;
    private IGridInterface grid;
    public FluidTank[] tanks = new FluidTank[6];
    private String customName = StatCollector.func_74838_a((String)"tile.block.fluid.interface");
    private ECPrivateInventory inventory = new ECPrivateInventory(this.customName, 6, 1);
    private List<SpecialFluidStack> fluidList = new ArrayList<SpecialFluidStack>();

    public TileEntityInterfaceFluid() {
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(10000){

                public FluidTank readFromNBT(NBTTagCompound nbt) {
                    if (!nbt.func_74764_b("Empty")) {
                        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                        this.setFluid(fluid);
                    } else {
                        this.setFluid(null);
                    }
                    return this;
                }
            };
        }
    }

    public void onNeighborBlockChange() {
    }

    public void func_70316_g() {
        if (!this.cached && this.grid != null) {
            this.onNeighborBlockChange();
            this.cached = !this.cached;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            int filled;
            Fluid filterFluid;
            FluidTank tank = this.tanks[i];
            FluidStack tankFluid = this.tanks[i].getFluid();
            Fluid fluid = filterFluid = this.inventory.slots.get(i) != null ? FluidRegistry.getFluid((int)this.inventory.slots.get(i).func_77960_j()) : null;
            if (filterFluid == null) {
                if (tankFluid == null || (filled = (int)this.fillToNetwork(tank.drain(20, false), true)) <= 0) continue;
                tank.drain(filled, true);
                PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
                continue;
            }
            if (tank.getFluid() == null || tank.getFluid().getFluid() == filterFluid) {
                int drained;
                if (tank.getFluid() != null && tank.getFluid().amount >= 10000 || (drained = (int)this.drainFromNetwork(new FluidStack(filterFluid, tank.fill(new FluidStack(filterFluid, 20), false)), true)) <= 0) continue;
                tank.fill(new FluidStack(filterFluid, drained), true);
                PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
                continue;
            }
            filled = (int)this.fillToNetwork(tank.drain(20, false), true);
            if (filled <= 0) continue;
            tank.drain(filled, true);
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
        }
    }

    public ECPrivateInventory getInventory() {
        return this.inventory;
    }

    public void func_70312_q() {
        super.func_70312_q();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public void func_70313_j() {
        super.func_70313_j();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList nbttaglist = nbt.func_74761_m("Items");
        this.inventory.readFromNBT(nbttaglist);
        if (nbt.func_74764_b("CustomName")) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound tankNBT = nbt.func_74775_l("tank#" + i);
            this.tanks[i].readFromNBT(tankNBT);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74782_a("Items", (NBTBase)this.inventory.writeToNBT());
        if (this.getInventory().func_94042_c()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound tankNBT = new NBTTagCompound();
            this.tanks[i].writeToNBT(tankNBT);
            nbt.func_74766_a("tank#" + i, tankNBT);
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = this.getColorDataForPacket();
        this.func_70310_b(nbtTag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        super.onDataPacket(net, packet);
        this.func_70307_a(packet.field_73331_e);
    }

    public WorldCoord getLocation() {
        return new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isValid() {
        return true;
    }

    public void setPowerStatus(boolean hasPower) {
        this.powerStatus = hasPower;
    }

    public boolean isPowered() {
        return this.powerStatus;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setGrid(IGridInterface gi) {
        this.grid = gi;
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public float getPowerDrainPerTick() {
        return 5.0f;
    }

    public void setNetworkReady(boolean isReady) {
        this.networkReady = isReady;
    }

    public boolean isMachineActive() {
        return this.powerStatus && this.networkReady;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from == ForgeDirection.UNKNOWN || resource == null) {
            return 0;
        }
        int filled = 0;
        if ((filled = (int)((long)filled + this.fillToNetwork(resource, doFill))) < resource.amount) {
            filled += this.tanks[from.ordinal()].fill(new FluidStack(resource.fluidID, resource.amount - filled), doFill);
        }
        if (filled > 0) {
            PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
        }
        return filled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidStack tankFluid = this.tanks[from.ordinal()].getFluid();
        if (resource == null || tankFluid == null || tankFluid.getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.UNKNOWN) {
            return null;
        }
        FluidStack drained = this.tanks[from.ordinal()].drain(maxDrain, doDrain);
        if (drained != null) {
            PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
        }
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UNKNOWN && this.tanks[from.ordinal()].fill(new FluidStack(fluid, 1), false) > 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.UNKNOWN) {
            return false;
        }
        FluidStack tankFluid = this.tanks[from.ordinal()].getFluid();
        return tankFluid != null && tankFluid.getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == ForgeDirection.UNKNOWN) {
            return null;
        }
        return new FluidTankInfo[]{this.tanks[from.ordinal()].getInfo()};
    }

    public void onNetworkInventoryChange(IItemList iss) {
        this.fluidList = new ArrayList<SpecialFluidStack>();
        if (iss != null) {
            for (IAEItemStack stack : iss) {
                if (stack == null || stack.getItem() != ItemEnum.FLUIDDISPLAY.getItemInstance()) continue;
                this.fluidList.add(new SpecialFluidStack(stack.getItemDamage(), stack.getStackSize()));
            }
        }
    }

    @Override
    public List<SpecialFluidStack> getFluidsInNetwork() {
        if (!this.isMachineActive() || this.grid == null || this.grid.getCellArray() == null) {
            return null;
        }
        return this.fluidList;
    }

    @Override
    public long drainFromNetwork(FluidStack toDrain, boolean doDrain) {
        if (!this.isMachineActive() || toDrain == null || this.grid == null) {
            return 0L;
        }
        IMEInventoryHandler cellArray = this.grid.getCellArray();
        if (cellArray == null) {
            return 0L;
        }
        IAEItemStack drained = cellArray.extractItems(this.createFluidItemStack(toDrain));
        if (drained == null) {
            return 0L;
        }
        if (!doDrain) {
            cellArray.addItems(drained);
        }
        this.getGrid().useMEEnergy(drained.getStackSize() == 0L ? 0.0f : (float)(drained.getStackSize() / 4L), "FluidInterface");
        return drained.getStackSize();
    }

    @Override
    public long fillToNetwork(FluidStack toFill, boolean doFill) {
        if (!this.isMachineActive() || toFill == null || this.grid == null) {
            return 0L;
        }
        IMEInventoryHandler cellArray = this.grid.getCellArray();
        if (cellArray == null) {
            return 0L;
        }
        IAEItemStack notFilled = cellArray.calculateItemAddition(this.createFluidItemStack(toFill));
        IAEItemStack filled = this.createFluidItemStack(toFill);
        if (notFilled != null) {
            filled = this.createFluidItemStack(new SpecialFluidStack(notFilled.getItemDamage(), (long)toFill.amount - notFilled.getStackSize()));
        }
        if (doFill) {
            cellArray.addItems(filled);
        }
        this.getGrid().useMEEnergy(filled.getStackSize() == 0L ? 0.0f : (float)(filled.getStackSize() / 4L), "FluidInterface");
        return filled.getStackSize();
    }

    @Override
    public TileEntity getNetworkController() {
        if (!this.isMachineActive() || this.grid == null) {
            return null;
        }
        return this.grid.getController();
    }

    public IAEItemStack createFluidItemStack(SpecialFluidStack stack) {
        IAEItemStack toReturn = Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1, stack.getID()));
        toReturn.setStackSize(stack.getAmount());
        return toReturn;
    }

    public IAEItemStack createFluidItemStack(FluidStack stack) {
        return this.createFluidItemStack(new SpecialFluidStack(stack.fluidID, (long)stack.amount));
    }

    public List<Fluid> getOrderableFluids() {
        return new ArrayList<Fluid>();
    }

    public void orderFluid(FluidStack fluid) {
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "fluidPeripheral";
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"listMethods", "getStoredFluids", "getStoredAmount"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        if (method == 0) {
            return this.getMethodNames();
        }
        if (method == 1) {
            HashMap storedFluids = new HashMap();
            for (IAEItemStack stck : this.grid.getCellArray().getAvailableItems()) {
                if (stck == null || !(stck.getItem() instanceof ItemFluidDisplay)) continue;
                Fluid fluid = FluidRegistry.getFluid((int)stck.getItemDamage());
                HashMap<String, Long> innerMap = new HashMap<String, Long>();
                innerMap.put("amount", this.grid.getCellArray().countOfItemType(stck));
                storedFluids.put(fluid.getName(), innerMap);
            }
            return new Object[]{storedFluids};
        }
        if (method == 2) {
            if (arguments.length < 1 || arguments.length > 1) {
                return new Object[]{"ERROR: getStoredAmount(String fluid)"};
            }
            Fluid fluid = FluidRegistry.getFluid((String)((String)arguments[0]));
            if (fluid == null) {
                return new Object[]{"Couldn't find that fluid, check the name!"};
            }
            ItemStack is = new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance().field_77779_bT, 1, fluid.getID());
            if (is == null) {
                return new Object[]{"ItemStack corrupted!"};
            }
            return new Object[]{this.grid.getCellArray().countOfItemType(Util.createItemStack((ItemStack)is))};
        }
        return new Object[0];
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }
}

